/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.objects.surface3d;

import java.awt.Color;
import java.util.Iterator;
import uibk.mtk.draw3d.objects.surface3d.ColorModel;
import uibk.mtk.draw3d.objects.surface3d.Vertex3D;
import uibk.mtk.geom.CoordinateBox3D;
import uibk.mtk.math.MathUtil;

public class ColorModelZ
extends ColorModel {
    private Color colormin = new Color(0, 0, 220);
    private Color colormax = new Color(220, 10, 20);

    @Override
    public void colorVertices(Iterator it, CoordinateBox3D cube) {
        int red_min = this.colormin.getRed();
        int red_max = this.colormax.getRed();
        int blue_min = this.colormin.getBlue();
        int blue_max = this.colormax.getBlue();
        int green_min = this.colormin.getGreen();
        int green_max = this.colormax.getGreen();
        while (it.hasNext()) {
            Vertex3D vertex = (Vertex3D)it.next();
            int r = (int)MathUtil.interpolate(cube.zmin, cube.zmax, (double)red_min, (double)red_max, vertex.mc.x3);
            int g = (int)MathUtil.interpolate(cube.zmin, cube.zmax, (double)green_min, (double)green_max, vertex.mc.x3);
            int b = (int)MathUtil.interpolate(cube.zmin, cube.zmax, (double)blue_min, (double)blue_max, vertex.mc.x3);
            vertex.color = new Color(r, g, b);
        }
    }

    public void setColorMin(Color min) {
        this.colormin = new Color(min.getRGB());
    }

    public void setColorMax(Color max) {
        this.colormax = new Color(max.getRGB());
    }
}

