/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.surface3d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.surface3d.AppletSurface3D;
import uibk.applets.surface3d.Messages;
import uibk.mtk.draw3d.objects.surface3d.Function2DMeshBuilder;
import uibk.mtk.draw3d.objects.surface3d.Mesh;
import uibk.mtk.geom.CoordinateBox3D;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.ParsedFunction2D;
import uibk.mtk.math.parsing.Function2DParser;
import uibk.mtk.swing.base.IntervalTextField;
import uibk.mtk.swing.base.MPanel;

public class PanelSurface
extends MPanel
implements ActionListener {
    JTextField textFormula = new JTextField();
    JButton buttonCalc;
    JSlider sliderMeshPoints;
    JLabel labelmesh;
    AppletSurface3D main;
    IntervalTextField txtIntervalX;
    IntervalTextField txtIntervalY;

    public PanelSurface(AppletSurface3D main) {
        this.main = main;
        this.initComponents();
    }

    private ParsedFunction2D getFunction() {
        try {
            String strfunc = this.textFormula.getText();
            return Function2DParser.parse(AppletSurface3D.VARS[0], AppletSurface3D.VARS[1], strfunc);
        }
        catch (Exception e) {
            this.main.mathpanel3d.reportError(Messages.getString("PanelSurface.0"), e);
            return null;
        }
    }

    void compute() {
        Interval intervalimag;
        Interval intervalreal;
        this.main.panelpartialderivs.setEnabled(false);
        ParsedFunction2D function = this.getFunction();
        if (function == null) {
            return;
        }
        int n = this.sliderMeshPoints.getValue();
        try {
            intervalreal = this.txtIntervalX.getInterval();
            intervalimag = this.txtIntervalY.getInterval();
        }
        catch (Exception e) {
            this.main.mathpanel3d.reportError(e);
            return;
        }
        CoordinateRect2D limits = new CoordinateRect2D(intervalreal.a, intervalreal.b, intervalimag.a, intervalimag.b);
        try {
            Function2DMeshBuilder meshbuilder = new Function2DMeshBuilder(function);
            Mesh mesh = meshbuilder.build(limits, n, n, true);
            this.main.surface3d.setMesh(mesh);
        }
        catch (Exception e) {
            this.main.surface3d.setVisible(false);
            this.main.mathpanel3d.reportError(e);
            return;
        }
        CoordinateBox3D box = this.main.surface3d.getBoundingBox();
        this.main.partialderivates.setFunction(function);
        this.main.mathpanel3d.getScene3D().setBoundingBox(box);
        this.main.surface3d.setVisible(true);
        this.main.panelpartialderivs.setEnabled(true);
        this.main.mathpanel3d.reportSuccess(function + Messages.getString("PanelSurface.1"));
        this.main.mathpanel3d.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("compute")) {
            this.main.partialderivates.setVisible(false);
            this.compute();
            this.main.mathpanel3d.repaint();
        }
    }

    void initComponents() {
        TitledBorder border = BorderFactory.createTitledBorder(Messages.getString("PanelSurface.3"));
        this.setBorder(border);
        this.setMaximumSize(new Dimension(2000, 270));
        this.setPreferredSize(new Dimension(2000, 270));
        this.setLayout(new GridBagLayout());
        int n = 20;
        this.labelmesh = new JLabel(String.valueOf(Messages.getString("PanelSurface.4")) + n + "x" + n);
        this.labelmesh.setFont(this.labelmesh.getFont().deriveFont(1));
        String[] vars = AppletSurface3D.VARS;
        this.textFormula = new JTextField(10);
        this.textFormula.setActionCommand("compute");
        this.textFormula.addActionListener(this);
        this.textFormula.setToolTipText(String.valueOf(Messages.getString("PanelSurface.7")) + vars[0] + "," + vars[1] + Messages.getString("PanelSurface.9"));
        this.txtIntervalY = new IntervalTextField(10, Messages.getString("PanelSurface.10"), true);
        this.txtIntervalY.setActionCommand("compute");
        this.txtIntervalY.addActionListener(this);
        this.txtIntervalY.setToolTipText(Messages.getString("PanelSurface.12"));
        this.txtIntervalX = new IntervalTextField(10, Messages.getString("PanelSurface.13"), true);
        this.txtIntervalX.setActionCommand("compute");
        this.txtIntervalX.addActionListener(this);
        this.txtIntervalX.setToolTipText(Messages.getString("PanelSurface.15"));
        this.buttonCalc = new JButton(Messages.getString("PanelSurface.16"));
        this.buttonCalc.setActionCommand("compute");
        this.buttonCalc.addActionListener(this);
        this.buttonCalc.setToolTipText(Messages.getString("PanelSurface.18"));
        JLabel labelFormula = new JLabel("f(" + vars[0] + "," + vars[1] + ")=");
        this.sliderMeshPoints = new JSlider();
        this.sliderMeshPoints.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                int n = slider.getValue();
                PanelSurface.this.labelmesh.setText(String.valueOf(Messages.getString("PanelSurface.22")) + String.valueOf(n) + "x" + String.valueOf(n));
            }
        });
        this.sliderMeshPoints.setMinimum(3);
        this.sliderMeshPoints.setMaximum(40);
        this.sliderMeshPoints.setValue(20);
        this.add((Component)labelFormula, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 0), 0, 0));
        this.add((Component)this.textFormula, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.labelmesh, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)this.sliderMeshPoints, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 20, 5), 0, 0));
        this.add((Component)new JLabel(Messages.getString("PanelSurface.24")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.txtIntervalX, new GridBagConstraints(1, 4, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel(Messages.getString("PanelSurface.25")), new GridBagConstraints(0, 5, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.txtIntervalY, new GridBagConstraints(1, 5, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 0, 15, 5), 0, 0));
        this.add((Component)this.buttonCalc, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 0, 0, 0), 0, 0));
    }
}

