/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.surface3d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import uibk.applets.surface3d.AppletSurface3D;
import uibk.mtk.draw2d.util.MiscDrawing2D;
import uibk.mtk.draw3d.objects.surfaceext.PartialDerivates3D;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.geom.Vector2D;
import uibk.mtk.math.MathUtil;
import uibk.mtk.swing.base.MPanel;

class PanelChoose
extends MPanel {
    AppletSurface3D main;
    private static final int GRIDSIZEX = 150;
    private static final int GRIDSIZEY = 150;
    private static final Color GRIDCOLORENABLED = Color.red;
    private static final Color GRIDCOLORDISABLED = Color.gray;
    private static final Color POINTCOLOR = Color.blue;
    private static final int POINTRADIUS = 2;
    PartialDerivates3D partials;
    Point p1 = new Point();
    Point p2 = new Point();
    int count = 0;
    private static int EDGE = 15;
    boolean successful = false;

    PanelChoose(AppletSurface3D main) {
        this.main = main;
        this.partials = main.partialderivates;
        this.initComponents();
    }

    void initComponents() {
        this.setMaximumSize(new Dimension(150, 150));
        this.setPreferredSize(new Dimension(150, 150));
        this.setMinimumSize(new Dimension(150, 150));
        this.addMouseListener(new MyMouseListener());
        this.addMouseMotionListener(new MyMouseMotionListener());
    }

    private void calcTangentPlane(MouseEvent ev) {
        this.p1.x = ev.getX();
        this.p1.y = ev.getY();
        try {
            this.main.partialderivates.compute(this.convert(this.p1), null);
            this.main.partialderivates.setVisible(true);
            this.main.mathpanel3d.repaint();
            this.main.surface3d.enableCoordLineX(false);
            this.main.surface3d.enableCoordLineY(false);
            this.main.surface3d.enableCoordLineX(false);
            this.main.surface3d.enableCoordLineY(false);
            this.main.surface3d.enableCoordLine(false);
            this.successful = true;
        }
        catch (Exception e1) {
            this.successful = false;
            this.count = 0;
            this.main.mathpanel3d.reportError(e1);
        }
    }

    private void calcDirectional(MouseEvent ev) {
        if (this.count == 2) {
            this.count = 0;
        }
        if (this.count == 0) {
            this.p1.x = ev.getX();
            this.p1.y = ev.getY();
        }
        if (this.count == 1) {
            this.p2.x = ev.getX();
            this.p2.y = ev.getY();
            Vector2D dir = this.convert(this.p2).sub(this.convert(this.p1)).toVector();
            try {
                this.main.partialderivates.compute(this.convert(this.p1), new Vector2D(dir.x, dir.y));
                this.main.partialderivates.setVisible(true);
                this.main.surface3d.enableCoordLineX(false);
                this.main.surface3d.enableCoordLineY(false);
                this.main.surface3d.enableCoordLine(true);
                this.main.surface3d.setBase(this.convert(this.p1));
                this.main.surface3d.setDirection(dir);
                this.main.mathpanel3d.repaint();
            }
            catch (Exception e1) {
                this.count = 0;
                this.main.mathpanel3d.reportError(e1);
            }
        }
        ++this.count;
    }

    void calcPartials(MouseEvent ev) {
        this.p1.x = ev.getX();
        this.p1.y = ev.getY();
        try {
            this.main.partialderivates.compute(this.convert(this.p1), null);
            this.main.partialderivates.setVisible(true);
            this.main.surface3d.setBase(new Punkt2D(this.convert((Point)this.p1).x, this.convert((Point)this.p1).y));
            this.main.surface3d.enableCoordLineX(true);
            this.main.surface3d.enableCoordLineY(true);
            this.main.surface3d.enableCoordLine(false);
            this.successful = true;
            this.main.mathpanel3d.repaint();
        }
        catch (Exception e) {
            this.successful = false;
            this.main.mathpanel3d.reportError(e);
            this.count = 0;
        }
    }

    private Punkt2D convert(Point p) {
        CoordinateRect2D rect = this.main.surface3d.getXYLimits();
        double y1 = MathUtil.interpolate(EDGE, this.getWidth() - EDGE, rect.xmin, rect.xmax, p.x);
        double x1 = MathUtil.interpolate(EDGE, this.getHeight() - EDGE, rect.ymin, rect.ymax, p.y);
        return new Punkt2D(x1, y1);
    }

    private boolean gridcontains(int x, int y) {
        if (x < EDGE || x > this.getWidth() - EDGE) {
            return false;
        }
        return y >= EDGE && y <= this.getHeight() - EDGE;
    }

    private void drawgrid(Graphics2D g2) {
        int nx = this.main.panelsurface.sliderMeshPoints.getValue();
        int ny = this.main.panelsurface.sliderMeshPoints.getValue();
        int xmin = EDGE;
        int xmax = this.getWidth() - EDGE;
        int ymin = EDGE;
        int ymax = this.getHeight() - EDGE;
        if (this.isEnabled()) {
            g2.setColor(GRIDCOLORENABLED);
        } else {
            g2.setColor(GRIDCOLORDISABLED);
        }
        MiscDrawing2D.drawgrid(g2, xmin, xmax, ymin, ymax, nx, ny);
        g2.setColor(Color.black);
        MiscDrawing2D.drawArrow(g2, new Punkt2D(this.getWidth() - EDGE, EDGE), new Punkt2D(EDGE - 10, EDGE), 6, 3);
        g2.drawString(AppletSurface3D.VARS[1], EDGE, EDGE - 2);
        MiscDrawing2D.drawArrow(g2, new Punkt2D(this.getWidth() - EDGE, EDGE), new Punkt2D(this.getWidth() - EDGE, this.getHeight() - 4), 6, 3);
        g2.drawString(AppletSurface3D.VARS[0], this.getWidth() - EDGE + 10, this.getHeight() - 3);
    }

    private void drawpoint(Graphics2D g2) {
        switch (this.partials.getMode()) {
            case 1: {
                if (!this.successful) break;
                g2.setColor(POINTCOLOR);
                MiscDrawing2D.fillCircle(g2, this.p1.x, this.p1.y, 2);
                break;
            }
            case 2: {
                if (!this.successful) break;
                g2.setColor(POINTCOLOR);
                MiscDrawing2D.fillCircle(g2, this.p1.x, this.p1.y, 2);
                break;
            }
            case 0: {
                if (this.count == 1) {
                    g2.setColor(POINTCOLOR);
                    MiscDrawing2D.fillCircle(g2, this.p1.x, this.p1.y, 2);
                }
                if (this.count != 2 || !this.successful) break;
                g2.setColor(POINTCOLOR);
                MiscDrawing2D.fillCircle(g2, this.p1.x, this.p1.y, 2);
                g2.setColor(Color.black);
                MiscDrawing2D.drawArrow(g2, new Punkt2D(this.p1), new Punkt2D(this.p2), 6, 3);
                break;
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        this.drawgrid(g2);
        this.drawpoint(g2);
    }

    class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            if (!PanelChoose.this.isEnabled() || !PanelChoose.this.gridcontains(ev.getX(), ev.getY())) {
                return;
            }
            switch (PanelChoose.this.partials.getMode()) {
                case 1: {
                    PanelChoose.this.calcPartials(ev);
                    break;
                }
                case 0: {
                    PanelChoose.this.calcDirectional(ev);
                    break;
                }
                case 2: {
                    PanelChoose.this.calcTangentPlane(ev);
                    break;
                }
            }
            PanelChoose.this.repaint();
        }
    }

    class MyMouseMotionListener
    extends MouseMotionAdapter {
        MyMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            if (!PanelChoose.this.isEnabled()) {
                return;
            }
            if (!PanelChoose.this.gridcontains(ev.getX(), ev.getY())) {
                return;
            }
            Punkt2D p = PanelChoose.this.convert(ev.getPoint());
            PanelChoose.this.main.mathpanel3d.report("(x,y)=(" + p.x + "," + p.y + ")");
        }
    }
}

