%----------------------------------------------------------------------------------------------------
%
% Class file for the extended abstract of the ECCOMAS Multibody Dynamics
%
%----------------------------------------------------------------------------------------------------

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{mbd25_abstract}[2025/13/18 ECCOMAS MBD abstract class]
\ProcessOptions\relax

\DeclareOption{10pt}{\OptionNotUsed}
\DeclareOption{twocolumn}{\OptionNotUsed}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
  
\ProcessOptions\relax
  
\LoadClass[10pt,a4paper,twoside]{article}
  
\RequirePackage{ucs} % extended UTF-8 input encoding support for LaTeX - CTAN
\RequirePackage[utf8x]{inputenc}
\RequirePackage{mathptmx} % use Adobe Times Roman (or equivalent) as default text font and provide maths support.
\RequirePackage[T1]{fontenc}

%\RequirePackage[dvipdfmx]{graphicx}
\RequirePackage{graphicx}
\RequirePackage{verbatim}
\RequirePackage{tabularx}
\RequirePackage{amsmath,amsfonts,amssymb,amsthm,amsbsy,amsmath}
\RequirePackage{latexsym}
\RequirePackage{bm}
\RequirePackage{a4}
\RequirePackage{fancyhdr}
\RequirePackage{engord}
\RequirePackage{epsfig,vmargin,booktabs}
\RequirePackage{grffile}


\setpapersize{A4}  % needs vmargin package
\setmarginsrb{17.5mm}{0mm}{12.5mm}{20mm}{20mm}{0mm}{0mm}{0mm}
\parindent=0.0em
\parskip=1.0ex

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% SECTIONS 
\renewcommand\section{\@startsection {section}{1}{\z@}{-2.0ex}{0.2ex}{\normalsize\bf}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\AtBeginDocument{%    
  \pagestyle{empty}
  \thispagestyle{fancy}
  \fancyhf{} % clear all header and footer fields
  \renewcommand{\headrulewidth}{0pt}
  \rhead{
    \scriptsize{
      12$^{\text{th}}$ ECCOMAS Thematic Conference on Multibody Dynamics\\
      July 13--18, 2025, Innsbruck, Austria\\
      \vspace{5mm}
    }
  }
}
\endinput

%%% Additional settings like font sizes etc.
\def\figurename{Figure}
\def\tablename{Table}
