/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import uibk.mtk.draw3d.base.MathPanel3D;
import uibk.mtk.geom.CoordinateBox3D;
import uibk.mtk.swing.Messages;
import uibk.mtk.swing.base.ButtonNoFocus;
import uibk.mtk.swing.base.TitledPanel;

public class PanelScale3D
extends TitledPanel
implements ActionListener {
    protected JRadioButton optEqual;
    protected JRadioButton optIndependent;
    protected ButtonNoFocus buttonXScaleUp;
    protected ButtonNoFocus buttonXScaleDown;
    protected ButtonNoFocus buttonYScaleUp;
    protected ButtonNoFocus buttonYScaleDown;
    protected ButtonNoFocus buttonZScaleUp;
    protected ButtonNoFocus buttonZScaleDown;
    protected ButtonNoFocus buttonScaleUp;
    protected ButtonNoFocus buttonScaleDown;
    MathPanel3D mathpanel3d;
    private static final String STREQUAL = Messages.getString("PanelScale3D.0");
    private static final String STRINDEPENDENT = Messages.getString("PanelScale3D.1");
    private static final String STRTITLE = Messages.getString("PanelScale3D.2");
    private static final String STRXAXIS = Messages.getString("PanelScale3D.3");
    private static final String STRYAXIS = Messages.getString("PanelScale3D.4");
    private static final String STRZAXIS = Messages.getString("PanelScale3D.5");
    protected JLabel labelxaxis;
    protected JLabel labelyaxis;
    protected JLabel labelzaxis;
    private double scalefactor = 1.1;
    public static final int SCALE_EQUAL = 0;
    public static final int SCALE_INDEPENDENT = 1;

    public void setScaleFaktor(double factor) {
        if (factor <= 1.0) {
            throw new IllegalArgumentException("");
        }
        this.scalefactor = factor;
    }

    public PanelScale3D(MathPanel3D mathpanel3d) {
        super(STRTITLE);
        this.mathpanel3d = mathpanel3d;
        this.initComponents();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.update();
        }
    }

    public void update() {
        if (this.mathpanel3d.getScene3D().getScalingMode() == 0) {
            this.optEqual.setSelected(true);
            this.buttonXScaleUp.setEnabled(false);
            this.buttonXScaleDown.setEnabled(false);
            this.buttonYScaleUp.setEnabled(false);
            this.buttonYScaleDown.setEnabled(false);
            this.buttonZScaleUp.setEnabled(false);
            this.buttonZScaleDown.setEnabled(false);
            this.buttonScaleUp.setEnabled(true);
            this.buttonScaleDown.setEnabled(true);
            this.optEqual.setSelected(true);
        } else {
            this.optIndependent.setSelected(true);
            this.buttonXScaleUp.setEnabled(true);
            this.buttonXScaleDown.setEnabled(true);
            this.buttonYScaleUp.setEnabled(true);
            this.buttonYScaleDown.setEnabled(true);
            this.buttonZScaleUp.setEnabled(true);
            this.buttonZScaleDown.setEnabled(true);
            this.buttonScaleUp.setEnabled(false);
            this.buttonScaleDown.setEnabled(false);
            this.optIndependent.setSelected(true);
        }
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(2000, 210));
        URL urlIconPlus = this.getClass().getResource("res/plus.gif");
        URL urlIconMinus = this.getClass().getResource("res/minus.gif");
        this.buttonXScaleUp = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.buttonXScaleDown = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.buttonXScaleUp.setActionCommand("xscaleup");
        this.buttonXScaleDown.setActionCommand("xscaledown");
        this.buttonYScaleUp = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.buttonYScaleDown = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.buttonYScaleUp.setActionCommand("yscaleup");
        this.buttonYScaleDown.setActionCommand("yscaledown");
        this.buttonZScaleUp = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.buttonZScaleDown = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.buttonZScaleUp.setActionCommand("zscaleup");
        this.buttonZScaleDown.setActionCommand("zscaledown");
        this.buttonScaleUp = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.buttonScaleUp.setActionCommand("scaleup");
        this.buttonScaleDown = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.buttonScaleDown.setActionCommand("scaledown");
        this.buttonXScaleUp.addActionListener(this);
        this.buttonXScaleDown.addActionListener(this);
        this.buttonYScaleUp.addActionListener(this);
        this.buttonYScaleDown.addActionListener(this);
        this.buttonZScaleUp.addActionListener(this);
        this.buttonZScaleDown.addActionListener(this);
        this.buttonScaleUp.addActionListener(this);
        this.buttonScaleDown.addActionListener(this);
        this.optEqual = new JRadioButton(STREQUAL);
        this.optIndependent = new JRadioButton(STRINDEPENDENT);
        this.optEqual.addActionListener(this);
        this.optIndependent.addActionListener(this);
        this.optEqual.setActionCommand("scaleequal");
        this.optIndependent.setActionCommand("scaleindependet");
        ButtonGroup groupOpt = new ButtonGroup();
        groupOpt.add(this.optEqual);
        groupOpt.add(this.optIndependent);
        if (this.mathpanel3d.getScene3D().getScalingMode() == 0) {
            this.optEqual.setSelected(true);
        } else {
            this.optIndependent.setSelected(true);
        }
        this.update();
        this.labelxaxis = new JLabel(STRXAXIS);
        this.labelyaxis = new JLabel(STRYAXIS);
        this.labelzaxis = new JLabel(STRZAXIS);
        this.add((Component)this.optIndependent, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.labelxaxis, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 5, 0), 0, 0));
        this.add((Component)this.buttonXScaleDown, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.buttonXScaleUp, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.labelyaxis, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 5, 0), 0, 0));
        this.add((Component)this.buttonYScaleDown, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.buttonYScaleUp, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.labelzaxis, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 5, 0), 0, 0));
        this.add((Component)this.buttonZScaleDown, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.buttonZScaleUp, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.optEqual, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.buttonScaleDown, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
        this.add((Component)this.buttonScaleUp, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        double scaley;
        double scalex;
        double scalez;
        double scale;
        if (ev.getActionCommand().equals("xscaleup")) {
            scale = this.mathpanel3d.getScene3D().getXScaleFactor();
            this.mathpanel3d.getScene3D().setXScaleFactor(scale * this.scalefactor);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("xscaledown")) {
            scale = this.mathpanel3d.getScene3D().getXScaleFactor();
            this.mathpanel3d.getScene3D().setXScaleFactor(scale / this.scalefactor);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("yscaleup")) {
            scale = this.mathpanel3d.getScene3D().getYScaleFactor();
            this.mathpanel3d.getScene3D().setYScaleFactor(scale * this.scalefactor);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("yscaledown")) {
            scale = this.mathpanel3d.getScene3D().getYScaleFactor();
            this.mathpanel3d.getScene3D().setYScaleFactor(scale / this.scalefactor);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("zscaleup")) {
            scale = this.mathpanel3d.getScene3D().getZScaleFactor();
            this.mathpanel3d.getScene3D().setZScaleFactor(scale * this.scalefactor);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("zscaledown")) {
            scale = this.mathpanel3d.getScene3D().getZScaleFactor();
            this.mathpanel3d.getScene3D().setZScaleFactor(scale / this.scalefactor);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("scaleup")) {
            scalez = this.mathpanel3d.getScene3D().getZScaleFactor();
            scalex = this.mathpanel3d.getScene3D().getXScaleFactor();
            scaley = this.mathpanel3d.getScene3D().getYScaleFactor();
            this.mathpanel3d.getScene3D().setXScaleFactor(scalex * this.scalefactor);
            this.mathpanel3d.getScene3D().setYScaleFactor(scaley * this.scalefactor);
            this.mathpanel3d.getScene3D().setZScaleFactor(scalez * this.scalefactor);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("scaledown")) {
            scalez = this.mathpanel3d.getScene3D().getZScaleFactor();
            scalex = this.mathpanel3d.getScene3D().getXScaleFactor();
            scaley = this.mathpanel3d.getScene3D().getYScaleFactor();
            this.mathpanel3d.getScene3D().setXScaleFactor(scalex / this.scalefactor);
            this.mathpanel3d.getScene3D().setYScaleFactor(scaley / this.scalefactor);
            this.mathpanel3d.getScene3D().setZScaleFactor(scalez / this.scalefactor);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("scaleequal")) {
            CoordinateBox3D box = this.mathpanel3d.getScene3D().getOriginalBoundingBox();
            this.mathpanel3d.getScene3D().setBoundingBox(box);
            this.mathpanel3d.getScene3D().setXScaleFactor(1.0);
            this.mathpanel3d.getScene3D().setYScaleFactor(1.0);
            this.mathpanel3d.getScene3D().setZScaleFactor(1.0);
            this.mathpanel3d.getScene3D().setScalingMode(0);
            this.mathpanel3d.repaint();
            this.update();
        }
        if (ev.getActionCommand().equals("scaleindependet")) {
            CoordinateBox3D box = this.mathpanel3d.getScene3D().getOriginalBoundingBox();
            this.mathpanel3d.getScene3D().setBoundingBox(box);
            this.mathpanel3d.getScene3D().setXScaleFactor(1.0);
            this.mathpanel3d.getScene3D().setYScaleFactor(1.0);
            this.mathpanel3d.getScene3D().setZScaleFactor(1.0);
            this.mathpanel3d.getScene3D().setScalingMode(1);
            this.mathpanel3d.repaint();
            this.update();
        }
    }
}

