/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.base;

import java.awt.Point;
import uibk.mtk.draw3d.base.MathPanel3D;
import uibk.mtk.draw3d.base.Matrix3D;
import uibk.mtk.geom.CoordinateBox3D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.geom.Punkt3D;
import uibk.mtk.geom.Vector2D;
import uibk.mtk.geom.Vector3D;

public class Scene3D {
    protected Matrix3D M;
    protected Matrix3D V;
    Matrix3D P;
    Matrix3D N;
    Matrix3D T;
    MathPanel3D mathpanel3d;
    int scalingmode = 1;
    public double rotationx = 0.0;
    public double rotationz = 0.0;
    public double rotationy = 0.0;
    double distance = 4.0;
    double scalex = 1.0;
    double scaley = 1.0;
    double scalez = 1.0;
    double roundingpercent = 2.0;
    boolean roundingenabled = true;
    private CoordinateBox3D nc_window = new CoordinateBox3D();
    private CoordinateBox3D boundingbox = new CoordinateBox3D();
    private CoordinateBox3D orig_boundingbox = new CoordinateBox3D();
    public static final int SCALE_EQUAL = 0;
    public static final int SCALE_INDEPENDENT = 1;
    static final double DEGREE90 = 1.5707963267948966;
    static final double DEGREE180 = Math.PI;
    public static final int PROJECT_PERSPECTIVE = 0;
    public static final int PROJECT_PARALLEL = 1;
    int projectiontype = 0;

    public void setScalingMode(int mode) {
        this.scalingmode = mode;
    }

    public int getScalingMode() {
        return this.scalingmode;
    }

    void enableRounding(boolean b) {
        this.roundingenabled = b;
    }

    public void setRoundingPercent(double percent) {
        this.roundingpercent = percent;
    }

    public Punkt3D getWC(Punkt3D p) {
        return this.M.multiply(p);
    }

    public void defaultview() {
        this.projectiontype = 0;
        this.distance = 3.0;
        this.rotationx = 0.0;
        this.rotationz = 1.2;
        this.rotationy = 0.0;
        this.scalex = 1.0;
        this.scaley = 1.0;
        this.scalez = 1.0;
    }

    public void projectXZPlane() {
        this.rotationx = 0.0;
        this.rotationz = Math.PI;
        this.rotationy = 0.0;
    }

    public void projectXYPlane() {
        this.rotationx = 1.5707963267948966;
        this.rotationz = 0.0;
        this.rotationy = Math.PI;
    }

    public void projectYZPlane() {
        this.rotationx = 0.0;
        this.rotationz = 1.5707963267948966;
        this.rotationy = 0.0;
    }

    public int getProjectionType() {
        return this.projectiontype;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public void setXScaleFactor(double scalex) {
        this.scalex = scalex;
    }

    public void setYScaleFactor(double scaley) {
        this.scaley = scaley;
    }

    public void setZScaleFactor(double scalez) {
        this.scalez = scalez;
    }

    public double getXScaleFactor() {
        return this.scalex;
    }

    public double getYScaleFactor() {
        return this.scaley;
    }

    public double getZScaleFactor() {
        return this.scalez;
    }

    public Scene3D() {
        this.defaultview();
    }

    public void setRotationX(double rot) {
        this.rotationx = rot;
    }

    public void setRotationY(double rot) {
        this.rotationy = rot;
    }

    public void setRotationZ(double rot) {
        this.rotationz = rot;
    }

    public void setProjectionType(int type) {
        this.projectiontype = type;
    }

    public boolean isClippingEnabled() {
        return true;
    }

    public double getRotationX() {
        return this.rotationx;
    }

    public double getRotationY() {
        return this.rotationy;
    }

    public double getRotationZ() {
        return this.rotationz;
    }

    public void setPanel(MathPanel3D mathpanel3d) {
        this.mathpanel3d = mathpanel3d;
    }

    public void setBoundingBox(CoordinateBox3D box) {
        this.boundingbox = box;
        if (box.getXRange() == 0.0) {
            this.boundingbox.xmin = box.xmax - 1.0;
            this.boundingbox.xmax = box.xmax + 1.0;
        }
        if (box.getZRange() == 0.0) {
            this.boundingbox.zmin = box.zmax - 1.0;
            this.boundingbox.zmax = box.zmax + 1.0;
        }
        if (box.getYRange() == 0.0) {
            this.boundingbox.ymin = box.ymax - 1.0;
            this.boundingbox.ymax = box.ymax + 1.0;
        }
        this.scalex = 1.0;
        this.scaley = 1.0;
        this.scalez = 1.0;
        this.orig_boundingbox = (CoordinateBox3D)box.clone();
    }

    public CoordinateBox3D getBoundingBox() {
        return (CoordinateBox3D)this.boundingbox.clone();
    }

    public CoordinateBox3D getOriginalBoundingBox() {
        return this.orig_boundingbox;
    }

    public double getClippingPlane() {
        return this.distance - 0.15;
    }

    public void prepareScene() {
        this.boundingbox = (CoordinateBox3D)this.orig_boundingbox.clone();
        if (this.roundingenabled) {
            this.boundingbox.roundCoords(this.roundingpercent, 7);
        }
        this.setupModelViewMatrix();
        this.P = this.projectiontype == 0 ? Matrix3D.getPerspectiveProjectionMatrixXZPlane(this.distance) : Matrix3D.getParallelProjectionMatrixXZPlane();
        this.setupViewPortTransformationMatrix();
        this.T = this.V.multiply(this.P.multiply(this.M));
        this.setupNormalTransMatrix();
    }

    public Punkt3D getCamera() {
        return new Punkt3D(0.0, this.distance, 0.0);
    }

    private void setupViewPortTransformationMatrix() {
        int vx_min = 0;
        int vy_min = 0;
        int vx_max = this.mathpanel3d.getWidth();
        int vy_max = this.mathpanel3d.getHeight();
        Matrix3D SN = Matrix3D.getScaleMatrix(1.0 / (this.nc_window.xmax - this.nc_window.xmin), 1.0 / (this.nc_window.ymax - this.nc_window.ymin), 1.0 / (this.nc_window.zmax - this.nc_window.zmin));
        Matrix3D SV = Matrix3D.getScaleMatrix(vx_max - vx_min, 1.0, vy_max - vy_min);
        Matrix3D TV = Matrix3D.getTranslationMatrix(vx_min, 0.0, vy_min);
        Matrix3D TW = Matrix3D.getTranslationMatrix(-this.nc_window.xmin, -this.nc_window.ymin, -this.nc_window.zmin);
        this.V = TV.multiply(SV.multiply(SN.multiply(TW)));
    }

    public Point wctoDevice(Punkt3D a) {
        Matrix3D Z = this.V.multiply(this.P);
        Vector3D p = Z.multiply(a);
        double h = p.h;
        p.x1 /= h;
        p.x3 /= h;
        return new Point(this.mathpanel3d.getWidth() - (int)p.x1, this.mathpanel3d.getHeight() - (int)p.x3);
    }

    public Point mcToDevice(Punkt3D a) {
        Vector3D p = this.T.multiply(a);
        double h = p.h;
        return new Point(this.mathpanel3d.getWidth() - (int)(p.x1 / h), this.mathpanel3d.getHeight() - (int)(p.x3 / h));
    }

    public Punkt2D project(Punkt3D a) {
        Vector3D p = this.T.multiply(a);
        double h = p.h;
        return new Punkt2D(this.mathpanel3d.getWidth() - (int)(p.x1 / h), this.mathpanel3d.getHeight() - (int)(p.x3 / h));
    }

    public double calcdepth(Punkt3D p) {
        return this.getCamera().sub(p).quadnorm();
    }

    private void setupModelViewMatrix() {
        Punkt3D center = this.boundingbox == null ? new Punkt3D(0.0, 0.0, 0.0) : this.boundingbox.getCenter();
        Matrix3D TR = Matrix3D.getTranslationMatrix(-center.x1, -center.x2, -center.x3);
        double max = Math.max(Math.max(this.boundingbox.getXRange(), this.boundingbox.getYRange()), this.boundingbox.getZRange());
        Matrix3D SR = this.scalingmode == 0 ? Matrix3D.getScaleMatrix(this.nc_window.getXRange() / max, this.nc_window.getYRange() / max, this.nc_window.getZRange() / max) : Matrix3D.getScaleMatrix(this.nc_window.getXRange() / this.boundingbox.getXRange(), this.nc_window.getYRange() / this.boundingbox.getYRange(), this.nc_window.getZRange() / this.boundingbox.getZRange());
        Matrix3D SUSER = Matrix3D.getScaleMatrix(this.scalex * 0.45, this.scaley * 0.45, this.scalez * 0.45);
        Matrix3D S = SUSER.multiply(SR);
        Matrix3D rotX = Matrix3D.getRotationMatrixXAxis(this.rotationx);
        Matrix3D rotZ = Matrix3D.getRotationMatrixZAxis(this.rotationz);
        Matrix3D rotY = Matrix3D.getRotationMatrixYAxis(this.rotationy);
        Matrix3D R = rotX.multiply(rotZ.multiply(rotY));
        this.M = R.multiply(S.multiply(TR));
    }

    private void setupNormalTransMatrix() {
        try {
            Matrix3D temp = this.M.inverse();
            this.N = Matrix3D.transpose(temp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public double getDistance() {
        return this.distance;
    }

    public Vector3D transformNormal(Vector3D v) {
        return this.N.multiply(v);
    }

    public Vector2D projectVector(Punkt3D base, Vector3D mc_dir) {
        Vector2D dir;
        Vector3D wc_dir = this.transformNormal(mc_dir);
        Punkt2D pzero = this.project(base);
        if (wc_dir.x2 > 0.0) {
            mc_dir.scaleself(-this.getBoundingBox().maxBoundingBox());
            Punkt2D temp = this.project(base.add(mc_dir));
            dir = temp.sub(pzero).toVector();
            dir.x = -dir.x;
            dir.y = -dir.y;
        } else {
            mc_dir.scaleself(this.getBoundingBox().maxBoundingBox());
            Punkt2D temp = this.project(base.add(mc_dir));
            dir = temp.sub(pzero).toVector();
        }
        dir.normalize();
        return dir;
    }
}

