/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.parametriccurve3d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.parametriccurve3d.AppletParametricCurve3D;
import uibk.applets.parametriccurve3d.Messages;
import uibk.mtk.draw2d.util.GraphUtil;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.ParametricCurve3D;
import uibk.mtk.math.parsing.ParametricCurve3DParser;
import uibk.mtk.swing.base.IntervalTextField;
import uibk.mtk.swing.base.TitledPanel;

public class PanelCurve
extends TitledPanel
implements ActionListener {
    private final AppletParametricCurve3D main;
    JTextField textFormula;
    IntervalTextField textParamInterval;
    JCheckBox checkDefinePoints;
    JSlider sliderPlotPoints;
    JLabel labelpoints;
    JButton buttonCalc;
    boolean defaultNumPoints = true;

    public PanelCurve(AppletParametricCurve3D main) {
        super(Messages.getString("PanelCurve.0"));
        this.main = main;
        this.initComponents();
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(2000, 210));
        this.textFormula = new JTextField(16);
        this.textFormula.setActionCommand("compute");
        this.textFormula.addActionListener(this);
        this.textFormula.setToolTipText(String.valueOf(Messages.getString("PanelCurve.2")) + 't' + Messages.getString("PanelCurve.9"));
        this.textParamInterval = new IntervalTextField(8, Messages.getString("PanelCurve.4"), true);
        this.textParamInterval.setActionCommand("compute");
        this.textParamInterval.addActionListener(this);
        this.textParamInterval.setToolTipText(String.valueOf(Messages.getString("PanelCurve.6")) + 't' + Messages.getString("PanelCurve.7"));
        this.checkDefinePoints = new JCheckBox(Messages.getString("PanelCurve.8"));
        this.checkDefinePoints.setActionCommand("definepoints");
        this.checkDefinePoints.addActionListener(this);
        this.checkDefinePoints.setToolTipText(Messages.getString("PanelCurve.10"));
        JLabel labelFormula = new JLabel("(x(t),y(t),z(t))=");
        this.buttonCalc = new JButton(Messages.getString("PanelCurve.15"));
        this.buttonCalc.setActionCommand("compute");
        this.buttonCalc.addActionListener(this);
        this.buttonCalc.setToolTipText(Messages.getString("PanelCurve.17"));
        this.labelpoints = new JLabel(String.valueOf(Messages.getString("PanelCurve.18")) + 500);
        this.sliderPlotPoints = new JSlider();
        this.sliderPlotPoints.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                int n = slider.getValue();
                PanelCurve.this.labelpoints.setText(String.valueOf(Messages.getString("PanelCurve.19")) + String.valueOf(n));
            }
        });
        this.sliderPlotPoints.setMinimum(3);
        this.sliderPlotPoints.setMaximum(2000);
        this.sliderPlotPoints.setValue(500);
        this.sliderPlotPoints.setEnabled(!this.defaultNumPoints);
        this.labelpoints.setEnabled(!this.defaultNumPoints);
        this.add((Component)labelFormula, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.textFormula, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(Messages.getString("PanelCurve.20")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.textParamInterval, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.1, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.checkDefinePoints, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.labelpoints, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 2, 0), 0, 0));
        this.add((Component)this.sliderPlotPoints, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.buttonCalc, new GridBagConstraints(0, 5, 3, 1, 0.5, 0.0, 10, 0, new Insets(0, 0, 3, 0), 0, 0));
    }

    private ParametricCurve3D getFunction() {
        try {
            String strfunc = this.textFormula.getText();
            return ParametricCurve3DParser.parse('t', strfunc);
        }
        catch (Exception e) {
            this.main.mathpanel3d.reportError(Messages.getString("PanelCurve.21"), e);
            return null;
        }
    }

    void compute() {
        this.main.paneldreibein.setEnabled(false);
        this.main.paneldreibein.slider.setValue(0);
        this.main.dreibein.setVisible(false);
        ParametricCurve3D curve3d = this.getFunction();
        if (curve3d == null) {
            return;
        }
        this.main.dreibein.setParametricCurve(curve3d);
        try {
            Interval interval = this.textParamInterval.getInterval();
            int numpoints = this.defaultNumPoints ? 500 : this.sliderPlotPoints.getValue();
            this.main.graph.setPoints(GraphUtil.compute(curve3d, interval.a, interval.b, numpoints));
            this.main.mathpanel3d.getScene3D().setBoundingBox(this.main.graph.getLimits());
            this.main.paneldreibein.slider.setDoubleMinimum(interval.a);
            this.main.paneldreibein.slider.setDoubleMaximum(interval.b);
            if (this.defaultNumPoints) {
                this.main.paneldreibein.setEnabled(true);
                this.main.dreibein.setParameterInterval(interval);
                this.main.paneldreibein.slider.setNumTicks(numpoints);
            }
            this.main.mathpanel3d.repaint();
            this.main.mathpanel3d.reportSuccess(Messages.getString("PanelCurve.22"));
        }
        catch (Exception ex) {
            this.main.mathpanel3d.reportError(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("compute")) {
            this.compute();
        }
        if (ev.getActionCommand().equals("definepoints")) {
            this.defaultNumPoints = !this.checkDefinePoints.isSelected();
            this.sliderPlotPoints.setEnabled(this.checkDefinePoints.isSelected());
            this.labelpoints.setEnabled(this.checkDefinePoints.isSelected());
            this.main.paneldreibein.setEnabled(false);
            this.main.dreibein.setVisible(false);
        }
    }
}

