function val = targetFunctionTest(Omega,Gamma,l,N)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% generates N signals which are l-cosparse with respect to an operator
% Omega and evaluates the target function on Gamma
% Input:
%    - Omega ... the target operator
%    - Gamma ... the input operator
%    - l     ... the cosparsity
%    - N     ... the number of signals to use
% Output:
%    - val   ... the value of the target function
%
% (c) 16.12.2016 Michael Sandbichler
%
% This software is a free software distributed under the terms of the GNU 
% Public License version 3 (http://www.gnu.org/licenses/gpl.txt). You can 
% redistribute it and/or modify it under the terms of this licence, for 
% personal and non-commercial use and research purpose. 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[p,d] = size(Gamma);

val = 0;

for k= 1:N
    L = randperm(p);
    L = L(1:l);
    L=sort(L);
    
    y = randn(d,1);
    aux = y;
    O = Omega(L,:)*Omega(L,:)';
    aux = Omega(L,:)*aux;
    [~,aux] = evalc('transpose(Omega(L,:))*(O\aux);');
    y = y -aux;
    
    y=y/norm(y);
    
    S = (Gamma*y);

    [~,I] = sort(abs(S),1);
    I=I(1:l,:);
    
    val = val + norm(S(I))^2;
end

val = val/N;