function val = targetFixedData(Gamma,s,Y)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% computes the value of the target function given in 
% 'Sequential Learning of Analysis Operators' from an operator
% Gamma with sparsity level s and signals Y
%
% (c) 03.04.2017 Michael Sandbichler
%
% This software is a free software distributed under the terms of the GNU 
% Public License version 3 (http://www.gnu.org/licenses/gpl.txt). You can 
% redistribute it and/or modify it under the terms of this licence, for 
% personal and non-commercial use and research purpose. 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[~,d] = size(Gamma);
[~,N] = size(Y);
l=d-s;

val = 0;

for k= 1:N
    y = Y(:,k);  
    
    S = (Gamma*y);

    [~,I] = sort(abs(S),1);
    I=I(1:l,:);
    
    val = val + norm(S(I))^2;
end

val = val/N;