function Gnew = orderRows(G,Om,thres)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% orders the rows and flips the signs of a given matrix according to 
% the overlap with the rows of another matrix (used for plotting)
%   Input :
%       -G      ... the matrix with rows to be sorted
%       -Om     ... the reference matrix
%       -thres  ... threshold when two rows are considered the same
%   Output:
%       -Gord   ... the reordered operator
%
% (c) 16.12.2016 Michael Sandbichler
%
% This software is a free software distributed under the terms of the GNU 
% Public License version 3 (http://www.gnu.org/licenses/gpl.txt). You can 
% redistribute it and/or modify it under the terms of this licence, for 
% personal and non-commercial use and research purpose. 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Aux = G*Om';
Gnew = G;
[n,~] = size(Aux);
k=1;
r=1;
counter = 0;
unfound= 0;

while k<=n
    J = find(abs(Aux(:,r))>thres);
    l = length(J);
    if l==0
        k=k+1;
        r=r+1;
        unfound=unfound+1;
    end
    if l>0
    for j = 1:l
        Gnew = swapRows(Gnew,k-unfound+j-1,J(j));
        Gnew(k-unfound+j-1,:) =Gnew(k-unfound+j-1,:)*sign(Aux(J(j),r));
        Aux = Gnew*Om';        
    end
    k=k+l;
    r=r+1;
    end
    counter = counter+1;
    if counter>n+1
        break;
    end
end