%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% this is a plug-and-play test file for the curious reader
% all settings can be made in the "initializations" section of the code
% feel free to fiddle around with the parameters
%
% (c) 03.04.2016 Michael Sandbichler
%
% This software is a free software distributed under the terms of the GNU 
% Public License version 3 (http://www.gnu.org/licenses/gpl.txt). You can 
% redistribute it and/or modify it under the terms of this licence, for 
% personal and non-commercial use and research purpose. 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all
close all

%% initializations

rng(42) 

Replacement = 0; %toggle replacement 0 = no, 1 = yes
Implicit = 0;    % use the implicit method 0 = no, 1 = yes

replThres = 1-1e-2;

Sampling = 1;      % number of different initializations (for averaging)
Iterations = 200;   % number of iterations of the algorithm

d = 25;     %ambient dimension of the signals
K = 2*d;    %number of rows of the analysis operator

m = 2^13;     % #of sample vectors used in each iteration
s = 8;        % sparsity (cosparsity is then given by l = d-s
al = 0.1;     % stepsize parameter (important for SAOL)
np = 0;     % noise parameter


hitsRandInit(1:Iterations,1:Sampling) = 0;
hitsCloseInit(1:Iterations,1:Sampling) = 0;


%% Build the Dirac - DCT operator

OmDCT(1:d,1:d) = eye(d);
OmDCT(d+1:K,1:d) = dct(eye(d));

% OmDCT = randn(K,d);
% scale = sum(OmDCT.*OmDCT,2);
% OmDCT = diag(1./sqrt(scale))*OmDCT;


%% trainings
for l = 1:Sampling

%initialization of our startingoperators

% random
G1= randn(K,d);
scale = diag(G1*G1');
G1= diag(1./sqrt(scale))*G1;

% closeby
G2= randn(K,d);
scale = diag(G2*G2');
G2= diag(1./sqrt(scale))*G2;
G2 = G2 + OmDCT;
scale = diag(G2*G2');
G2= diag(1./sqrt(scale))*G2;

iter = 1;

for k=1:Iterations
    
    % create a fresh batch of signals in each iteration
    
    Y = MakeCosparseSignals(OmDCT,d-s,m);
    Y = Y+np/sqrt(d)*randn(d,m);
    scale = sum(Y.*Y);
    Y = Y*spdiags((1./sqrt(scale))',0,m,m);
    
    if sum(sum(isnan(Y)))>0
    while(    sum(sum(isnan(Y)))>0)
    Y = MakeCosparseSignals(OmDCT,d-s,m);
    Y = Y+np/sqrt(d)*randn(d,m);
    scale = sum(Y.*Y);
    Y = Y*spdiags((1./sqrt(scale))',0,m,m);
    end
    end
    
    %perform iter steps of the SAOL algorithm with or without replacement
    
    if Implicit == 0
       
    if Replacement == 0
     [G1,~] = SAOL(iter,Y,d-s,m,G1,al);
     [G2,~]  =  SAOL(iter,Y,d-s,m,G2,al);
    else
     [G1,~] = SAOL(iter,Y,d-s,m,G1,al,replThres);
     [G2,~]  =  SAOL(iter,Y,d-s,m,G2,al,replThres);
    end
    
    else
    
    if Replacement == 0
     [G1,~] = ISAOL(iter,Y,d-s,m,G1,al);
     [G2,~]  =  ISAOL(iter,Y,d-s,m,G2,al);
    else
     [G1,~] = ISAOL(iter,Y,d-s,m,G1,al,replThres);
     [G2,~]  =  ISAOL(iter,Y,d-s,m,G2,al,replThres);
    end
    
    end
     
    %find out how many rows have already been recovered
    thres = 0.99;
    corr1 = (max(abs(OmDCT*[G1]')')>thres);
    corr2 = (max(abs(OmDCT*[G2]')')>thres);
   
    hitsRandInit(k,l) = sum(corr1)/K;
    hitsCloseInit(k,l) = sum(corr2)/K;
   
    
hitsRand = mean(hitsRandInit(:,1:l),2);
hitsClose = mean(hitsCloseInit(:,1:l),2);

% plot the recovery history
figure(1)
subplot(2,2,1)
plot(hitsRand(1:k));
title('Random initialization');

subplot(2,2,2)
plot(hitsClose(1:k));
title('Closeby initialization');

subplot(2,2,3)
%order the rows of the operator for plotting
imagesc(showdico(orderRows(G1,OmDCT,0.9)',5));

subplot(2,2,4)
imagesc(showdico(orderRows(G2,OmDCT,0.9)',5));

drawnow();

end    

end