%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% this is a plug-and-play test file for the curious reader in order to
% compare the descent parameter choices Minimum <-> Median
% all settings can be made in the "initializations" section of the code
% feel free to fiddle around with the parameters
%
% (c) 16.12.2016 Michael Sandbichler
%
% This software is a free software distributed under the terms of the GNU 
% Public License version 3 (http://www.gnu.org/licenses/gpl.txt). You can 
% redistribute it and/or modify it under the terms of this licence, for 
% personal and non-commercial use and research purpose. 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all
close all

%% initializations

rng(42) 

Replacement = 0; %toggle replacement 0 = no, 1 = yes
Implicit = 0;    % use the implicit method 0 = no, 1 = yes

replThres = 1-1e-2;

Sampling = 8;      % number of different initializations (for averaging)
Iterations = 1000;   % number of iterations of the algorithm

d = 100;     %ambient dimension of the signals
K = 2*d;    %number of rows of the analysis operator

m = 2^14;     % #of sample vectors used in each iteration
s = 8;        % sparsity (cosparsity is then given by l = d-s
al1 = 0.1;     % stepsize parameter (important for SAOL)
np = 1/5;     % noise parameter


hitsRandInit(1:Iterations,1:Sampling) = 0;
hitsCloseInit(1:Iterations,1:Sampling) = 0;


%% Build the Dirac - DCT operator

OmDCT(1:d,1:d) = eye(d);
OmDCT(d+1:K,1:d) = dct(eye(d));

OmDCT = randn(K,d);
scale = sum(OmDCT.*OmDCT,2);
OmDCT = diag(1./sqrt(scale))*OmDCT;


%% trainings
parfor l = 1:Sampling
%initialization of the startingoperators

G1= randn(K,d);
scale = diag(G1*G1');
G1= diag(1./sqrt(scale))*G1;

GM = G1;

iter = 1;

YTest = MakeCosparseSignals(OmDCT,d-s,15000);
    
    if sum(sum(isnan(YTest)))>0
    while(    sum(sum(isnan(YTest)))>0)
    YTest = MakeCosparseSignals(OmDCT,d-s,15000);
    end
    end

for k=1:Iterations
    
    % create a fresh batch of signals in each iteration
    
    Y = MakeCosparseSignals(OmDCT,d-s,m);
    Y = Y+np/sqrt(d)*randn(d,m);
    scale = sum(Y.*Y);
    Y = Y*spdiags((1./sqrt(scale))',0,m,m);
    
    if sum(sum(isnan(Y)))>0
    while(    sum(sum(isnan(Y)))>0)
    Y = MakeCosparseSignals(OmDCT,d-s,m);
    Y = Y+np/sqrt(d)*randn(d,m);
    scale = sum(Y.*Y);
    Y = Y*spdiags((1./sqrt(scale))',0,m,m);
    end
    end
    
    %perform iter steps of the SAOL algorithm with or without replacement
           
    if Replacement == 0
        
     [G1,~] = SAOL(iter,Y,d-s,m,G1,al1);
     [GM,~]  =  SAOLMin(iter,Y,d-s,m,GM);
     
    else
     [G1,~] = SAOL(iter,Y,d-s,m,G1,al,replThres);
     [GM,~]  =  SAOLMin(iter,Y,d-s,m,GM,replThres);
    end
         
    %find out how many rows have already been recovered
    targ1(k,l)= targetFixedData(G1,s,YTest);
    targM(k,l)= targetFixedData(GM,s,YTest);

end 

end
targAl1 = mean(targ1,2);
targMin = mean(targM,2);
