%%%%%%%%%%%
%
% this code can be used to reproduce Fig. 1 from 'Sequential Learning of
% Analysis Operators'
%
% last modified: 03.04.2017, Michael Sandbichler
%
% This software is a free software distributed under the terms of the GNU 
% Public License version 3 (http://www.gnu.org/licenses/gpl.txt). You can 
% redistribute it and/or modify it under the terms of this licence, for 
% personal and non-commercial use and research purpose. 
%
%%%%%%%%%

clear all
close all

nAl = 100;      %number of different alpha prefactors
nExp = 8;       %number of randomly chosen starting operators
nIter = 500;    %number of iterations

m = 400000;     % #of sample vectors
s = 8;   %sparsity

targ(1:nIter,1:nAl)=0;
targExp(1:nIter,1:nExp) = 0;

np=0;   %noise

rng(42.4242);

%% dirac - DCT
p = 100;    %columns
n = 200;    %rows
OmDH(1:p,1:p) = eye(p);
OmDH(p+1:n,1:p) = dct(eye(p));

% create noisy signals
Ydh = MakeCosparseSignals(OmDH,p-s,m);
Ydh = Ydh+np/sqrt(p)*randn(p,m);
scale = sum(Ydh.*Ydh);
Ydh = Ydh*spdiags((1./sqrt(scale))',0,m,m);

YTest = MakeCosparseSignals(OmDH,p-s,15000);

%trainings
for l = 1:nAl    
    
    al(l) = l/nAl;
    mult = 10000;

parfor exp = 1:nExp
    
%initialization of the startingoperator
G= randn(n,p);
scale = diag(G*G');
G= diag(1./sqrt(scale))*G;
 
for k=1:nIter    
     G = SAOLreplVariant(1,Ydh,p-s,mult,G,l/nAl);
     targExp(k,exp) = targetFixedData(G,s,YTest);       
end
end

targ(:,l) = mean(targExp,2);
end
clear Ydh
name = sprintf('ParameterStudyNoisefreeTarget%d_%d_%d_%d_%d.mat',iter,mult,m,s,p);   
save(name);