%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Denoise a single image with fixed cosparsity and regularization
% parameter with ASimCO, InASimCO, SAOL and ISAOL
%
% The use of the SimCo algorithms can be toggled via the boolean variable
% 'SimCo', as the required functions are not contained in this software
% package.
% 
% (c) 03.04.2017 Michael Sandbichler
%
% This software is a free software distributed under the terms of the GNU 
% Public License version 3 (http://www.gnu.org/licenses/gpl.txt). You can 
% redistribute it and/or modify it under the terms of this licence, for 
% personal and non-commercial use and research purpose. 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

sigma = 12.8;
SimCo = 0;

A = imread('images/barbara256.png');
A = double(A);
    
l = 70;

% generate noisy image
AN = double(A) + sigma*randn(size(A));
PSNRnoisy = 10*log10(255.^2/mean((AN(:)-double(A(:))).^2));
            
%% Learn Omega==================
n = 8;
d = n^2;
% select training patches
N = 50000;            
[Y,I] = pic2patches(AN,n,n);

aux = 1./sqrt(sum(Y.*Y));
X = Y*spdiags(aux',0,Nfull,Nfull);

Ind=randperm(size(X, 2));
Xntrain=X(:,Ind(1:N));
p = 2*d;

OmegaInit = normr(randn(p, d));

param.initialDictionary = OmegaInit;
param.itN =2000;
param.cosparsity = l;
param.numOmegaUpdate = 1;

if SimCo == 1
% Algorithm 1: ASimCO
disp('ASimO');
tic
[OmegaASimCO] = analysis_SimCO_normalizedRowOmega(Xntrain, param);
Omega_all(:, :, 1) = OmegaASimCO;
toc

% Algorithm 2: IN-ASimCO, mu_0 = 0.2
tic
disp('IN_ASimO: mu=0.2');
param.mu = 0.2;
[OmegaIASimCO] = In_AnalysisSimCO(Xntrain, param);
Omega_all(:, :, 2) = OmegaIASimCO;
toc

end

tic
disp('SAOL');
%param.mu = 0.2;
[OmegaSAOL] = SAOL(param.itN, Xntrain,param.cosparsity,N,param.initialDictionary, 0.1);
Omega_all(:, :, 3) = OmegaSAOL;
toc

%Algorithm 3: ISAOL
tic
disp('ISAOL');
%param.mu = 0.2;
[OmegaISAOL] = ISAOL(500, Xntrain,param.cosparsity,N,param.initialDictionary, 1);
Omega_all(:, :, 4) = OmegaISAOL;
toc



%% Recover Image

lambda = 0.08;
% Using a learned operator
if SimCo == 1
tic
[XdnASimCO,err1] = AnalysisL1Denoising(Y, OmegaASimCO, lambda,1000);
toc
tic
[XdnIASimCO,err2] = AnalysisL1Denoising(Y, OmegaIASimCO, lambda,1000);
toc
end

tic
[XdnSAOL,err3] = AnalysisL1Denoising(Y, OmegaSAOL, lambda,1000);
toc

tic
[XdnISAOL,err4] = AnalysisL1Denoising(Y, OmegaISAOL, lambda,1000);
toc

if SimCo == 1
[MM,NN]=size(AN);
IdnASimCO=patches2pic(XdnASimCO,I,n);

[MM,NN]=size(AN);
IdnIASimCO=patches2pic(XdnIASimCO,I,n);
end

[MM,NN]=size(AN);
IdnSAOL=patches2pic(XdnSAOL,I,n);

[MM,NN]=size(AN);
IdnISAOL=patches2pic(XdnISAOL,I,n);


if SimCo == 1
figure(1)
title('ASimCO');
imagesc(IdnASimCO);
colormap(gray)
drawnow()

figure(2)
title('InASimCO');
imagesc(IdnIASimCO);
colormap(gray)
drawnow()
end

figure(3)
title('SAOL');
imagesc(IdnSAOL);
colormap(gray)
drawnow()

figure(4)
title('ISAOL');
imagesc(IdnISAOL);
colormap(gray)
drawnow()

if SimCo == 1
PSNRdn = 10*log10(255.^2/mean((IdnASimCO(:)-double(A(:))).^2))
PSNRdn2 = 10*log10(255.^2/mean((IdnIASimCO(:)-double(A(:))).^2))
end

PSNRdn3 = 10*log10(255.^2/mean((IdnSAOL(:)-double(A(:))).^2))
PSNRdn4 = 10*log10(255.^2/mean((IdnISAOL(:)-double(A(:))).^2))

