%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Natural image denoising
% Test images: Cameraman, Mandrill, House, Barbara, Peppers
%
% Caution: Takes ages to execute!
%
% Used cosparsity levels: l = [40 50 60 70 80]
% Used Algorithms:  (1)ASimCO; (2) IN-ASimCO(mu=0.2), (3) SAOL, (4) ISAOL
%
% For image recovery, the choices
% Lambda = {0.5 0.3 0.1 0.05 0.01 0.002}
% were made.
%
% In order to compare the performance to the SimCO algorithm, the codes for
% Analysis SimCo and incoherent Analysis SimCo are necessary. These are not
% included in this toolbox (but can be found on the homepage of the
% authors)
%
% Last modified: 03.04.2017 Michael Sandbichler
%
% This software is a free software distributed under the terms of the GNU 
% Public License version 3 (http://www.gnu.org/licenses/gpl.txt). You can 
% redistribute it and/or modify it under the terms of this licence, for 
% personal and non-commercial use and research purpose. 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all
close all

SimCo = 0; %toggle use of SimCO algorithms

sigma = 12.8;
testSample = 5;
l_vec = [40,50,60,70,80];
ImgName_cell = {'images/house.png', 'images/cameraman.png', 'images/barbara256.png','images/baboon256.png','images/peppers256.png'};

nIter = 2000;       %number of iterations for ASimCO, InASimCO and SAOL
itN_ISAOL = 500;    %number of iterations for ISAOL


for num_img = 1:size(ImgName_cell,2)
    % load clean image
    ImgName = ImgName_cell{num_img};
    A = imread(ImgName);    
    A = double(A);
    
    for num_l = 1:length(l_vec)
        l = l_vec(num_l);
        
        % for all l, run testSample tests
        for testNo = 1:testSample
            % generate noisy image
            AN = double(A) + sigma*randn(size(A));
            PSNRnoisy = 10*log10(255.^2/mean((AN(:)-double(A(:))).^2));
            
           %% Learn Omega==================
            n = 8;
            d = n^2;
            p = 2*d;
            
            N = 20000;         
            
            %extract patches from the noisy picture
            [Y,I] = pic2patches(AN,n,n);
            [~,Nfull] = size(Y);
            
            %normalize the signals for training
            aux = 1./sqrt(sum(Y.*Y));
            X = Y*spdiags(aux',0,Nfull,Nfull);
            
            OmegaInit = normr(randn(p, d));
            
            param.itN =1;
            param.cosparsity = l;
            param.numOmegaUpdate = 1;
            
            Omega_all(:, :, 1)= OmegaInit;
            Omega_all(:, :, 2)= OmegaInit;
            Omega_all(:, :, 3)= OmegaInit;
            Omega_all(:, :, 4)= OmegaInit;
            
            %training of the operators
            for i = 1:nIter
           
            Ind = randperm(Nfull);
            Xntrain = X(:,Ind(1:N));
                
            itN_ISAOL = 500;
            
            if SimCo == 1

           % Algorithm 1: ASimCO
            
            param.initialDictionary = Omega_all(:,:,1);
            [Omega] = analysis_SimCO_normalizedRowOmega(Xntrain, param);
            Omega_all(:, :, 1) = Omega;
            
            % Algorithm 2: IN-ASimCO, mu_0 = 0.2
            
            param.mu = 0.2;
            param.initialDictionary = Omega_all(:,:,2);
            [Omega] = In_AnalysisSimCO(Xntrain, param);
            Omega_all(:, :, 2) = Omega;
            
            end
            
            % Algorithm 3: SAOL
            
            param.initialDictionary = Omega_all(:,:,3);
            [Omega] = SAOL(param.itN, Xntrain,param.cosparsity,N,param.initialDictionary, 0.1);
            Omega_all(:, :, 3) = Omega;
            
            
            if i<=itN_ISAOL %Only perform itN_ISAOL steps of ISAOL 
            %Algorithm 4: ISAOL
            param.initialDictionary = Omega_all(:,:,4);
            [Omega] = ISAOL(param.itN, Xntrain,param.cosparsity,N,param.initialDictionary, 1);
            Omega_all(:, :, 4) = Omega;
            end
            
            end
            % ===========================
            
            %% Recovery Image
            Lambda = {0.5 0.3 0.1 0.05 0.01 0.002};
            % for each l, test differnt lambda
            for num_lambda = 1:length(Lambda)
                lambda = Lambda{num_lambda};
                
                if SimCo == 1
                    Algos = [1,2,3,4];
                else
                    Algos = [3,4];
                end
                
                for num_alg = Algos
                    Omega = Omega_all(:, :, num_alg);
                                    
                    lambda2 = lambda;

                    [Xdn,err] = AnalysisL1Denoising(Y, Omega, lambda2,1000);               
                    
                    [MM,NN]=size(AN);
                    Idn=patches2pic(Xdn,I,n);
                    
                    Idn=max(0,min(255,Idn));
                    
                    PSNRdn = 10*log10(255.^2/mean((Idn(:)-double(A(:))).^2));
                    
                    PSNRdn_all(1, num_lambda, num_alg, testNo) = PSNRdn;
                end
            end
        end
        
        % averaged value of all tests
        if SimCo==1          
        PSNRdn_ASimCO_mean          = mean(PSNRdn_all(1, :, 1, :), 4);
        PSNRdn_INASimCO_02_mean = mean(PSNRdn_all(1, :, 2, :), 4);
        end
        
        PSNRdn_SAOL_mean = mean(PSNRdn_all(1, :, 3, :), 4);
        PSNRdn_ISAOL_mean = mean(PSNRdn_all(1, :, 4, :), 4);
        
        switch ImgName
            case 'images/barbara256.png'
                image = 'Fabio';       
            case 'images/baboon256.png'
                image = 'Mandrill';
            case 'images/house.png'
                image = 'House';
            case  'images/cameraman.png'
                image = 'Cameraman';
            case 'images/peppers256.png'
                image = 'Peppers';
        end
        clear X
        clear Xntrain
        clear Idxn
        clear pos
        filename = [image,'_sigma',num2str(sigma),'_Comparison_l', num2str(l),'_',num2str(testSample),'tests'];
        save(filename);
    end
end