function y = MakeCosparseSignals(Op,l,m)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Generates m signals, which are cosparse (with cosparsity l) with respect
% to the analysis operator Op.
%Input:
%   -Op     ... Analysis operator
%   -l      ... Cosparsity - # of zeros in Op*y
%   -m      ... number of desired signals
%Output:
%   -y      ... signals stored in a matrix
%
% (c) 16.12.2016 Michael Sandbichler
%
% This software is a free software distributed under the terms of the GNU 
% Public License version 3 (http://www.gnu.org/licenses/gpl.txt). You can 
% redistribute it and/or modify it under the terms of this licence, for 
% personal and non-commercial use and research purpose. 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


[n,p] = size(Op);
y = (randn(p,m));
aux(1:p) = 0;
O(1:l,1:l) = 0;

for k = 1:m  
    L = randperm(n);
    L = L(1:l);
    L=sort(L);
    
    aux = y(:,k);
    O = Op(L,:)*Op(L,:)';
    aux = Op(L,:)*aux;
    [~,aux] = evalc('transpose(Op(L,:))*(O\aux);');
    y(:,k) = y(:,k) -aux;
end

scale = sum(y.*y);
y = y*spdiags((1./sqrt(scale))',0,m,m);
return;