function recerror=itkm_nsigtest(d,S,T,b)

% syntax: recerror=itkm_nsigtest(d,S,T,b)
%
% settings to reproduce Figure 1b in
% 'Local Identification of Overcomplete Dictionaries'
% arXiv:1401.6354
%
% d... 4/8/16 dimension
% S... 1/2 effective sparsity
% T... T=2S number of non-zero coefficients
% b... 0.01/0.1 decay parameter
%
% output:
% error... vector of average recovery errors for the 
%	   number of training signals varying from 2^7 to 2^14
%          and oracle initialisation
%
% Karin Schnass 24.01.14


% settings
maxit=1000; 
nruns=10;
nmin=0;
nmax=7;

if (nargin < 4)
     disp('default settings used, d=4, S=1, T=2S, b=0.01')
     d=4; S=1; T=2*S; b=0.01;
end

K=1.5*d;
dico = [eye(d), hadamard(d)/sqrt(d)];
dico(:,K-d/2 +1: K)=[];
error=zeros(1,nmax+1);

for run=1:nruns
    for n=nmin:nmax
        N=128 * 2^n;
        clear sigN;
        sigN=makesparsesig(dico,N,S,T,b); 
        recdico = itkm(sigN,K,S,maxit,dico);
        erritkm = max(sqrt(2*(1-max(abs(recdico'*dico)))));
        error(n+1)=error(n+1)+ erritkm;
    end
end
recerror=error/nruns;

