function recerror=itkm_noisetest(d,S,T,b)

% synt: recerror=itkm_noisetest(d,S,T,b)
%
% settings to reproduce Figure 2b in
% 'Local Identification of Overcomplete Dictionaries'
% arXiv:1401.6354
%
% d... 8/16 dimension
% S... 2/3 effective sparsity
% T... T=S number of non-zero coefficients
% b... 0.1/0.2 decay parameter
%
% output:
% error... vector of average recovery errors for Gaussian noise with
%	   variance 0:0.01:0.1 and oracle initialisation
%
% Karin Schnass 24.01.14

% settings
maxit=1000; 
N=2^14;
nruns=20;
noisestepsize=0.01;
noisesteps=11;

if (nargin < 4)
     disp('default settings used, d=8, S=T=2, b=0.1')
     d=8; S=2; T=S; b=0.1;
end
 
K=1.5*d;
dico = [eye(d), hadamard(d)/sqrt(d)];
dico(:,K-d/2 +1: K)=[];
error=zeros(1,noisesteps);
 
for run=1:nruns   
    for noisestep=1:noisesteps
        rho=(noisestep-1)*noisestepsize;
        clear sigN;
        sigN=makesparsesig(dico,N,S,T,b,rho); 
        recdico = itkm(sigN,K,S,maxit,dico);
        erritkm = max(sqrt(2*(1-max(abs(recdico'*dico)))));
        error(noisestep)=error(noisestep)+ erritkm;
    end
end
recerror=error/nruns;

