function recerror=itkm_btest(d,S,T)

% syntax: recerror=itkm_btest(d,S,T)
%
% settings to reproduce Figure 2a in
% 'Local Identification of Overcomplete Dictionaries'
% arXiv:1401.6354
%
% d... 8/16 dimension
% S... 1/2/3 effective sparsity
% T... 4/6 number of non-zero coefficients
%
% output:
% error... vector of average recovery errors for 
%          decay parameter b 0:0.01:0.1 and oracle initialisation
%
% Karin Schnass 24.01.14


% settings
maxit=1000; 
N=2^14;
nruns=10;
bstepsize=0.01;
bsteps=11;

if (nargin < 4)
     disp('default settings used, d=8, S=1, T=4, b=0.1')
     d=8; S=1; T=4; b=0.1;
end
 
K=1.5*d;
dico = [eye(d), hadamard(d)/sqrt(d)];
dico(:,K-d/2 +1: K)=[];
error=zeros(1,bsteps);

for run=1:nruns
    for bstep=1:bsteps
        b=(bstep-1)*bstepsize;
        clear sigN;
        sigN=makesparsesig(dico,N,S,T,b); 
        recdico = itkm(sigN,K,S,maxit,dico);
        erritkm = max(sqrt(2*(1-max(abs(recdico'*dico)))));
        error(bstep)=error(bstep)+ erritkm;
    end
end

recerror=error/nruns;
