%--------------------------------------------------------------------------
% simulation settings
%--------------------------------------------------------------------------
rng(1);                 % random generator seed
d = 256;                % signal dimension
m = ceil(d/2);          % embedding dimension
K = ceil(3*d/2);        % dictionary size
N = 100000;             % number of training signals per iteration
S = 4;                  % sparsity level (4,8,12,16)
rho = 0;                % noise level (0,1/sqrt(d))
b = 0.1;                % coefficient decay parameter (0,1)
runs = 1;               % number of random initialisations
maxit = 100;            % iterations of IcTKM per run
%--------------------------------------------------------------------------

% Oracle dictionary (Dirac + half DCT)
dico=[eye(d),dct(eye(d))];
dico(:,K+1:2*d)=[];

rcorr=zeros(runs,K);
for i=1:runs
    % Create input dictionary
    dinit=randn(d,K);
    dinit=dinit*diag(1./sqrt(sum(dinit.*dinit)));
            
    % create sparse signals
    Y=make_sparse_signal(dico,N,S,S,b,rho);
    
    % run IcTKM
    rdico=ictkm_simplified(Y,K,S,m,maxit,dinit);
    rcorr=max(abs(rdico'*dico));   
        
    % Count the number of recovered atoms
    rec_count = find(rcorr > 0.99);                 
    % Calculate percentage of recovered atoms
    percent_recov = (length(rec_count)/K)*100;     
    
    display(['percent of recovered atoms: ' num2str(percent_recov)]);
end

