function [dico2dS] = showdico(dico, s1, space, nrow)

% syntax: dico2dS = showdico(dico, s1, space, nrow);
%
% converts vectorised 3d signals  
% back to 3d and puts them into a big matrix
% usage: imagesc(showdico(dico))
%
% input:
% dico... s_1*s_2* 3 x K matrix of K 3d signals of size s_1xs_2x 3
%                       (e.g. image patches) 
% s1...    3d width ...default sqrt(d/3)
% space... space between images ... default 2 pixel
% nrow...  number of images per column ... default min(s_1,ceil(sqrt(K)))
%                                                  
%
% last modified 12.01.17
% Karin Schnass 

s3 = 3;
[d,K]=size(dico);

if nargin < 2
    s1=ceil(sqrt(d/s3));
end

s2 = d/(s1*s3);

if s2*s1*s3 ~= d
    disp('wrong size s1');
    return;
end

if nargin < 3
    space = 2;
end

if nargin < 4
    nrow = min(s1,ceil(sqrt(K)));
end

[dummy,I]=max(abs(dico));
for k=1:K
    dummy(k)=sign(dico(I(k),k));
end
dico=dico*diag(dummy);
dico2d=[];
fac=-max(max(abs(dico)));
%nrow=ceil(sqrt(K));
ncol=ceil(K/nrow);
for row = 1:nrow
    newrow=[];
    for col =1:ncol
        k=(row-1)*ncol + col;
        if k <=K
            newrow=[newrow, reshape(dico(:,k),[s1,s2,s3]),fac*ones(s1,space,3)];
        else
            newrow=[newrow, fac*ones(s1,s2,s3),fac*ones(s1,space,3)];
        end
    end
    dico2d=[dico2d; newrow; fac*ones(space,ncol*(s2+space),3)];
end; 

dico2d=[fac*ones(space,ncol*(s2+space),3);dico2d];
dico2d=[fac*ones(nrow*(s1+space)+space,space,3) dico2d];


dico2dS = (dico2d - min(dico2d(:))) / (max(dico2d(:)) - min(dico2d(:)));

