function [pic,seen] = patches2pic(patches,locations,s1, s2, s3)

% syntax: patches = pic2patches(pic,locations, s1,s2,s3)
%
% selects N random patches of size s1xs2xs3 out of a pic
% and stores them as (s1.s2.s3) x N matrix
%
% input
% patches... (s1.s2.s3) x N matrix, each patch stored as s1.s2.s3 column vector
%              to get to 3d shape use pn2d=reshape(patches(:,n),[s1,s2,s3])
% s1.... width of 3d signal
% s2.... height of 3d signal
% s3.... depth of signal (colour)
% locations...2 times N matrix of locations of each patch in original image
%
% output:
% pic... estimated picture
%                                                  
%
% last updated 20.03.17


%%%% preparations

if(nargin < 2)
    disp('synthax: pic = patches2pic(patches,locations,s1)');
    return;
end

[d,N]=size(patches);

if nargin < 3
    s1=sqrt(d);
end
    
s2=d/(s1*s3);

if s2*s1*s3 ~= d
    disp('wrong or no size s1');
    return;
end

d1=max(locations(1,:)) + s1-1;
d2=max(locations(2,:)) + s2-1;
d3 = s3;

pic= zeros(d1,d2,d3);
seen = zeros(d1,d2,d3);

for n=1:N
    n1=locations(1,n);
    n2=locations(2,n);
    pic(n1:n1+s1-1, n2:n2+s2-1,:)=pic(n1:n1+s1-1, n2:n2+s2-1,:)+reshape(patches(:,n),s1,s2,s3);
    seen(n1:n1+s1-1, n2:n2+s2-1,:)=seen(n1:n1+s1-1, n2:n2+s2-1,:)+ones(s1,s2,s3);
end

seen=max(seen, ones(d1,d2,d3));

pic=pic./seen;

