function A=aOMPm(D, X, Mask, Nmax)
%=============================================
% This is a modified version of OMP to account for corruptions in the signal.
% A slightly different modification of Masked OMP is available in
% "Sparse and Redundant Representations: From Theory to
% Applications in Signal and Image Processing," the book written by M. Elad in 2010.
% Sparse coding of a group of signals based on a given 
% dictionary and specified number of atoms to use. 
% input arguments: 
%       D - the dictionary (its columns MUST be normalized).
%       X - the masked signals to represent (MX=MDA)
%       Mask - the masks on the signal
%       Nmax - the max. number of coefficients for each signal.
% Output argument:
%       A - sparse coefficient matrix.
%=============================================

[~,P]=size(X);
[n,K]=size(D);

if nargin < 4
    Nmax = n/3;
end

for k=1:1:P,
    iter = 0;
    a=[];
    x = X(:,k);
    m = Mask(:,k);
    xm=x.*m;
    residual=xm;
    Dm=D.*(m*ones(1,K));

% normalisation of atoms atoms MD_i/\|MD_i\|_2
    scale = sqrt(sum(Dm.*Dm));
    nonzero = find(scale > 0.001/sqrt(n));
    scale(nonzero) = 1./scale(nonzero);
   
    indx=zeros(Nmax,1);
    
    while sum(residual.^2) > 1e-6 
        iter = iter+1;
        proj=Dm'*residual;
        proj = scale'.*proj;

        [maxVal,pos]=max(abs(proj));
        pos=pos(1);
        indx(iter)=pos;
        a=pinv(Dm(:,indx(1:iter)))*xm;
        residual=xm-Dm(:,indx(1:iter))*a;
        if iter > Nmax
            break;
        end
    end
    temp=zeros(K,1);
    temp(indx(1:iter))=a;
  
    A(:,k)=sparse(temp);
end;
