%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% this is a plug-and-play test file for the curious reader
% all settings can be made in the "initializations" section of the code
% feel free to fiddle around with the parameters
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all
close all

%% initializations

rng(42) 

%replacement threshold
replThres = 0.8;

runs = 1;      % number of different initializations (for averaging)
maxit = 1000;   % number of iterations of the algorithm

d = 20;     %ambient dimension of the signals
K = 2*d;    %number of rows of the analysis operator

M = 2^18;     % #of generated sample vectors
m = 2^15;     % #of sample vectors used in each iteration
ell = d-4;        % cosparsity level
al =1;     % stepsize parameter (important for SAOL)
np = 0;     % noise parameter

hitsRandInit(1:maxit,1:runs) = 0;
hitsCloseInit(1:maxit,1:runs) = 0;


%% Build the Target operator
%%dirac-dct operator
OmTarget(1:d,1:d) = eye(d);
OmTarget(d+1:K,1:d) = dct(eye(d));

%%%random operator
% OmTarget = randn(K,d); 
% scale = sum(OmTarget.*OmTarget,2); 
% OmTarget = diag(1./sqrt(scale))*OmTarget;

%% trainings
for l = 1:runs

    %initialization of our startingoperators

    % random
    GFAOL =  randn(K,d);
    scale = diag(GFAOL*GFAOL');
    GFAOL= diag(1./sqrt(scale))*GFAOL;

    GIAOL = GFAOL;
    GSVAOL = GFAOL;

    tic
    Y = MakeCosparseSignals(OmTarget,ell,M);
    Y = Y+np/sqrt(d)*randn(d,M);
    scale = sum(Y.*Y);
    Y = Y*spdiags((1./sqrt(scale))',0,M,M);

    if sum(sum(isnan(Y)))>0
        disp('NaN found in generated data. Please check the target operator.');
        while(sum(sum(isnan(Y)))>0)
            Y = MakeCosparseSignals(OmTarget,ell,M);
            Y = Y+np/sqrt(d)*randn(d,M);
            scale = sum(Y.*Y);
            Y = Y*spdiags((1./sqrt(scale))',0,M,M);
        end
    end
    toc  

    for k=1:maxit

        tic
        GFAOL = FAOL(1,Y,ell,m,GFAOL,replThres);
        tFAOL(k) = toc;      
        tic
        GIAOL  =  IAOL(1,Y,ell,m,GIAOL,replThres);
        tIAOL(k) = toc;
        tic
        GSVAOL  =  SVAOL(1,Y,ell,m,GSVAOL,10,replThres);
        tSVAOL(k) = toc;

        %find out how many rows have already been recovered
        thres = 0.99;
        corr1 = (max(abs(OmTarget*[GFAOL]')')>thres);
        corr2 = (max(abs(OmTarget*[GIAOL]')')>thres);
        corr3 = (max(abs(OmTarget*[GSVAOL]')')>thres);

        hitsFAOLInit(k,l) = sum(corr1)/K;
        hitsIAOLInit(k,l) = sum(corr2)/K;
        hitsSVInit(k,l) = sum(corr3)/K;

        hitsFAOL = mean(hitsFAOLInit(:,1:l),2);
        hitsIAOL = mean(hitsIAOLInit(:,1:l),2);
        hitsSV = mean(hitsSVInit(:,1:l),2);

        % compute the target function values
        % targ1(k) = targetFixedData(G1,ell,Y(:,:));
        % targ2(k) = targetFixedData(G2,ell,Y(:,:));
        % targ3(k) = targetFixedData(G3,ell,Y(:,:));

        % plot the recovery history
        figure(1)
        plot(hitsFAOL(1:k));
        hold on
        plot(hitsIAOL(1:k));
        plot(hitsSV(1:k));
        hold off
        
        figure(2)
        subplot(1,4,1);
        imagesc(OmTarget);
        title('target');
        subplot(1,4,2);
        imagesc(orderRows(GFAOL,OmTarget,0.9));
        title('FAOL');
        subplot(1,4,3);
        imagesc(orderRows(GIAOL,OmTarget,0.9));
        title('IAOL');
        subplot(1,4,4);
        imagesc(orderRows(GSVAOL,OmTarget,0.9));
        title('SVAOL');
        drawnow();

    end    

end