%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% this is a plug-and-play test file for the curious reader
% all settings can be made in the "initializations" section of the code
% feel free to fiddle around with the parameters
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all
close all

%%% set-up

rng(42) 

runs = 1;      %%% number of different initializations (for averaging)
maxit = 50;   %%% number of iterations of the algorithm

%replacement threshold
replThres = 1;      %%% better conservative > 0.95

patchSize = 8;      

d = patchSize^2;     %%% ambient dimension of the signals
K = d;               %%% number of rows of the analysis operator

m = 2^15;     %%% number of sample vectors used in each iteration
ell = d-7;    %%% cosparsity level
s = d-ell;    %%% corresponding sparsity level
np = 0;       %%% noise parameter


pic = double(imread('images/fabio.jpg'));

noisy_pic = pic + np*randn(size(pic));
PSNR = psnr(pic,noisy_pic)

Y = pic2patches(noisy_pic,patchSize);
tFAOL=0;
tIAOL=0;
tSVAOL=0;

%%%% runs
for run = 1:runs

    % random initialization of our startingoperators
    
    Ginit = randn(K,d);
    scale = diag(Ginit*Ginit');
    Ginit= diag(1./sqrt(scale))*Ginit;

    GFAOL = Ginit;
    GIAOL = Ginit;
    GSVAOL = Ginit;

    iter = 1;  %% show results every iter (iterations)

    for k=1:maxit/iter

       tic
       GFAOL = FAOL(iter,Y,ell,m,GFAOL,replThres);
       tFAOL = tFAOL + toc;      
       tic
       GIAOL  =  IAOL(iter,Y,ell,m,GIAOL,replThres);
       tIAOL = tIAOL + toc;
       tic
       GSVAOL  =  SVAOL(iter,Y,ell,m,GSVAOL,10,replThres);
       tSVAOL = tSVAOL + toc;


        %compute the value of the target function
        hitsFAOLInit(k,run) = targetFixedData(GFAOL,ell,Y);
        hitsIAOLInit(k,run) = targetFixedData(GIAOL,ell,Y);
        hitsSVInit(k,run) = targetFixedData(GSVAOL,ell,Y);

        hitsFAOL = mean(hitsFAOLInit(:,1:run),2);
        hitsIAOL = mean(hitsIAOLInit(:,1:run),2);
        hitsSV = mean(hitsSVInit(:,1:run),2);

        % plot the recovery history
        subplot(221)
        plot(hitsFAOL(1:k));
        hold on
        plot(hitsIAOL(1:k));
        plot(hitsSV(1:k));
        hold off
        legend('FAOL','IAOL','SVAOL')

        subplot(222)
        imagesc(showdico(GFAOL',patchSize));
        title('FAOL');

        subplot(223)
        imagesc(showdico(GIAOL',patchSize));
        title('IAOL');

        subplot(224)
        imagesc(showdico(GSVAOL',patchSize));
        title('SVAOL');
        drawnow();

    end    

end