function [x,s,stat] = SSVIICG(A,iter)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% implements Symmetric singular value inverse iteraton to find the
% smallest singular value and corresponding singular vector of a
% symmetric matrix A. This has been described in the paper 
%'Iterative computation of the smallest singular value and the
% corresponding singular vectors of a matrix' by Schwetlick and Schnabel
%
% Input:
%   - A:    symmetric real matrix
%   - iter: number of iterations
% Output:
%   - x:    singular vector corresponding to the smallest singluar value of
%           A
%   - s:    smallest singular value of A
%   - stat: indicates abort due to ill conditioned matrix
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  
  [n,~] = size(A);
  
  x = randn(n,1);
  x=  x/norm(x);
  
  stat= 0;
  
  for k=1:iter
  Aaug = [A,x;x',0];
  
  b = zeros(n+1,1);
  b(end) = 1;
  
  lastwarn('','')
  
  %invert with CG method
  y = CG(@(x)Aaug*x,n+1,b,100,1e-7);
  
  %rule out bad cases
  [~,warnid] = lastwarn;
  if(~isempty(warnid))
      x = randn(n,1);
      x/norm(x);
      s=1;
      warning('aborted due to ill-conditioned matrix');
      stat = 1;
      break;
  end
  
  x = y(1:n);
  m =y(end);
  
  aux = norm(x);
  x=x/aux;
  m = m/aux;
  s = abs(m);
  end
end