function G = SAOL(Niter,Y,l,num,G,thres,perc,display)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Implements the AOL Gradient Descent algorithm using Niter iterations
% starting from an operator G with measurement data Y, for which we have
% that Op*y is sparse. We want to find Op.
% In addition, we use a replacement strategy for the operator G, so if two
% rows have a larger overlap than thresRepl, one of the rows is
% reinitialized.
%
% Input:
%   -Niter  ... Number of iterations
%   -Y      ... Signal data
%   -l      ... Cosparsity
%   -num    ... Number of sampled signals in each step
%   -G      ... Starting operator (default: random, size 2dxd)
%   -thres  ... replacement threshold (default: 1 = no replacement)
%   -perc   ... percentage of samples used for computation of stepsize
%   (default:10)
%   -display ...output warnings etc.
%
% Output:
%   -G      ... the learned operator
%
% (c) 16.12.2016 Michael Sandbichler
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% initializations and error catches
[d,N] = size(Y);

if nargin < 3
    err('Too few input arguments.');
    return;
end

if nargin <4
    num = N;
end

if nargin < 5
    G= randn(2*d,d);
    scale = diag(G*G');
    G = diag(1./sqrt(scale))*G;
else
[n,d1] = size(G);
if d1~=d
   disp('Input operator G has the wrong size. Choosing a random operator instead.');
    G= randn(n,d);
    scale = diag(G*G');
    G = diag(1./sqrt(scale))*G;
end
end

if nargin < 6
    thres= 1;
end

if nargin < 7
    perc = 10;
end

if nargin < 8
    display = 1;
end

if num > N
    num = N;
end

I = [];
grad(1:n,1:d) = 0;
z(1:n,1:d) = 0;
b(1:n) = 0;

%% the algorithm
for iter =1:Niter
    
    %draw a sample of size num from the data Y
    sample = randperm(N);
    sample = sample(1:num);
    ySub = Y(:,sample);
    count(1:n) = 0;
    count2(1:n) = 0;
    c(1:n) = 0;
    active(1:n) = 0;
    for sam = 1:num
    
    S = G*ySub(:,sam);
    
    %find the l smallest entries in each column
    [~,indices] = sort(abs(S),1);
    indices = indices(1:l);
    for k = 1:n   

    if (min(abs(indices-k))<1e-15)
    count(k) = count(k)+1;    
    if sam>(1-perc/100)*num
      count2(k) = count2(k)+1;  
      c(k) = (count2(k)-1)/count2(k)*c(k)+ 1/count2(k)*abs(grad(k,:)*ySub(:,sam))^2;
    end
    grad(k,:) = (count(k)-1)/count(k)*grad(k,:)+ 1/count(k)*S(k)*ySub(:,sam)';
    end
            
    end

    end
    
    for k= 1:n
    %perform the gradient step for each of the rows of G
    a = grad(k,:)*G(k,:)';
    b = norm(grad(k,:))^2;
    active(k) = count(k);

    if b^2 - a*c(k)==0
        if b ==0
            t = 0;
        else
            t = a/b;
        end
    else
    t = ((a*b - c(k))+sqrt((c(k)-a*b)^2 - 4*(b^2-a*c(k))*(a^2-b)))/(2*(b^2-a*c(k)));
    end
    
    %perform the gradient step for each of the rows of G
 
     G(k,:) = G(k,:)- alPar*t*grad(k,:); %Gradient descent step
    
    %normalize or redraw the row if the norm is too small
    if(norm(G(k,:))>1e-13)
    G(k,:) = G(k,:)/norm(G(k,:));
    else
    G(k,:) = randn(1,d);
    G(k,:) = G(k,:)/norm(G(k,:));
    end
    end  
    
    %perform replacement
    [G, breakCounter] = replaceDuplicates(G,thres,active,10);
     if display && (breakCounter > 0)
        disp(strcat('SAOL: ',num2str(breakCounter),' duplicate rows replaced (max 10)'));
     end
     if display && (breakCounter >= 10)
        disp(strcat('max. number of replacement reached, check threshold'));
     end

end
% close(h);
