function xout = CG(fun,N,y,maxIter,tol)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% solve fun(x) = y via CG
% -> wikipedia https://de.wikipedia.org/wiki/CG-Verfahren
% -> https://en.wikipedia.org/wiki/Conjugate_gradient_method
%
% Input:
%   fun: linear map
%   N  : output vector dimension
%   maxIter: maximum # of iterations
%   tol: tolerance to be reached
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    xout = randn(N,1);
    %xout = xout/norm(xout);
    
    r0 = y - fun(xout);
    d = r0;
    
    for k=1:maxIter
        
            z = fun(d);
            a = (r0'*r0)/(d'*z);
            xout = xout+a*d;
            r1 = r0-a*z;
                if(norm(r1)<=tol)
                    break;  
                end
            b = (r1'*r1)/(r0'*r0);
            d = r1+b*d;
            r0 = r1;
            
       
        
    end
end