\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{lfu_na_a}[2014/5/22 LFU]
\LoadClass[a4paper,11pt]{scrartcl}

\RequirePackage{theorem, amsmath, amssymb,graphicx}

\providecommand{\title}[1]{\def\@title{#1}}
\providecommand{\institution}[1]{\def\@institution{#1}}
\providecommand{\country}[1]{\def\@country{#1}}
\providecommand{\email}[1]{\def\@email{#1}}

\newcommand\@authori{}
\newcommand\@authorii{}
\newcommand\@authoriii{}
\newcommand\@authoriv{}
\newcommand\@authorv{}
\newcommand\@authorvi{}
\newcommand\@institutioni{}
\newcommand\@institutionii{}
\newcommand\@institutioniii{}
\newcommand\@institutioniv{}
\newcommand\@institutionv{}
\newcommand\@institutionvi{}

\newcounter{icount}
\setcounter{icount}{1}
\newcommand\makecmd[2]{%
\expandafter\renewcommand\csname #1\roman{icount}\endcsname{#2}%
}

\newcommand\@@author[1]{\makecmd{@author}{#1}}
\newcommand\@@institution[1]{\makecmd{@institution}{#1}}
%\long\def\abstract#1{\long\gdef\@abstract{#1}}
\newcommand\speaker[1]{{#1}}
\newcommand\authorbreak{{}}
\renewcommand\title[1]{\renewcommand\@title{#1}}
\renewcommand\author[1]{
  \@@author{\authorbreak\small{\speaker{#1}}}
  \@@institution{\@institution, \@country}
  \stepcounter{icount}
}
\newcommand\coauthor[2]{\renewcommand\speaker[1]{{##1\,$^{\ast}$}}
  \@@author{\authorbreak\small{#1}}
  \@@institution{#2}
  \stepcounter{icount}
}
           
\renewenvironment{thebibliography}[1]{%
\par
\vskip 13pt
\bgroup%\small
\noindent\textbf{References}\par\vskip 6.5pt
\egroup 

      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \setlength{\itemsep}{0pt}%
            \setlength{\parskip}{0pt}%
            \setlength{\topsep}{0pt}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}%
            \small}%
      \sloppy
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}



\def\makeabstitle{
  {
	\hrule\vskip10pt
    \parindent0pt
    {\hfill\large\sc\@title\hfill}
    \vskip3pt
	\begin{center}
    \@authori \, \if\@institutioni\@empty\else({\@institutioni})\fi
   \renewcommand\authorbreak{\\}
    \@authorii	\, \if\@institutionii\@empty\else({\@institutionii})\fi
    \@authoriii\, \if\@institutioniii\@empty\else({\@institutioniii})\fi
    \@authoriv	\, \if\@institutioniv\noexpand\@empty\else({\@institutioniv})\fi
    \@authorv	\, \if\@institutionv\@empty\else({\@institutionv})\fi
    \@authorvi	\, \if\@institutionvi\@empty\else({\@institutionvi})\fi
	\end{center}
    \vskip4pt
	\hrule
	\vskip 15pt
  }
}
\def\toolong{\ifnum\thepage=1\relax \else \textbf{Your abstract is too long, please compress it!}\@latex@warning{Your abstract is too long, please compress it!}\fi}
\AtEndDocument{\toolong}
\endinput
