/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.util;

import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.util.IntervalIterator;

public final class Grid2D {
    private Grid2D() {
    }

    public static Punkt2D[][] createGrid2D(Punkt2D[][] grid) {
        Punkt2D[][] gridpoints = new Punkt2D[grid[0].length][grid[1].length];
        int i = 0;
        while (i < grid[1].length) {
            int j = 0;
            while (j < grid[0].length) {
                gridpoints[j][i] = new Punkt2D();
                gridpoints[j][i].x = grid[0][j].x;
                gridpoints[j][i].y = grid[1][i].y;
                ++j;
            }
            ++i;
        }
        return gridpoints;
    }

    public static Punkt2D[][] createGrid2D(double xmin, double xmax, double ymin, double ymax, int gridx, int gridy) {
        if (xmax - xmin <= 0.0 || ymax - ymin <= 0.0 || gridx < 2 || gridy < 2) {
            throw new IllegalArgumentException();
        }
        Punkt2D[][] gridpoints = new Punkt2D[gridx][gridy];
        IntervalIterator xIt = new IntervalIterator(xmin, xmax, gridx);
        IntervalIterator yIt = new IntervalIterator(ymin, ymax, gridy);
        while (xIt.hasNext()) {
            double x = xIt.nextdouble();
            while (yIt.hasNext()) {
                double y = yIt.nextdouble();
                gridpoints[xIt.getPos() - 1][yIt.getPos() - 1] = new Punkt2D(x, y);
            }
            yIt.reset();
        }
        return gridpoints;
    }
}

