/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.scene3d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import uibk.mtk.draw3d.base.MathPanel3D;
import uibk.mtk.lang.Messages;
import uibk.mtk.swing.base.ButtonNoFocus;
import uibk.mtk.swing.base.TitledPanel;

public class PanelView3D
extends TitledPanel
implements ActionListener {
    private static final double DISTANCE_OFFEST = 0.1;
    protected JButton buttonDefaultView;
    protected JComboBox comboPlanes;
    protected JLabel labeldistance;
    protected JLabel labelplanes;
    protected JRadioButton optParallelProj;
    protected JRadioButton optPerspectiveProj;
    protected ButtonNoFocus buttonnearer;
    protected ButtonNoFocus buttonfarer;
    MathPanel3D mathpanel3d;
    static final String BUNDLE_NAME = "uibk.mtk.swing.scene3d.messages";
    private static final String STRTITLE = Messages.getString("uibk.mtk.swing.scene3d.messages", "PanelView3D.0");
    private static final String STRPERSPECTIVE = Messages.getString("uibk.mtk.swing.scene3d.messages", "PanelView3D.1");
    private static final String STRPARALLEL = Messages.getString("uibk.mtk.swing.scene3d.messages", "PanelView3D.2");
    private static final String STRPLANE = Messages.getString("uibk.mtk.swing.scene3d.messages", "PanelView3D.3");
    private String strplanexy = Messages.getString("uibk.mtk.swing.scene3d.messages", "PanelView3D.4");
    private String strplanexz = Messages.getString("uibk.mtk.swing.scene3d.messages", "PanelView3D.5");
    private String strplaneyz = Messages.getString("uibk.mtk.swing.scene3d.messages", "PanelView3D.6");
    private static final String STRDISTANCE = Messages.getString("uibk.mtk.swing.scene3d.messages", "PanelView3D.7");
    private static final String STRDEFAULT = Messages.getString("uibk.mtk.swing.scene3d.messages", "PanelView3D.8");

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.buttonnearer.setEnabled(false);
        this.buttonfarer.setEnabled(false);
        this.buttonDefaultView.setEnabled(false);
        this.buttonfarer.setEnabled(false);
    }

    public PanelView3D(MathPanel3D mathpanel3d) {
        super(STRTITLE);
        if (mathpanel3d == null) {
            throw new NullPointerException(Messages.getString(BUNDLE_NAME, "PanelView3D.9"));
        }
        this.mathpanel3d = mathpanel3d;
        this.initComponents();
    }

    public PanelView3D(MathPanel3D mathpanel3d, String[] planenames) {
        super(STRTITLE);
        this.mathpanel3d = mathpanel3d;
        this.initComponents();
        this.strplanexy = planenames[0];
        this.strplanexz = planenames[1];
        this.strplaneyz = planenames[2];
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(2000, 280));
        this.buttonDefaultView = new JButton(STRDEFAULT);
        this.optParallelProj = new JRadioButton(STRPARALLEL);
        this.optPerspectiveProj = new JRadioButton(STRPERSPECTIVE);
        ButtonGroup groupProjectionOpt = new ButtonGroup();
        groupProjectionOpt.add(this.optParallelProj);
        groupProjectionOpt.add(this.optPerspectiveProj);
        this.optPerspectiveProj.setSelected(true);
        this.optPerspectiveProj.setActionCommand("perspective");
        this.optParallelProj.setActionCommand("parallel");
        this.optPerspectiveProj.addActionListener(this);
        this.optParallelProj.addActionListener(this);
        URL urlIconPlus = this.getClass().getResource("/uibk/mtk/swing/res/plus.gif");
        URL urlIconMinus = this.getClass().getResource("/uibk/mtk/swing/res/minus.gif");
        this.buttonnearer = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.buttonfarer = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.buttonnearer.setActionCommand("nearer");
        this.buttonfarer.setActionCommand("farer");
        this.buttonDefaultView.setActionCommand("defaultview");
        this.buttonDefaultView.addActionListener(this);
        this.buttonfarer.addActionListener(this);
        this.buttonnearer.addActionListener(this);
        this.labeldistance = new JLabel(STRDISTANCE);
        this.labelplanes = new JLabel(STRPLANE);
        this.comboPlanes = new JComboBox<String>(new String[]{this.strplanexy, this.strplanexz, this.strplaneyz});
        this.comboPlanes.addActionListener(this);
        this.comboPlanes.setActionCommand("planes");
        this.comboPlanes.setPreferredSize(new Dimension(100, 20));
        this.comboPlanes.setMaximumSize(new Dimension(100, 20));
        this.comboPlanes.setMinimumSize(new Dimension(100, 20));
        this.add((Component)this.optPerspectiveProj, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.labeldistance, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
        this.add((Component)this.buttonfarer, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.buttonnearer, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.optParallelProj, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.labelplanes, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.add((Component)this.comboPlanes, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.add((Component)this.buttonDefaultView, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 10, 0, new Insets(50, 0, 0, 0), 0, 0));
    }

    public void actionPerformed(ActionEvent ev) {
        double dist;
        if (ev.getActionCommand().equals("nearer")) {
            dist = this.mathpanel3d.getScene3D().getDistance();
            this.mathpanel3d.getScene3D().setDistance(dist - 0.1);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("farer")) {
            dist = this.mathpanel3d.getScene3D().getDistance();
            this.mathpanel3d.getScene3D().setDistance(dist + 0.1);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("planes")) {
            JComboBox cb = (JComboBox)ev.getSource();
            String strplane = (String)cb.getSelectedItem();
            if (strplane.equals(this.strplanexy)) {
                this.mathpanel3d.getScene3D().projectXYPlane();
            }
            if (strplane.equals(this.strplanexz)) {
                this.mathpanel3d.getScene3D().projectXZPlane();
            }
            if (strplane.equals(this.strplaneyz)) {
                this.mathpanel3d.getScene3D().projectYZPlane();
            }
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("defaultview")) {
            this.mathpanel3d.getScene3D().defaultview();
            this.optPerspectiveProj.setSelected(true);
            this.buttonfarer.setEnabled(true);
            this.buttonnearer.setEnabled(true);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("perspective")) {
            this.mathpanel3d.getScene3D().setProjectionType(0);
            this.buttonfarer.setEnabled(true);
            this.buttonnearer.setEnabled(true);
            this.labeldistance.setEnabled(true);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("parallel")) {
            this.mathpanel3d.getScene3D().setProjectionType(1);
            this.buttonfarer.setEnabled(false);
            this.buttonnearer.setEnabled(false);
            this.labeldistance.setEnabled(false);
            this.labeldistance.setEnabled(false);
            this.mathpanel3d.repaint();
        }
    }
}

