/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.functions;

import uibk.mtk.lang.Messages;
import uibk.mtk.math.functions.Function;
import uibk.mtk.parser.realparser.Expr;
import uibk.mtk.parser.realparser.Variable;

public class ParsedFunction
extends Function {
    private static final String BUNDLE_NAME = "uibk.mtk.math.functions.messages";
    Variable[] variables;
    Expr[] functions;

    public ParsedFunction(Variable[] variables, Expr[] functions) {
        super(variables.length, functions.length);
        this.functions = functions;
        this.variables = variables;
    }

    public double[] getValue(double[] x) {
        if (x == null || x.length != this.n) {
            throw new IllegalArgumentException(Messages.getString(BUNDLE_NAME, "ParsedFunction.0"));
        }
        int i = 0;
        while (i < this.n) {
            this.variables[i].setValue(x[i]);
            ++i;
        }
        double[] y = new double[this.m];
        int i2 = 0;
        while (i2 < this.m) {
            y[i2] = this.functions[i2].value();
            ++i2;
        }
        return y;
    }

    public String toString() {
        if (this.functions == null || this.functions.length == 0) {
            return "";
        }
        int n = this.functions.length;
        if (n == 0) {
            return this.functions[0].toString();
        }
        String str = "(";
        int i = 0;
        while (i < n) {
            str = String.valueOf(str) + this.functions[i].toString();
            if (i < n - 1) {
                str = String.valueOf(str) + "\n";
            }
            ++i;
        }
        str = String.valueOf(str) + ")";
        return str;
    }
}

