/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math;

import uibk.mtk.math.functions.Function1D;
import uibk.mtk.util.IntervalIterator;

public class SingularityChecker {
    static int SINGCHECK_DISCRETSIZE = 30;
    static final double FACMIN = 0.001;
    static final double FACDIFF = 10.0;
    double thresh_sure;
    static final double THRESHOLDFACTOR = 0.3;
    double thresh_min;
    int discretsize = SINGCHECK_DISCRETSIZE;

    public SingularityChecker(double min, double max) {
        this.thresh_sure = (max - min) * 0.3;
        this.thresh_min = Math.max(0.001 * (max - min), 1.0E-4);
    }

    public SingularityChecker(double min, double max, int size) {
        this(min, max);
        this.discretsize = size;
    }

    public boolean hasSingularity(Function1D f, double xmin, double xmax) {
        IntervalIterator it1 = new IntervalIterator(xmin, xmax, this.discretsize);
        IntervalIterator it2 = new IntervalIterator(xmax, xmin, this.discretsize);
        return this.hassing(it1, f) || this.hassing(it2, f);
    }

    private boolean hassing(IntervalIterator it, Function1D f) {
        double last = 0.0;
        double sum = 0.0;
        int c = 0;
        while (it.hasNext()) {
            double t = it.nextdouble();
            double z = f.getValue(t);
            if (Double.isNaN(z) || Double.isInfinite(z)) {
                return true;
            }
            if (it.getPos() > 1) {
                double diff = Math.abs(z - last);
                if (diff > this.thresh_sure) {
                    return true;
                }
                if (c > 0 && sum > this.thresh_min && diff > sum / (double)c * 10.0) {
                    return true;
                }
                sum += diff;
                ++c;
            }
            last = z;
        }
        return false;
    }
}

