/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math;

import Jama.Matrix;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.ComputationException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.functions.ParsedFunction2D;

public class NewtonMethod2D {
    Matrix x = new Matrix(2, 1);
    ParsedFunction2D function;
    int type;
    public static final int TYPE_STANDARD = 0;
    public static final int TYPE_SIMPLE = 1;
    Matrix x0 = new Matrix(2, 1);
    Matrix dx = new Matrix(2, 1);
    Matrix defect = new Matrix(2, 1);
    static final String BUNDLE_NAME = "uibk.mtk.math.messages";

    public NewtonMethod2D(ParsedFunction2D function) {
        this.setFunction(function);
    }

    public void setFunction(ParsedFunction2D function) {
        this.function = function;
    }

    public NewtonMethod2D() {
    }

    public double getX() {
        return this.x.get(0, 0);
    }

    public double getY() {
        return this.x.get(1, 0);
    }

    public Matrix getXY() {
        return this.x;
    }

    public double getIncrement() {
        return this.dx.normF();
    }

    public double getDefect() {
        return this.defect.normF();
    }

    public void setX0(double x) {
        this.x.set(0, 0, x);
    }

    public void setY0(double x) {
        this.x.set(1, 0, x);
    }

    public void setXY0(Matrix x) {
        this.x = x;
    }

    public void setJacobiPostion(Matrix x0) {
        this.x0 = x0;
    }

    public Matrix nextApproximation() throws ComputationException {
        double lambda = 0.5;
        Matrix deriviation = new Matrix(2, 2);
        if (this.function == null) {
            throw new ComputationException(Messages.getString(BUNDLE_NAME, "NewtonMethod.0"));
        }
        try {
            Matrix tempx = this.type == 1 ? this.x0 : this.x;
            Punkt2D punkt = new Punkt2D(tempx.get(0, 0), tempx.get(1, 0));
            Punkt2D[] deriv = this.function.getDerivate2(punkt);
            deriviation.set(0, 0, deriv[0].x);
            deriviation.set(0, 1, deriv[1].x);
            deriviation.set(1, 0, deriv[0].y);
            deriviation.set(1, 1, deriv[1].y);
        }
        catch (Exception ex) {
            throw new ComputationException(ex.getMessage());
        }
        if (deriviation.rank() != 2) {
            throw new ComputationException("f'(" + this.x + Messages.getString(BUNDLE_NAME, "NewtonMethod.2"));
        }
        if (Double.isNaN(deriviation.norm1()) || Double.isInfinite(deriviation.norm1())) {
            throw new ComputationException(Messages.getString(BUNDLE_NAME, "NewtonMethod.3"));
        }
        Punkt2D def = this.function.getDerivate1(new Punkt2D(this.x.get(0, 0), this.x.get(1, 0)));
        this.defect.set(0, 0, -def.x);
        this.defect.set(1, 0, -def.y);
        this.dx = deriviation.solve(this.defect);
        this.x = this.x.plus(this.dx);
        Matrix x_lambda = this.x.plus(this.dx.times(lambda));
        Matrix deltax_lambda = null;
        def = this.function.getDerivate1(new Punkt2D(x_lambda.get(0, 0), x_lambda.get(1, 0)));
        this.defect.set(0, 0, -def.x);
        this.defect.set(1, 0, -def.y);
        deltax_lambda = deriviation.solve(this.defect);
        double g_lambda = deltax_lambda.norm2();
        double g_0 = this.dx.norm2();
        if (g_lambda > g_0) {
            while (g_lambda > g_0) {
                x_lambda = this.x.plus(this.dx.times(lambda /= 2.0));
                def = this.function.getDerivate1(new Punkt2D(x_lambda.get(0, 0), x_lambda.get(1, 0)));
                this.defect.set(0, 0, -def.x);
                this.defect.set(1, 0, -def.y);
                deltax_lambda = deriviation.solve(this.defect);
                g_lambda = deltax_lambda.norm2();
                if (!(lambda < 1.0E-5)) continue;
                throw new ComputationException(Messages.getString(BUNDLE_NAME, "Verfahren.13"));
            }
        } else if (lambda < 1.0) {
            while (g_lambda < g_0 && lambda <= 2.0) {
                g_0 = g_lambda;
                x_lambda = this.x.plus(this.dx.times(lambda *= 2.0));
                def = this.function.getDerivate1(new Punkt2D(x_lambda.get(0, 0), x_lambda.get(1, 0)));
                this.defect.set(0, 0, -def.x);
                this.defect.set(1, 0, -def.y);
                deltax_lambda = deriviation.solve(this.defect);
                g_lambda = deltax_lambda.norm2();
            }
            lambda = Math.min(1.0, lambda / 2.0);
        }
        this.x = this.x.plus(this.dx.times(lambda));
        if (Double.isNaN(this.x.normF()) || Double.isInfinite(this.x.normF())) {
            throw new ComputationException(Messages.getString(BUNDLE_NAME, "NewtonMethod.4"));
        }
        return this.x;
    }

    public void setType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException(Messages.getString(BUNDLE_NAME, "NewtonMethod.5"));
        }
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public double getError() {
        return this.dx.normF();
    }
}

