/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math;

import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.ComputationException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.functions.Function1D;
import uibk.mtk.math.functions.ParsedFunction2D;

public class NewtonMethod {
    double x;
    double[] coord = new double[2];
    Function1D function;
    ParsedFunction2D function2D;
    int type;
    public static final int TYPE_STANDARD = 0;
    public static final int TYPE_SIMPLE = 1;
    double x0;
    double dx;
    double defect;
    static final String BUNDLE_NAME = "uibk.mtk.math.messages";

    public NewtonMethod(Function1D function) {
        this.setFunction(function);
    }

    public void setFunction(Function1D function) {
        this.function = function;
    }

    public NewtonMethod(ParsedFunction2D function) {
        this.setFunction2D(function);
    }

    public void setFunction2D(ParsedFunction2D function) {
        this.function2D = function;
    }

    public NewtonMethod() {
    }

    public double getX() {
        return this.x;
    }

    public double getIncrement() {
        return Math.abs(this.dx);
    }

    public double getDefect() {
        return Math.abs(this.defect);
    }

    public void setX0(double x) {
        this.x = x;
    }

    public void setJacobiPostion(double x0) {
        this.x0 = x0;
    }

    public double nextApproximation() throws ComputationException {
        double deriv;
        if (this.function == null) {
            throw new ComputationException(Messages.getString(BUNDLE_NAME, "NewtonMethod.0"));
        }
        try {
            double tempx = this.type == 1 ? this.x0 : this.x;
            deriv = this.function.getDerivation(tempx);
        }
        catch (Exception ex) {
            throw new ComputationException(ex.getMessage());
        }
        if (deriv == 0.0) {
            throw new ComputationException("f'(" + this.x + Messages.getString(BUNDLE_NAME, "NewtonMethod.2"));
        }
        if (Double.isNaN(deriv) || Double.isInfinite(deriv)) {
            throw new ComputationException(Messages.getString(BUNDLE_NAME, "NewtonMethod.3"));
        }
        this.defect = this.function.getValue(this.x);
        this.dx = -this.defect / deriv;
        this.x += this.dx;
        if (Double.isNaN(this.x) || Double.isInfinite(this.x)) {
            throw new ComputationException(Messages.getString(BUNDLE_NAME, "NewtonMethod.4"));
        }
        return this.x;
    }

    public double nextApproximation(double valuevar, int var) throws ComputationException {
        double deriv;
        if (this.function2D == null) {
            throw new ComputationException(Messages.getString(BUNDLE_NAME, "NewtonMethod.0"));
        }
        try {
            Punkt2D tempx = new Punkt2D();
            if (var == 1) {
                tempx.x = var;
                tempx.y = this.type == 1 ? this.x0 : this.x;
                this.coord[0] = var;
                this.coord[1] = this.x;
                deriv = this.function2D.getDerivate2((Punkt2D)tempx)[1].y;
            } else {
                tempx.y = var;
                tempx.x = this.type == 1 ? this.x0 : this.x;
                this.coord[1] = var;
                this.coord[0] = this.x;
                deriv = this.function2D.getDerivate2((Punkt2D)tempx)[0].x;
            }
        }
        catch (Exception ex) {
            throw new ComputationException(ex.getMessage());
        }
        if (deriv == 0.0) {
            throw new ComputationException("f'(" + this.x + Messages.getString(BUNDLE_NAME, "NewtonMethod.2"));
        }
        if (Double.isNaN(deriv) || Double.isInfinite(deriv)) {
            throw new ComputationException(Messages.getString(BUNDLE_NAME, "NewtonMethod.3"));
        }
        this.defect = var == 1 ? this.function2D.getDerivate1((Punkt2D)new Punkt2D((double)this.coord[0], (double)this.coord[1])).y : this.function2D.getDerivate1((Punkt2D)new Punkt2D((double)this.coord[0], (double)this.coord[1])).x;
        this.dx = -this.defect / deriv;
        this.x += this.dx;
        if (Double.isNaN(this.x) || Double.isInfinite(this.x)) {
            throw new ComputationException(Messages.getString(BUNDLE_NAME, "NewtonMethod.4"));
        }
        return this.x;
    }

    public void setType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException(Messages.getString(BUNDLE_NAME, "NewtonMethod.5"));
        }
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public double getError() {
        return Math.abs(this.dx);
    }
}

