/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.rasterizer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import uibk.mtk.draw3d.objects.surface3d.Triangle;
import uibk.mtk.draw3d.objects.surface3d.Vertex3D;
import uibk.mtk.draw3d.rasterizer.Farbe;

public class Rasterizer {
    BufferedImage framebuffer;
    double[][] zbuffer;
    Graphics2D g2;
    public static final int FLAT = 0;
    public static final int GOUROUD = 1;
    int shadingmode = 1;
    int colorint;
    Color color;
    private int linewidth = 1;
    int renderhint = 1;
    public static final int RENDER_HINT_SPEED = 0;
    public static final int RENDER_HINT_QUALITY = 1;
    private boolean usezbuffer = false;
    private int scanline;
    private double xleft;
    private double xright;
    private Farbe colorleft = new Farbe();
    private Farbe colorright = new Farbe();
    private Farbe currentcolor = new Farbe();
    private Farbe dcolorL = new Farbe();
    private Farbe dcolorR = new Farbe();
    private double depthR;
    private double depthL;
    int a;
    int b;
    Farbe colorL;
    Farbe colorR;
    double dD;
    double depth;
    double ddepthR;
    double ddepthL;
    private Point top = new Point();
    private Point middle = new Point();
    private Point bottom = new Point();
    private Farbe colortop;
    private Farbe colormiddle;
    private Farbe colorbottom;
    private double depthtop;
    private double depthmiddle;
    private double depthbottom;

    public void setShadingMode(int mode) {
        this.shadingmode = mode;
    }

    public int getShadingMode() {
        return this.shadingmode;
    }

    public void setColor(Color c) {
        this.color = c;
        this.colorint = this.color.getRGB();
    }

    public void setRenderingHint(int hint) {
        if (hint > 1 || hint < 0) {
            throw new IllegalArgumentException("rendering hint not specified");
        }
        this.renderhint = hint;
    }

    public int getRenderingHint() {
        return this.renderhint;
    }

    public void setBuffers(BufferedImage framebuffer, Graphics2D g2, double[][] zbuffer) {
        this.zbuffer = zbuffer;
        this.framebuffer = framebuffer;
        this.g2 = g2;
    }

    public void enableZBuffer(boolean enable) {
        this.usezbuffer = enable;
    }

    private void sortEdges(Triangle triangle) {
        Farbe tempC;
        double tempdepth;
        Point temp;
        this.top.x = triangle.p1.dc.x;
        this.top.y = triangle.p1.dc.y;
        this.middle.x = triangle.p2.dc.x;
        this.middle.y = triangle.p2.dc.y;
        this.bottom.x = triangle.p3.dc.x;
        this.bottom.y = triangle.p3.dc.y;
        this.colortop = new Farbe(triangle.p1.color);
        this.colormiddle = new Farbe(triangle.p2.color);
        this.colorbottom = new Farbe(triangle.p3.color);
        this.depthtop = triangle.p1.distance;
        this.depthmiddle = triangle.p2.distance;
        this.depthbottom = triangle.p3.distance;
        if (this.top.y > this.middle.y) {
            temp = this.middle;
            this.middle = this.top;
            this.top = temp;
            tempdepth = this.depthmiddle;
            this.depthmiddle = this.depthtop;
            this.depthtop = tempdepth;
            tempC = this.colormiddle;
            this.colormiddle = this.colortop;
            this.colortop = tempC;
        }
        if (this.middle.y > this.bottom.y) {
            temp = this.middle;
            this.middle = this.bottom;
            this.bottom = temp;
            tempdepth = this.depthmiddle;
            this.depthmiddle = this.depthbottom;
            this.depthbottom = tempdepth;
            tempC = this.colormiddle;
            this.colormiddle = this.colorbottom;
            this.colorbottom = tempC;
        }
        if (this.top.y > this.middle.y) {
            temp = this.middle;
            this.middle = this.top;
            this.top = temp;
            tempdepth = this.depthmiddle;
            this.depthmiddle = this.depthtop;
            this.depthtop = tempdepth;
            tempC = this.colormiddle;
            this.colormiddle = this.colortop;
            this.colortop = tempC;
        }
    }

    public void renderTriangle(Triangle tri) {
        double dxR;
        double dxL;
        this.sortEdges(tri);
        int n = this.scanline = this.top.y >= 0 ? this.top.y : 0;
        if (this.top.y == this.middle.y && this.bottom.y == this.top.y) {
            this.xleft = Math.min(Math.min(this.top.x, this.middle.x), this.bottom.x);
            this.xright = Math.max(Math.max(this.top.x, this.middle.x), this.bottom.x);
            if (this.xleft == (double)this.top.x) {
                this.colorleft.set(this.colortop);
                this.depthL = this.depthtop;
            }
            if (this.xleft == (double)this.bottom.x) {
                this.colorleft.set(this.colorbottom);
                this.depthL = this.depthbottom;
            }
            if (this.xleft == (double)this.middle.x) {
                this.colorleft.set(this.colormiddle);
                this.depthL = this.depthmiddle;
            }
            if (this.xright == (double)this.top.x) {
                this.colorright.set(this.colortop);
                this.depthR = this.depthtop;
            }
            if (this.xright == (double)this.bottom.x) {
                this.colorright.set(this.colorbottom);
                this.depthR = this.depthbottom;
            }
            if (this.xright == (double)this.middle.x) {
                this.colorright.set(this.colormiddle);
                this.depthR = this.depthmiddle;
            }
            this.renderline();
            return;
        }
        if (this.middle.y != this.top.y) {
            dxL = (double)(this.middle.x - this.top.x) / (double)(this.middle.y - this.top.y);
            dxR = (double)(this.bottom.x - this.top.x) / (double)(this.bottom.y - this.top.y);
            this.dcolorL = this.colormiddle.sub(this.colortop);
            this.dcolorL.scaleself((float)(1.0 / (double)(this.middle.y - this.top.y)));
            this.dcolorR = this.colorbottom.sub(this.colortop);
            this.dcolorR.scaleself((float)(1.0 / (double)(this.bottom.y - this.top.y)));
            this.xleft = this.top.x;
            this.xright = this.top.x;
            this.colorright.set(this.colortop);
            this.colorleft.set(this.colortop);
            this.depthR = this.depthtop;
            this.depthL = this.depthtop;
            this.ddepthL = (this.depthmiddle - this.depthtop) / (double)(this.middle.y - this.top.y);
            this.ddepthR = (this.depthbottom - this.depthtop) / (double)(this.bottom.y - this.top.y);
            while (this.scanline <= this.middle.y) {
                this.renderline();
                this.xleft += dxL;
                this.xright += dxR;
                this.colorright.addself(this.dcolorR);
                this.colorleft.addself(this.dcolorL);
                this.depthR += this.ddepthR;
                this.depthL += this.ddepthL;
                ++this.scanline;
            }
        }
        if (this.middle.y != this.bottom.y) {
            this.scanline = this.middle.y;
            dxL = (double)(this.middle.x - this.bottom.x) / (double)(this.middle.y - this.bottom.y);
            dxR = (double)(this.top.x - this.bottom.x) / (double)(this.top.y - this.bottom.y);
            this.dcolorL = this.colormiddle.sub(this.colorbottom);
            this.dcolorL.scaleself((float)(1.0 / (double)(this.middle.y - this.bottom.y)));
            this.dcolorR = this.colortop.sub(this.colorbottom);
            this.dcolorR.scaleself((float)(1.0 / (double)(this.top.y - this.bottom.y)));
            this.xleft = this.middle.x;
            this.xright = (double)this.bottom.x + (double)(this.scanline - this.bottom.y) * dxR;
            this.colorleft.set(this.colormiddle);
            this.colorright = Farbe.interpolate(this.top.y, this.bottom.y, this.colortop, this.colorbottom, this.scanline);
            this.ddepthL = (this.depthmiddle - this.depthbottom) / (double)(this.middle.y - this.bottom.y);
            this.ddepthR = (this.depthtop - this.depthbottom) / (double)(this.top.y - this.bottom.y);
            this.depthL = this.depthmiddle;
            this.depthR = this.depthbottom + (double)(this.scanline - this.bottom.y) * this.ddepthR;
            while (this.scanline <= this.bottom.y) {
                this.renderline();
                this.xleft += dxL;
                this.xright += dxR;
                this.colorright.addself(this.dcolorR);
                this.colorleft.addself(this.dcolorL);
                this.depthR += this.ddepthR;
                this.depthL += this.ddepthL;
                ++this.scanline;
            }
        }
    }

    private void renderline() {
        this.a = (int)this.xleft;
        this.b = (int)this.xright;
        if (this.scanline > this.framebuffer.getHeight() - 1 || this.scanline < 0) {
            return;
        }
        this.colorL = new Farbe(this.colorleft);
        this.colorR = new Farbe(this.colorright);
        if (this.a > this.b) {
            int temp = this.a;
            this.a = this.b;
            this.b = temp;
            double tempdepth = this.depthL;
            this.depthL = this.depthR;
            this.depthR = tempdepth;
            Farbe colortemp = this.colorL;
            this.colorL = this.colorR;
            this.colorR = colortemp;
        }
        if (this.a < 0) {
            this.a = 0;
        }
        if (this.b >= this.framebuffer.getWidth()) {
            this.b = this.framebuffer.getWidth() - 1;
        }
        this.dD = 0.0;
        this.depth = this.depthL;
        if (this.b - this.a != 0) {
            this.dD = (this.depthR - this.depthL) / (double)(this.b - this.a);
        }
        if (this.shadingmode == 0) {
            this.renderlineFlat();
        } else {
            this.renderlineGouroud();
        }
    }

    private void renderlineGouroud() {
        int x = this.a;
        this.currentcolor.set(this.colorL);
        Farbe dcolor = new Farbe(0.0f, 0.0f, 0.0f);
        if (this.b - this.a != 0) {
            dcolor.set(this.colorR.sub(this.colorL));
            dcolor.scaleself((float)(1.0 / (double)Math.abs(this.b - this.a)));
        }
        while (x <= this.b) {
            if (!this.usezbuffer || this.depth < this.zbuffer[x][this.scanline]) {
                if (this.depth < this.zbuffer[x][this.scanline]) {
                    this.zbuffer[x][this.scanline] = this.depth;
                }
                this.framebuffer.setRGB(x, this.scanline, this.currentcolor.toInteger());
            }
            this.depth += this.dD;
            this.currentcolor.addself(dcolor);
            ++x;
        }
    }

    private void renderlineFlat() {
        int x = this.a;
        while (x <= this.b) {
            if (!this.usezbuffer || this.depth < this.zbuffer[x][this.scanline]) {
                if (this.depth < this.zbuffer[x][this.scanline]) {
                    this.zbuffer[x][this.scanline] = this.depth;
                }
                this.framebuffer.setRGB(x, this.scanline, this.colorint);
            }
            ++x;
            this.depth += this.dD;
        }
    }

    private void plotline(int px, int py, int qx, int qy, double pdistance, double qdistance) {
        double depth = pdistance;
        double n = Math.sqrt((px - qx) * (px - qx) + (py - qy) * (py - qy)) + 1.0;
        double dd = (qdistance - pdistance) / n;
        int width = this.framebuffer.getWidth();
        int height = this.framebuffer.getHeight();
        int dx = qx - px;
        int dy = qy - py;
        int incx = dx > 0 ? 1 : -1;
        int incy = dy > 0 ? 1 : -1;
        if (Math.abs(dy) < Math.abs(dx)) {
            int error = -Math.abs(dx);
            int delta = 2 * Math.abs(dy);
            int schwelle = 2 * error;
            while (px != qx) {
                if (px >= 0 && px < width && py >= 0 && py < height) {
                    depth += dd;
                    if (!this.usezbuffer || depth < this.zbuffer[px][py]) {
                        this.setPixel(px, py);
                    }
                }
                px += incx;
                if ((error += delta) <= 0) continue;
                py += incy;
                error += schwelle;
            }
        } else {
            int error = -Math.abs(dy);
            int delta = 2 * Math.abs(dx);
            int schwelle = 2 * error;
            while (py != qy) {
                depth += dd;
                if (px >= 0 && px < width && py >= 0 && py < height && (!this.usezbuffer || depth < this.zbuffer[px][py])) {
                    this.setPixel(px, py);
                }
                py += incy;
                if ((error += delta) <= 0) continue;
                px += incx;
                error += schwelle;
            }
        }
    }

    public void setLineWidth(int w) {
        this.linewidth = w;
    }

    public int getLineWidth() {
        return this.linewidth;
    }

    public void drawline(int px, int py, int qx, int qy, double pdepth, double qdepth) {
        Vertex3D p = new Vertex3D();
        Vertex3D q = new Vertex3D();
        p.dc = new Point(px, py);
        q.dc = new Point(qx, qy);
        p.distance = pdepth;
        q.distance = qdepth;
        this.drawline(p, q);
    }

    public void drawline(Vertex3D p, Vertex3D q) {
        int px = p.dc.x;
        int py = p.dc.y;
        int qx = q.dc.x;
        int qy = q.dc.y;
        double pdistance = p.distance;
        double qdistance = q.distance;
        this.g2.setColor(this.color);
        Stroke oldstroke = this.g2.getStroke();
        this.g2.setStroke(new BasicStroke(this.linewidth));
        switch (this.renderhint) {
            case 0: {
                this.plotline(px, py, qx, qy, pdistance, qdistance);
                break;
            }
            case 1: {
                if (this.usezbuffer) {
                    this.plotline(px, py, qx, qy, pdistance, qdistance);
                    break;
                }
                this.g2.setColor(this.color);
                this.g2.drawLine(px, py, qx, qy);
                break;
            }
        }
        this.g2.setStroke(oldstroke);
    }

    private void setPixel(int x, int y) {
        if (this.renderhint == 0) {
            this.framebuffer.setRGB(x, y, this.colorint);
        } else {
            this.g2.drawLine(x, y, x, y);
        }
    }
}

