/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.rasterizer;

import java.awt.Color;

public final class Farbe {
    float r;
    float g;
    float b;
    public static final Farbe BLACK = new Farbe(0.0f, 0.0f, 0.0f);
    public static final Farbe WHITE = new Farbe(255.0f, 255.0f, 255.0f);

    public Farbe(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public Farbe() {
    }

    public Farbe(Farbe f) {
        this.r = f.r;
        this.g = f.g;
        this.b = f.b;
    }

    public Farbe(Color color) {
        this.r = color.getRed();
        this.g = color.getGreen();
        this.b = color.getBlue();
    }

    public void addself(Farbe c) {
        this.r += c.r;
        this.g += c.g;
        this.b += c.b;
    }

    public void subself(Farbe c) {
        this.r -= c.r;
        this.g -= c.g;
        this.b -= c.b;
    }

    public String toString() {
        return "(" + this.r + "," + this.g + "," + this.b + ")";
    }

    public Farbe scale(float s) {
        float nr = s * this.r;
        float ng = s * this.g;
        float nb = s * this.b;
        return new Farbe(nr, ng, nb);
    }

    public Farbe add(Farbe f) {
        return new Farbe(f.r + this.r, f.g + this.g, f.b + this.b);
    }

    public Farbe sub(Farbe f) {
        return new Farbe(this.r - f.r, this.g - f.g, this.b - f.b);
    }

    public void scaleself(float s) {
        this.r = s * this.r;
        this.g = s * this.g;
        this.b = s * this.b;
    }

    public void set(Farbe c) {
        this.r = c.r;
        this.g = c.g;
        this.b = c.b;
    }

    public void set(Color c) {
        this.r = c.getRed();
        this.g = c.getGreen();
        this.b = c.getBlue();
    }

    public static Farbe interpolate(float a, float b, Farbe colora, Farbe colorb, double x) {
        if (b - a == 0.0f) {
            return colora;
        }
        float k = (float)((double)b - x) / (b - a);
        float l = (float)(x - (double)a) / (b - a);
        return colora.scale(k).add(colorb.scale(l));
    }

    public int toInteger() {
        return (int)this.b + ((int)this.g << 8) + ((int)this.r << 16);
    }

    public Color toColor() {
        return new Color((int)this.r, (int)this.g, (int)this.b);
    }
}

