/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.axescube3d;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.mtk.draw3d.axescube3d.Tick;
import uibk.mtk.draw3d.objects.Cube3D;
import uibk.mtk.draw3d.objects.Polyeder3D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.geom.geom2d.Vector2D;
import uibk.mtk.geom.geom3d.Punkt3D;
import uibk.mtk.geom.geom3d.Vector3D;
import uibk.mtk.lang.PrepaintComputable;
import uibk.mtk.text.Formatter;

public class AxesCube3D
extends Cube3D
implements PrepaintComputable {
    String labelx = "";
    String labely = "";
    String labelz = "";
    int labelSize = 0;
    Formatter formatter = new Formatter();
    Punkt2D labelposx;
    Punkt2D labelposy;
    Punkt2D labelposz;
    Vector labelarea = new Vector();
    int[] edgesx;
    int[] edgesy;
    int[] edgesz;
    static final int BIGTICKLENGTH = 8;
    static final int SMALLTICKLENGTH = 4;
    static final int GAPTOLABEL = 5;
    static final int NOEDGEVISIBLE = -1;
    int edgex;
    int edgey;
    int edgez;
    static final int[] F = new int[]{5, 2, 3, 4, 5, 2, 3, 4, 3, 2, 2, 3};
    boolean labelsenabled;
    Vector ticksx;
    Vector ticksy;
    Vector ticksz;
    static final byte LEFT = 1;
    static final byte RIGHT = 2;
    static final byte BOTTOM = 4;
    static final byte TOP = 8;

    public AxesCube3D() {
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 6;
        this.edgesx = nArray;
        this.edgesy = new int[]{1, 3, 5, 7};
        this.edgesz = new int[]{8, 9, 10, 11};
        this.labelsenabled = true;
        this.ticksx = new Vector();
        this.ticksy = new Vector();
        this.ticksz = new Vector();
    }

    void drawlabels(int edge, String label, Graphics2D g2) {
        if (edge == -1 || label == null || label.equals("")) {
            return;
        }
        Punkt3D p1 = this.mc_vertices[this.edges[edge].p1];
        Punkt3D p2 = this.mc_vertices[this.edges[edge].p2];
        Punkt3D center = p1.add(p2);
        center.scaleself(0.5);
        Punkt2D pos = this.scene3d.project(center);
        Vector2D dir = this.scene3d.projectVector(center, this.getTickDirection(edge));
        Punkt2D labelpos = pos.add(dir);
        g2.drawString(label, (int)(labelpos.x + dir.x * 45.0), (int)(labelpos.y + dir.y * 45.0));
    }

    public void enableLabels(boolean enable) {
        this.labelsenabled = enable;
    }

    public boolean isLabelingEnabled() {
        return this.labelsenabled;
    }

    private void getEgdes() {
        this.edgex = -1;
        this.edgey = -1;
        this.edgez = -1;
        int i = 0;
        while (i < this.edgesx.length) {
            if (!this.edges[this.edgesx[i]].hidden) {
                this.edgex = this.edgesx[i];
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.edgesy.length) {
            if (!this.edges[this.edgesy[i]].hidden) {
                this.edgey = this.edgesy[i];
                break;
            }
            ++i;
        }
        i = this.edgesz.length - 1;
        while (i >= 0) {
            if (!this.edges[this.edgesz[i]].hidden) {
                this.edgez = this.edgesz[i];
                break;
            }
            --i;
        }
    }

    private boolean cliplabels() {
        int i = 0;
        while (i < this.wc_vertices.length) {
            if (this.wc_vertices[i].x2 > this.scene3d.getClippingPlane()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        super.draw(framebuffer, g2);
        if (this.cliplabels()) {
            return;
        }
        g2.setColor(this.color);
        this.drawlabel(this.labelx, this.labelposx, g2);
        this.drawlabel(this.labely, this.labelposy, g2);
        this.drawlabel(this.labelz, this.labelposz, g2);
        if (this.labelsenabled) {
            Tick t;
            int j = 0;
            while (j < this.ticksx.size()) {
                t = (Tick)this.ticksx.elementAt(j);
                t.draw(g2);
                ++j;
            }
            j = 0;
            while (j < this.ticksy.size()) {
                t = (Tick)this.ticksy.elementAt(j);
                t.draw(g2);
                ++j;
            }
            j = 0;
            while (j < this.ticksz.size()) {
                t = (Tick)this.ticksz.elementAt(j);
                t.draw(g2);
                ++j;
            }
        }
    }

    void drawlabel(String label, Punkt2D pos, Graphics2D g2) {
        if (!this.labelsenabled || label == null || label.equals("") || pos == null) {
            return;
        }
        Font oldFont = g2.getFont();
        if (this.labelSize > 0) {
            g2.setFont(new Font(oldFont.getName(), oldFont.getStyle(), this.labelSize));
        }
        g2.drawString(label, (int)pos.x, (int)pos.y);
        g2.setFont(oldFont);
    }

    Vector getTickPositions(double min, double max, int numticks) {
        Vector<Double> tickPos = new Vector<Double>();
        if (numticks <= 0) {
            return tickPos;
        }
        if (min > max) {
            double t = max;
            max = min;
            min = t;
        }
        tickPos.add(new Double(min));
        double step = Math.abs(max - min) / (double)numticks;
        double pos = min + step;
        int i = 1;
        while (pos < max) {
            tickPos.add(new Double(pos));
            pos = min + step * (double)(++i);
        }
        tickPos.add(new Double(max));
        return tickPos;
    }

    private void createTicksX() {
        if (this.edgex == -1) {
            return;
        }
        Polyeder3D.Edge e = this.edges[this.edgex];
        double roundingdiff = this.scene3d.getBoundingBox().getXRange() / 500.0;
        Vector tickposx = this.getTickPositions(this.mc_vertices[e.p1].x1, this.mc_vertices[e.p2].x1, this.resonableTickNum(this.edgex));
        int i = 0;
        while (i < tickposx.size()) {
            double pos = (Double)tickposx.elementAt(i);
            Punkt3D p = new Punkt3D(this.mc_vertices[e.p1]);
            p.x1 = pos;
            Vector3D dir = this.getTickDirection(this.edgex);
            boolean bigtick = i % 5 == 0;
            String label = bigtick ? this.formatter.format(pos, roundingdiff) : "";
            Tick t = new Tick(this, p, dir, bigtick, label);
            t.compute((Graphics2D)this.panel.getGraphics(), this.scene3d);
            this.ticksx.add(t);
            ++i;
        }
    }

    private void createTicksY() {
        if (this.edgey == -1) {
            return;
        }
        Polyeder3D.Edge e = this.edges[this.edgey];
        double roundingdiff = this.scene3d.getBoundingBox().getYRange() / 500.0;
        Vector tickposy = this.getTickPositions(this.mc_vertices[e.p1].x2, this.mc_vertices[e.p2].x2, this.resonableTickNum(this.edgey));
        int i = 0;
        while (i < tickposy.size()) {
            double pos = (Double)tickposy.elementAt(i);
            Punkt3D p = new Punkt3D(this.mc_vertices[e.p1]);
            p.x2 = pos;
            Vector3D n = this.getTickDirection(this.edgey);
            boolean bigtick = i % 5 == 0;
            String label = bigtick ? this.formatter.format(pos, roundingdiff) : "";
            Tick t = new Tick(this, p, n, bigtick, label);
            t.compute((Graphics2D)this.panel.getGraphics(), this.scene3d);
            this.ticksy.add(t);
            ++i;
        }
    }

    private void createTicksZ() {
        if (this.edgez == -1) {
            return;
        }
        Polyeder3D.Edge e = this.edges[this.edgez];
        double roundingdiff = this.scene3d.getBoundingBox().getYRange() / 500.0;
        Vector tickposz = this.getTickPositions(this.mc_vertices[e.p1].x3, this.mc_vertices[e.p2].x3, this.resonableTickNum(this.edgez));
        int i = 0;
        while (i < tickposz.size()) {
            double pos = (Double)tickposz.elementAt(i);
            Punkt3D p = new Punkt3D(this.mc_vertices[e.p1]);
            p.x3 = pos;
            Vector3D n = this.getTickDirection(this.edgez);
            boolean bigtick = i % 5 == 0;
            String label = bigtick ? this.formatter.format(pos, roundingdiff) : "";
            Tick t = new Tick(this, p, n, bigtick, label);
            t.compute((Graphics2D)this.panel.getGraphics(), this.scene3d);
            this.ticksz.add(t);
            ++i;
        }
    }

    private double getAngle(int edge) {
        Polyeder3D.Face f = this.faces[F[edge]];
        Vector3D normalwc = f.getSurfaceNormalWC();
        Polyeder3D.Edge e = this.edges[edge];
        Punkt3D cam = this.scene3d.getCamera();
        Punkt3D center = this.wc_vertices[e.p1].add(this.wc_vertices[e.p2]);
        center.scaleself(0.5);
        Punkt3D dir = cam.sub(center);
        double angle = Math.acos(dir.dotProd(normalwc) / (dir.norm() * normalwc.norm()));
        angle = angle / (Math.PI * 2) * 360.0;
        return angle;
    }

    private Vector3D getTickDirection(int edge) {
        Polyeder3D.Face f = this.faces[F[edge]];
        double angle = this.getAngle(edge);
        Vector3D tickdirection = null;
        if (angle < 30.0 || angle > 150.0) {
            int i = 0;
            while (i < this.faces.length) {
                if (this.faces[i].containsEdge(this.edges[edge]) && this.faces[i] != f) {
                    tickdirection = this.faces[i].getSurfaceNormalMC();
                    break;
                }
                ++i;
            }
        } else {
            tickdirection = f.getSurfaceNormalMC();
        }
        return tickdirection;
    }

    public void prepaintcompute() {
        super.pointsfromCoordinateCube(this.scene3d.getBoundingBox());
        super.prepaintcompute();
        if (!this.labelsenabled) {
            return;
        }
        this.ticksx.clear();
        this.ticksy.clear();
        this.ticksz.clear();
        this.labelarea.clear();
        this.getEgdes();
        this.labelposx = this.computelabel(this.edgex, this.labelx);
        this.labelposy = this.computelabel(this.edgey, this.labely);
        this.labelposz = this.computelabel(this.edgez, this.labelz);
        this.createTicksX();
        this.createTicksY();
        this.createTicksZ();
    }

    private int resonableTickNum(int edge) {
        Punkt2D p2;
        Polyeder3D.Edge e = this.edges[edge];
        Punkt3D v1 = this.mc_vertices[e.p1];
        Punkt3D v2 = this.mc_vertices[e.p2];
        Punkt2D p1 = this.scene3d.project(v1);
        double length = p1.sub(p2 = this.scene3d.project(v2)).norm();
        if (length < 40.0) {
            return 0;
        }
        int n = (int)(length / 30.0);
        int a = n % 5;
        if (a != 0) {
            n += 5 - a;
        }
        return n;
    }

    static byte getDirection(Vector2D dir) {
        byte code = 0;
        if (dir.x > 0.0) {
            code = 2;
        }
        if (dir.x < 0.0) {
            code = 1;
        }
        if (dir.y > 0.0) {
            code = (byte)(code | 8);
        }
        if (dir.y < 0.0) {
            code = (byte)(code | 4);
        }
        return code;
    }

    Punkt2D computelabel(int edge, String label) {
        if (edge == -1 || label == null || label.equals("")) {
            return null;
        }
        Punkt3D p1 = this.mc_vertices[this.edges[edge].p1];
        Punkt3D p2 = this.mc_vertices[this.edges[edge].p2];
        Punkt3D center = p1.add(p2);
        center.scaleself(0.5);
        Punkt2D pos = this.scene3d.project(center);
        Vector2D dir = this.scene3d.projectVector(center, this.getTickDirection(edge));
        Punkt2D labelpos = pos.add(dir.scale(40.0));
        Graphics2D g2 = (Graphics2D)this.panel.getGraphics();
        FontMetrics metrics = g2.getFontMetrics();
        int height = metrics.getAscent();
        int length = metrics.stringWidth(label);
        Rectangle r = new Rectangle((int)labelpos.x, (int)labelpos.y - height, length, height);
        this.labelarea.add(r);
        return labelpos;
    }

    public void setLabelX(String label) {
        this.labelx = label;
    }

    public void setLabelY(String label) {
        this.labely = label;
    }

    public void setLabelZ(String label) {
        this.labelz = label;
    }

    public void setLabels(String lx, String ly, String lz) {
        this.labelx = lx;
        this.labely = ly;
        this.labelz = lz;
    }

    public String getLabelz() {
        return this.labelz;
    }

    public void setLabelz(String labelz) {
        this.labelz = labelz;
    }

    public void setLabelSize(int labelSize) {
        if (labelSize > 0) {
            this.labelSize = labelSize;
        }
    }
}

