/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.objects.DragablePoint2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.Clickable;
import uibk.mtk.lang.Dragable;
import uibk.mtk.lang.PrepaintComputable;
import uibk.mtk.math.Interval;
import uibk.mtk.util.IntervalIterator;

public class RiemannSum2d
extends Drawable2D
implements PrepaintComputable,
Dragable,
Clickable {
    private Color edgecolor = Color.BLACK;
    private Color linescolor = Color.BLACK;
    private Color pointcolor = Color.BLUE;
    private Color shapecolor = Color.BLACK;
    boolean axes;
    boolean random = false;
    int pointradius = 3;
    double sum;
    Dragable dragged = null;
    Vector shapes = new Vector();
    Interval interval = new Interval(0.0, 1.0);
    Interval intervalimag = new Interval(0.0, 1.0);
    Graph2D graph = new Graph2D();
    int numpointsgraph = 400;
    Vector points = new Vector();
    int n = 10;
    boolean negative_samecolor = true;
    Vector lines = new Vector();

    public RiemannSum2d() {
        this.graph.setColor(Color.blue);
        this.setColor(this.shapecolor);
    }

    public boolean isDragEnabled() {
        return true;
    }

    private void leftandright() {
        int k = this.points.size();
        if (k == 0) {
            return;
        }
        int i = 0;
        while (i < k) {
            IntervalPoint p = (IntervalPoint)this.points.elementAt(i);
            if (i < k - 1) {
                p.right = (IntervalPoint)this.points.elementAt(i + 1);
            }
            if (i > 0) {
                p.left = (IntervalPoint)this.points.elementAt(i - 1);
            }
            ++i;
        }
        IntervalPoint p = (IntervalPoint)this.points.elementAt(k - 1);
        p.right = null;
    }

    private void addNewIntervallPointX(double x) {
        double min = ((IntervalPoint)this.points.elementAt(0)).getX();
        double max = ((IntervalPoint)this.points.elementAt(this.points.size() - 1)).getX();
        if (x < min) {
            return;
        }
        if (x > max) {
            return;
        }
        ListIterator it = this.points.listIterator();
        MathPoint2D left = null;
        int i = 0;
        while (it.hasNext()) {
            IntervalPoint p = (IntervalPoint)it.next();
            if (left != null && x > left.getX() && x < p.getX()) {
                IntervalPoint newpoint = this.createpoint(x);
                this.points.add(i, newpoint);
                return;
            }
            ++i;
            left = p;
        }
    }

    private void addNewIntervallPointY(double x) {
        double min = ((IntervalPoint)this.points.elementAt(0)).getY();
        double max = ((IntervalPoint)this.points.elementAt(this.points.size() - 1)).getY();
        if (x < min) {
            return;
        }
        if (x > max) {
            return;
        }
        ListIterator it = this.points.listIterator();
        MathPoint2D left = null;
        int i = 0;
        while (it.hasNext()) {
            IntervalPoint p = (IntervalPoint)it.next();
            if (left != null && x > left.getY() && x < p.getY()) {
                IntervalPoint newpoint = this.createpoint(x);
                this.points.add(i, newpoint);
                return;
            }
            ++i;
            left = p;
        }
    }

    public boolean clickcontains(int x, int y) {
        double xx = this.scene2d.pixelToX(x);
        double yy = this.scene2d.pixelToY(y);
        if (this.axes) {
            if (xx < this.interval.a || xx > this.interval.b) {
                return false;
            }
            if (yy < this.intervalimag.a || yy > this.intervalimag.b) {
                return false;
            }
        } else {
            if (yy < this.interval.a || yy > this.interval.b) {
                return false;
            }
            if (xx < this.intervalimag.a || xx > this.intervalimag.b) {
                return false;
            }
        }
        return true;
    }

    public void click(MouseEvent ev) {
        double x = this.scene2d.pixelToX(ev.getX());
        double y = this.scene2d.pixelToY(ev.getY());
        if (this.onlyRightButton(ev)) {
            if (this.axes) {
                if (y < this.interval.a + this.intervalimag.getLength() / 30.0 && y > this.interval.a - this.intervalimag.getLength() / 30.0) {
                    this.addNewIntervallPointX(x);
                }
            } else if (x < this.interval.a + this.intervalimag.getLength() / 30.0 && x > this.interval.a - this.intervalimag.getLength() / 30.0) {
                this.addNewIntervallPointY(y);
            }
        }
        if (this.onlyMiddleButton(ev)) {
            if (this.points.size() < 2) {
                return;
            }
            ListIterator it = this.points.listIterator();
            int i = 0;
            while (it.hasNext()) {
                IntervalPoint p = (IntervalPoint)it.next();
                if (p.dragcontains(ev.getX(), ev.getY())) {
                    this.points.remove(i);
                    break;
                }
                ++i;
            }
        }
        this.leftandright();
        this.panel.repaint();
    }

    private boolean onlyLeftButton(MouseEvent ev) {
        return ev.getModifiers() == 16;
    }

    private boolean onlyRightButton(MouseEvent ev) {
        return ev.getModifiers() == 4;
    }

    private boolean onlyMiddleButton(MouseEvent ev) {
        return ev.getModifiers() == 8;
    }

    public boolean randomEnabled() {
        return this.random;
    }

    private double[] rand() {
        int k = this.n + 1;
        double xmin = this.interval.a;
        double xmax = this.interval.b;
        double delta = this.interval.getLength() / (double)this.n;
        double minlength = delta / 2.0;
        double maxlength = delta * 1.5;
        Double[] numbers = new Double[this.n];
        double summe = 0.0;
        int i = 0;
        while (i < this.n / 2) {
            double t = RiemannSum2d.rand(minlength, maxlength);
            numbers[i] = new Double(t);
            summe += t;
            ++i;
        }
        double dt = (this.interval.getLength() - summe) / (double)(this.n / 2 + 1);
        int i2 = this.n / 2;
        while (i2 < this.n) {
            numbers[i2] = new Double(dt);
            ++i2;
        }
        Collections.shuffle(Arrays.asList(numbers));
        double[] limits = new double[k];
        double pos = xmin;
        limits[0] = xmin;
        limits[k - 1] = xmax;
        int i3 = 1;
        while (i3 < k - 1) {
            limits[i3] = pos += numbers[i3].doubleValue();
            ++i3;
        }
        return limits;
    }

    private static double rand(double xmin, double xmax) {
        return xmin + Math.random() * (xmax - xmin);
    }

    public void randomSubDivisions(boolean b) {
        this.random = b;
    }

    public void drag(MouseEvent ev) {
        if (!this.onlyLeftButton(ev)) {
            return;
        }
        if (this.dragged == this.points.get(0)) {
            return;
        }
        if (this.dragged == this.points.get(this.points.size() - 1)) {
            return;
        }
        if (this.axes) {
            this.dragged.drag(ev);
        } else {
            this.dragged.drag(ev);
        }
    }

    public boolean dragcontains(int xm, int ym) {
        for (DragablePoint2D mathpoint : this.points) {
            if (!mathpoint.dragcontains(xm, ym)) continue;
            this.dragged = mathpoint;
            return true;
        }
        return false;
    }

    public void enabledrag(boolean enable) {
    }

    public void setIntervalimag(Interval inter) {
        this.intervalimag = (Interval)inter.clone();
    }

    public void setAxes(boolean is) {
        this.axes = is;
    }

    public void setInterval(Interval inter) {
        this.interval = (Interval)inter.clone();
    }

    public void setNumberSubDivisions(int size) {
        if (size != this.n) {
            this.n = size;
        }
    }

    private void createIntervalPointsX() {
        this.points.clear();
        if (this.random) {
            double[] limits = this.rand();
            int i = 0;
            while (i < limits.length) {
                IntervalPoint p = this.createpoint(limits[i]);
                this.points.add(p);
                ++i;
            }
        } else {
            IntervalIterator it = new IntervalIterator(this.interval, this.n + 1);
            while (it.hasNext()) {
                IntervalPoint p = this.createpoint(it.nextdouble());
                this.points.add(p);
            }
        }
        this.leftandright();
    }

    private void createIntervalPointsY() {
        this.points.clear();
        if (this.random) {
            double[] limits = this.rand();
            int i = 0;
            while (i < limits.length) {
                IntervalPoint p = this.createpoint(limits[i]);
                this.points.add(p);
                ++i;
            }
        } else {
            IntervalIterator it = new IntervalIterator(this.interval, this.n + 1);
            while (it.hasNext()) {
                IntervalPoint p = this.createpoint(it.nextdouble());
                this.points.add(p);
            }
        }
        this.leftandright();
    }

    IntervalPoint createpoint(double x) {
        IntervalPoint p = this.axes ? new IntervalPoint(x, this.intervalimag.a) : new IntervalPoint(this.intervalimag.a, x);
        p.setColor(this.pointcolor);
        p.setRadius(this.pointradius);
        p.setMathPanel2D(this.panel);
        return p;
    }

    public void setMathPanel2D(MathPanel2D panel) {
        super.setMathPanel2D(panel);
    }

    public void prepaintcompute() throws Exception {
        this.computeshapes();
    }

    private void computeshapes() {
        this.shapes.clear();
        this.lines.clear();
        int yPix0 = this.scene2d.yToPixel(this.intervalimag.a);
        int xPix0 = this.scene2d.xToPixel(this.intervalimag.a);
        IntervalPoint left = null;
        IntervalPoint right = null;
        Iterator it = this.points.iterator();
        while (it.hasNext()) {
            IntervalPoint p;
            right = p = (IntervalPoint)it.next();
            if (left != null) {
                MyPolygon poly;
                int yPixFMid;
                int xPixRight;
                int xPixLeft;
                double xr;
                double xl;
                if (this.axes) {
                    xl = left.getX();
                    xr = right.getX();
                    xPixLeft = this.scene2d.xToPixel(xl);
                    xPixRight = this.scene2d.xToPixel(xr);
                    yPixFMid = this.scene2d.yToPixel(this.intervalimag.b);
                    poly = new MyPolygon();
                    poly.addPoint(xPixLeft, yPix0);
                    poly.addPoint(xPixLeft, yPixFMid);
                    poly.addPoint(xPixRight, yPixFMid);
                    poly.addPoint(xPixRight, yPix0);
                    this.shapes.add(poly);
                } else {
                    xl = left.getY();
                    xr = right.getY();
                    xPixLeft = this.scene2d.yToPixel(xl);
                    xPixRight = this.scene2d.yToPixel(xr);
                    yPixFMid = this.scene2d.xToPixel(this.intervalimag.b);
                    poly = new MyPolygon();
                    poly.addPoint(xPix0, xPixLeft);
                    poly.addPoint(yPixFMid, xPixLeft);
                    poly.addPoint(yPixFMid, xPixRight);
                    poly.addPoint(xPix0, xPixRight);
                    this.shapes.add(poly);
                }
            }
            left = right;
        }
    }

    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        for (MyPolygon shape : this.shapes) {
            g2.setColor(this.edgecolor);
            g2.draw(shape);
        }
        Iterator it = this.lines.iterator();
        g2.setColor(this.linescolor);
        while (it.hasNext()) {
            g2.draw((Line2D.Double)it.next());
        }
        for (DragablePoint2D mathpoint : this.points) {
            mathpoint.draw(framebuffer, g2);
        }
    }

    public void create() throws Exception {
        if (this.axes) {
            this.createIntervalPointsX();
        } else {
            this.createIntervalPointsY();
        }
        this.computeshapes();
    }

    public int getNumberSubDivisions() {
        return this.n;
    }

    public Interval getInterval() {
        return (Interval)this.interval.clone();
    }

    public Punkt2D[] getPoints() {
        Punkt2D[] point = new Punkt2D[this.points.size()];
        int i = 0;
        while (i < point.length) {
            IntervalPoint p = (IntervalPoint)this.points.elementAt(i);
            point[i] = p.getPunkt2D();
            ++i;
        }
        return point;
    }

    public void enableSameColor(boolean b) {
        this.negative_samecolor = b;
    }

    public boolean isEnabledSameColor() {
        return this.negative_samecolor;
    }

    class IntervalPoint
    extends DragablePoint2D {
        IntervalPoint left;
        IntervalPoint right;

        public IntervalPoint(double x, double y) {
            super(x, y);
            this.left = null;
            this.right = null;
        }

        public void drag(MouseEvent ev) {
            if (RiemannSum2d.this.axes) {
                double t = this.scene2d.pixelToX(ev.getX());
                if (this.left == null && t < RiemannSum2d.this.interval.a) {
                    return;
                }
                if (this.right == null && t > RiemannSum2d.this.interval.b) {
                    return;
                }
                if (this.left != null && t <= this.left.x) {
                    return;
                }
                if (this.right != null && t >= this.right.x) {
                    return;
                }
                this.x = t;
            } else {
                double t = this.scene2d.pixelToY(ev.getY());
                if (this.left == null && t < RiemannSum2d.this.interval.a) {
                    return;
                }
                if (this.right == null && t > RiemannSum2d.this.interval.b) {
                    return;
                }
                if (this.left != null && t <= this.left.y) {
                    return;
                }
                if (this.right != null && t >= this.right.y) {
                    return;
                }
                this.y = t;
            }
        }
    }

    class MyPolygon
    extends Polygon {
        Color fillcolor;

        MyPolygon() {
        }
    }
}

