/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.base;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.geom.geom2d.CoordinateRect2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.math.Interval;

public class Scene2D {
    private int edge = 15;
    boolean ensurezerox = false;
    boolean ensurezeroy = false;
    double scalex = 1.0;
    double scaley = 1.0;
    boolean zoomforbidden = true;
    private Insets insets = new Insets(0, 0, 0, 0);
    private MathPanel2D mathpanel2d;
    private Insets requestedInsets = new Insets(0, 0, 0, 0);
    CoordinateRect2D limits = new CoordinateRect2D(-1.0, 1.0, -1.0, 1.0);
    CoordinateRect2D originallimits = new CoordinateRect2D(-1.0, 1.0, -1.0, 1.0);
    boolean equalize = false;
    boolean roundx = true;
    boolean roundy = true;
    double roundingpercent = 20.0;

    public double getScaleFactorX() {
        return this.scalex;
    }

    public double getScaleFactorY() {
        return this.scaley;
    }

    public void setScaleFactorX(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("");
        }
        if (scale >= 1.0 || scale < 1.0 && !this.zoomforbidden) {
            this.scalex = scale;
        }
    }

    public void setScaleFactorY(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("");
        }
        if (scale >= 1.0 || scale < 1.0 && !this.zoomforbidden) {
            this.scaley = scale;
        }
    }

    public void setEnlargeEnable(boolean b) {
        this.zoomforbidden = !b;
    }

    public Scene2D(MathPanel2D mathpanel2d) {
        this(mathpanel2d, new CoordinateRect2D());
    }

    public void reset() {
        this.setLimits(-1.0, 1.0, -1.0, 1.0);
    }

    public Rectangle getCoordinatePixelRectangle() {
        Rectangle rect = new Rectangle();
        rect.x = this.xToPixel(this.limits.xmin);
        rect.y = this.yToPixel(this.limits.ymax);
        rect.width = this.xToPixel(this.limits.xmax) - this.xToPixel(this.limits.xmin);
        rect.height = this.yToPixel(this.limits.ymin) - this.yToPixel(this.limits.ymax);
        return rect;
    }

    public Scene2D(MathPanel2D mathpanel, CoordinateRect2D rect) {
        this.mathpanel2d = mathpanel;
        this.setLimits(rect.xmin, rect.xmax, rect.ymin, rect.ymax);
    }

    boolean isScaleTooSmall() {
        return this.pixelToX(0) - this.pixelToX(1) == 0.0 || this.pixelToY(0) - this.pixelToY(1) == 0.0;
    }

    public void setXInterval(Interval interval) {
        this.setLimits(interval.a, interval.b, this.limits.ymin, this.limits.ymax);
    }

    public void setYInterval(Interval interval) {
        this.setLimits(this.limits.xmin, this.limits.xmax, interval.a, interval.b);
    }

    public void enableRoundX(boolean b) {
        this.roundx = b;
    }

    public void enableRound(boolean b) {
        this.roundx = b;
        this.roundy = b;
    }

    public void enableRoundY(boolean b) {
        this.roundy = b;
    }

    public boolean isEnabledRoundX() {
        return this.roundx;
    }

    public boolean isEnabledRoundY() {
        return this.roundy;
    }

    public void setRoundingPercent(double percent) {
        if (percent < 0.0) {
            throw new IllegalArgumentException();
        }
        this.roundingpercent = percent;
    }

    private void equalizeCoords() {
        int width = this.mathpanel2d.getWidth() - 2 * this.edge - this.insets.left - this.insets.right;
        int height = this.mathpanel2d.getHeight() - 2 * this.edge - this.insets.top - this.insets.bottom;
        double newxmin = this.limits.xmin;
        double newxmax = this.limits.xmax;
        double newymin = this.limits.ymin;
        double newymax = this.limits.ymax;
        double scaleX = this.limits.getXRange() / (double)width;
        double scaleY = this.limits.getYRange() / (double)height;
        int area = this.getCoordinates().getArea();
        if (scaleX < scaleY) {
            double adjustX = scaleY * (double)width - this.limits.getXRange();
            if (area == 1 || area == 9 || area == 8) {
                newxmax = this.limits.xmax + adjustX;
            }
            if (area == 3 || area == 21 || area == 18) {
                newxmin = this.limits.xmin - adjustX / 2.0;
                newxmax = this.limits.xmax + adjustX / 2.0;
            }
            if (area == 2 || area == 6 || area == 4) {
                newxmin = this.limits.xmin - adjustX;
            }
        } else {
            double adjustY = scaleX * (double)height - this.limits.getYRange();
            if (area == 1 || area == 3 || area == 2) {
                newymax = this.limits.ymax + adjustY;
            }
            if (area == 6 || area == 21 || area == 9) {
                newymax = this.limits.ymax + adjustY / 2.0;
                newymin = this.limits.ymin - adjustY / 2.0;
            }
            if (area == 8 || area == 18 || area == 4) {
                newymin = this.limits.ymin - adjustY;
            }
        }
        this.checkAndSetLimits(newxmin, newxmax, newymin, newymax, this.limits);
    }

    public int getEdge() {
        return this.edge;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public double getXmax() {
        return this.limits.xmax;
    }

    public double getXmin() {
        return this.limits.xmin;
    }

    public double getXPixelScale() {
        return this.limits.getXRange() / (double)(this.mathpanel2d.getWidth() - 2 * this.edge - this.insets.left - this.insets.right);
    }

    public double getYmax() {
        return this.limits.ymax;
    }

    public double getYmin() {
        return this.limits.ymin;
    }

    public double getYPixelScale() {
        return this.limits.getYRange() / (double)(this.mathpanel2d.getHeight() - 2 * this.edge - this.insets.top - this.insets.bottom);
    }

    public double pixelToX(int x) {
        return this.limits.xmin + (double)(x - this.edge - this.insets.left) * (this.limits.xmax - this.limits.xmin) / (double)(this.mathpanel2d.getWidth() - 2 * this.edge - this.insets.left - this.insets.right - 1);
    }

    public double pixelToY(int y) {
        return this.limits.ymax - (double)(y - this.edge - this.insets.top) * (this.limits.ymax - this.limits.ymin) / (double)(this.mathpanel2d.getHeight() - 2 * this.edge - this.insets.top - this.insets.bottom - 1);
    }

    private void roundCoords() {
        int adjust = 0;
        if (this.roundx) {
            adjust = 1;
        }
        if (this.roundy) {
            adjust = 2;
        }
        if (this.roundx && this.roundy) {
            adjust = 3;
        }
        this.limits.roundCoords(this.roundingpercent, adjust);
    }

    public void setEdge(int edge) {
        if (edge < 0) {
            throw new IllegalArgumentException("");
        }
        this.edge = edge;
    }

    public void setLimits(CoordinateRect2D coordinates) {
        this.setLimits(coordinates.xmin, coordinates.xmax, coordinates.ymin, coordinates.ymax);
    }

    public void setLimits(double xmin, double xmax, double ymin, double ymax) {
        this.checkAndSetLimits(xmin, xmax, ymin, ymax, this.originallimits);
        this.scalex = 1.0;
        this.scaley = 1.0;
        this.prepareScene();
    }

    public void prepareScene() {
        this.limits = (CoordinateRect2D)this.originallimits.clone();
        if (this.ensurezerox) {
            this.ensureZeroX();
        }
        if (this.ensurezeroy) {
            this.ensureZeroY();
        }
        this.calcRescaledLimits();
        if (this.roundx || this.roundy) {
            this.roundCoords();
        }
        if (this.equalize) {
            this.equalizeCoords();
        }
    }

    public void ensureZero(boolean enable) {
        this.ensurezerox = enable;
        this.ensurezeroy = enable;
    }

    public void ensureLimits(CoordinateRect2D rect) {
        CoordinateRect2D combined = this.limits.combine(rect);
        this.setLimits(combined.xmin, combined.xmax, combined.ymin, combined.ymax);
    }

    private void ensureZeroY() {
        if (this.limits.ymin > 0.0) {
            this.checkAndSetLimits(this.limits.xmin, this.limits.xmax, 0.0, this.limits.ymax, this.limits);
            return;
        }
        if (this.limits.ymax < 0.0) {
            this.checkAndSetLimits(this.limits.xmin, this.limits.xmax, this.limits.ymin, 0.0, this.limits);
            return;
        }
    }

    private void ensureZeroX() {
        if (this.limits.xmin > 0.0) {
            this.checkAndSetLimits(0.0, this.limits.xmax, this.limits.ymin, this.limits.ymax, this.limits);
            return;
        }
        if (this.limits.xmax < 0.0) {
            this.checkAndSetLimits(this.limits.xmin, 0.0, this.limits.ymin, this.limits.ymax, this.limits);
            return;
        }
    }

    public void axesequal(boolean b) {
        this.equalize = b;
    }

    public boolean isAxesEqualEnabled() {
        return this.equalize;
    }

    private void checkAndSetLimits(double xmin, double xmax, double ymin, double ymax, CoordinateRect2D rect) {
        if (xmin == xmax) {
            rect.xmin = xmin - 1.0;
            rect.xmax = xmin + 1.0;
        } else {
            rect.xmin = xmin;
            rect.xmax = xmax;
        }
        if (ymin == ymax) {
            rect.ymin = ymin - 1.0;
            rect.ymax = ymin + 1.0;
        } else {
            rect.ymin = ymin;
            rect.ymax = ymax;
        }
    }

    public void ensureZeroX(boolean ensure) {
        this.ensurezerox = ensure;
    }

    public void ensureZeroY(boolean ensure) {
        this.ensurezeroy = ensure;
    }

    public void setPanel(MathPanel2D mathpanel2d) {
        this.mathpanel2d = mathpanel2d;
    }

    public String toString() {
        return this.limits.toString();
    }

    public int xToPixel(double x) {
        if (x == Double.NEGATIVE_INFINITY) {
            return -1073741824;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 0x3FFFFFFF;
        }
        int xInt = this.edge + this.insets.left + (int)Math.round((x - this.limits.xmin) / (this.limits.xmax - this.limits.xmin) * (double)(this.mathpanel2d.getWidth() - 2 * this.edge - this.insets.left - this.insets.right - 1));
        return xInt;
    }

    public int yToPixel(double y) {
        if (y == Double.NEGATIVE_INFINITY) {
            return 0x3FFFFFFF;
        }
        if (y == Double.POSITIVE_INFINITY) {
            return -1073741824;
        }
        int yInt = this.edge + this.insets.top + (int)Math.round((this.limits.ymax - y) / (this.limits.ymax - this.limits.ymin) * (double)(this.mathpanel2d.getHeight() - 2 * this.edge - this.insets.top - this.insets.bottom - 1));
        return yInt;
    }

    public Point project(Punkt2D a) {
        return new Point(this.xToPixel(a.x), this.yToPixel(a.y));
    }

    public Punkt2D projectdouble(Punkt2D a) {
        return new Punkt2D(this.xToPixel(a.x), this.yToPixel(a.y));
    }

    public CoordinateRect2D getCoordinates() {
        return (CoordinateRect2D)this.limits.clone();
    }

    public double getXRange() {
        return this.limits.getXRange();
    }

    public double getYRange() {
        return this.limits.getYRange();
    }

    boolean processRequests() {
        if (this.requestedInsets.left != 0 || this.requestedInsets.right != 0 || this.requestedInsets.top != 0 || this.requestedInsets.bottom != 0) {
            this.insets.left += this.requestedInsets.left;
            this.insets.right += this.requestedInsets.right;
            this.insets.top += this.requestedInsets.top;
            this.insets.bottom += this.requestedInsets.bottom;
            this.requestedInsets.left = 0;
            this.requestedInsets.right = 0;
            this.requestedInsets.top = 0;
            this.requestedInsets.bottom = 0;
            return true;
        }
        return false;
    }

    public void requestSpaceBottom(int pixel) {
        if (pixel >= this.mathpanel2d.getHeight() - this.edge && Math.abs(pixel - this.mathpanel2d.getHeight() + this.edge) > this.requestedInsets.bottom) {
            this.requestedInsets.bottom = Math.abs(pixel - this.mathpanel2d.getHeight() + this.edge);
        }
    }

    public void requestSpaceLeft(int pixel) {
        if (pixel <= this.edge && Math.abs(this.edge - pixel) > this.requestedInsets.left) {
            this.requestedInsets.left = Math.abs(this.edge - pixel);
        }
    }

    public void requestSpaceRight(int pixel) {
        if (pixel >= this.mathpanel2d.getWidth() - this.edge && Math.abs(pixel - this.mathpanel2d.getWidth() + this.edge) > this.requestedInsets.right) {
            this.requestedInsets.right = Math.abs(pixel - this.mathpanel2d.getWidth() + this.edge);
        }
    }

    public void requestSpaceTop(int pixel) {
        if (pixel <= this.edge && Math.abs(this.edge - pixel) > this.requestedInsets.top) {
            this.requestedInsets.top = Math.abs(this.edge - pixel);
        }
    }

    void resetInsets() {
        this.insets.bottom = 0;
        this.insets.top = 0;
        this.insets.left = 0;
        this.insets.right = 0;
        this.requestedInsets.bottom = 0;
        this.requestedInsets.top = 0;
        this.requestedInsets.left = 0;
        this.requestedInsets.right = 0;
    }

    private void calcRescaledLimits() {
        this.calcRescaledLimitsX(this.scalex);
        this.calcRescaledLimitsY(this.scaley);
    }

    private void calcRescaledLimitsX(double factor) {
        double xmin = this.limits.xmin;
        double xmax = this.limits.xmax;
        double ymin = this.limits.ymin;
        double ymax = this.limits.ymax;
        double newxmin = xmin;
        double newxmax = xmax;
        double newymin = ymin;
        double newymax = ymax;
        int area = this.limits.getArea();
        if (area == 1 || area == 9 || area == 8) {
            newxmax = xmin + this.getXRange() * factor;
        }
        if (area == 3 || area == 21 || area == 18) {
            newxmax = this.limits.xmax * factor;
            newxmin = this.limits.xmin * factor;
        }
        if (area == 2 || area == 6 || area == 4) {
            newxmin = xmax - this.getXRange() * factor;
        }
        this.limits.xmin = newxmin;
        this.limits.xmax = newxmax;
        this.limits.ymin = newymin;
        this.limits.ymax = newymax;
    }

    private void calcRescaledLimitsY(double factor) {
        double xmin = this.limits.xmin;
        double xmax = this.limits.xmax;
        double ymin = this.limits.ymin;
        double ymax = this.limits.ymax;
        double newxmin = xmin;
        double newxmax = xmax;
        double newymin = ymin;
        double newymax = ymax;
        int area = this.limits.getArea();
        if (area == 1 || area == 3 || area == 2) {
            newymax = ymin + this.getYRange() * factor;
        }
        if (area == 6 || area == 21 || area == 9) {
            newymax = ymax * factor;
            newymin = ymin * factor;
        }
        if (area == 8 || area == 18 || area == 4) {
            newymin = ymax - this.getYRange() * factor;
        }
        this.limits.xmin = newxmin;
        this.limits.xmax = newxmax;
        this.limits.ymin = newymin;
        this.limits.ymax = newymax;
    }

    public CoordinateRect2D getOriginalLimits() {
        return (CoordinateRect2D)this.originallimits.clone();
    }
}

