/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.base;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.image.BufferedImage;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.base.Scene2D;
import uibk.mtk.lang.Highlightable;
import uibk.mtk.lang.MathPanel;
import uibk.mtk.lang.PrepaintComputable;

public class MathPanel2D
extends MathPanel {
    private Scene2D scene2d = new Scene2D(this);
    int tmp;

    public Scene2D getScene2d() {
        return this.scene2d;
    }

    public boolean isPointInCoordsArea(Point point) {
        Insets insets = this.scene2d.getInsets();
        int edge = this.scene2d.getEdge();
        return point.x > insets.left + edge && point.x < this.getWidth() - insets.right - edge && point.y < this.getHeight() - insets.bottom - edge && point.y > insets.top + edge;
    }

    public void add(Object obj) {
        if (obj == null || !(obj instanceof Drawable2D)) {
            throw new IllegalArgumentException("");
        }
        if (!this.drawItems.contains(obj)) {
            Drawable2D draw = (Drawable2D)obj;
            super.add(draw);
            draw.setMathPanel2D(this);
        }
    }

    public void drawDrawables(BufferedImage framebuffer, Graphics2D g2) {
        int i;
        if (this.options != null) {
            this.options.setRenderingHints(g2);
        }
        int ct = this.drawItems.size();
        this.scene2d.prepareScene();
        if (this.repaintrequested) {
            this.scene2d.resetInsets();
            i = 0;
            while (i < ct) {
                if (this.drawItems.elementAt(i) instanceof PrepaintComputable && ((Drawable2D)this.drawItems.elementAt(i)).isVisible()) {
                    try {
                        ((PrepaintComputable)this.drawItems.elementAt(i)).prepaintcompute();
                    }
                    catch (Exception ex) {
                        this.reportError(ex);
                    }
                }
                ++i;
            }
            boolean changes = this.scene2d.processRequests();
            if (changes) {
                int i2 = 0;
                while (i2 < ct) {
                    if (this.drawItems.elementAt(i2) instanceof PrepaintComputable && ((Drawable2D)this.drawItems.elementAt(i2)).isVisible()) {
                        try {
                            ((PrepaintComputable)this.drawItems.elementAt(i2)).prepaintcompute();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++i2;
                }
            }
        }
        i = 0;
        while (i < ct) {
            Drawable2D d = (Drawable2D)this.drawItems.elementAt(i);
            if (d.isVisible()) {
                if (d == this.highlighted) {
                    ((Highlightable)((Object)d)).highlight(framebuffer, g2);
                } else {
                    d.draw(framebuffer, g2);
                }
            }
            ++i;
        }
        this.repaintrequested = false;
    }
}

