/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.riemann3d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.riemann3d.AppletRiemann3D;
import uibk.mtk.draw3d.objects.surface3d.Function2DMeshBuilder;
import uibk.mtk.draw3d.objects.surface3d.Mesh;
import uibk.mtk.geom.geom2d.CoordinateRect2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.geom.geom3d.CoordinateBox3D;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.ParsedFunction2D;
import uibk.mtk.math.parsing.Function2DParser;
import uibk.mtk.swing.base.IntervalTextField;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TextField;

public class PanelSurface
extends MPanel
implements ActionListener {
    TextField textFormula = new TextField();
    JButton buttonCalc;
    JSlider sliderMeshPoints;
    JLabel labelmesh;
    AppletRiemann3D main;
    IntervalTextField txtIntervalX;
    IntervalTextField txtIntervalY;
    Interval intervalreal;
    Interval intervalimag;

    public PanelSurface(AppletRiemann3D main) {
        this.main = main;
        this.initComponents();
    }

    private ParsedFunction2D getFunction() {
        try {
            String strfunc = this.textFormula.getText();
            return Function2DParser.parse(AppletRiemann3D.VARS[0], AppletRiemann3D.VARS[1], strfunc);
        }
        catch (Exception e) {
            this.main.mathpanel3d.reportError(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.0"), e);
            return null;
        }
    }

    void compute() {
        this.main.panelpartialderivs.setEnabled(false);
        this.main.function = this.getFunction();
        if (this.main.function == null) {
            return;
        }
        int n = this.sliderMeshPoints.getValue();
        this.main.first = true;
        try {
            this.intervalreal = this.txtIntervalX.getInterval();
            this.intervalimag = this.txtIntervalY.getInterval();
        }
        catch (Exception e) {
            this.main.mathpanel3d.reportError(e);
            return;
        }
        CoordinateRect2D limits = new CoordinateRect2D(this.intervalreal.a, this.intervalreal.b, this.intervalimag.a, this.intervalimag.b);
        try {
            Function2DMeshBuilder meshbuilder = new Function2DMeshBuilder(this.main.function);
            Mesh mesh = meshbuilder.build(limits, n, n, true);
            this.main.surface3d[0].setMesh(mesh);
            this.main.panelpartialderivs.creategrid();
        }
        catch (Exception e) {
            this.main.surface3d[0].setVisible(false);
            this.main.mathpanel3d.reportError(e);
            return;
        }
        this.main.gridpoints = new Punkt2D[2][5];
        this.main.gridpoints[0] = this.main.riemannvisx.getPoints();
        this.main.gridpoints[1] = this.main.riemannvisy.getPoints();
        CoordinateBox3D box = this.main.surface3d[0].getBoundingBox();
        this.main.mathpanel3d.getScene3D().setBoundingBox(box);
        this.main.visible.setEnabled(false);
        this.main.surface3d[0].setVisible(true);
        this.main.surface3d[1].setVisible(false);
        this.main.panelpartialderivs.setselected();
        this.main.mathpanel3d.reportSuccess(this.main.function + Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.1"));
        this.main.mathpanel3d.repaint();
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.2"))) {
            this.compute();
            this.main.mathpanel3d.repaint();
        }
    }

    void initComponents() {
        TitledBorder border = BorderFactory.createTitledBorder(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.3"));
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(2000, 270));
        this.setPreferredSize(new Dimension(2000, 270));
        int n = 10;
        this.labelmesh = new JLabel(String.valueOf(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.4")) + n + "x" + n);
        this.labelmesh.setFont(this.labelmesh.getFont().deriveFont(1));
        String[] vars = AppletRiemann3D.VARS;
        this.textFormula = new TextField(10);
        this.textFormula.setActionCommand("compute");
        this.textFormula.addActionListener(this);
        this.textFormula.setToolTipText(String.valueOf(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.7")) + vars[0] + "," + vars[1] + Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.9"));
        this.txtIntervalY = new IntervalTextField(10, Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.10"), true);
        this.txtIntervalY.setActionCommand(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.11"));
        this.txtIntervalY.addActionListener(this);
        this.txtIntervalY.setToolTipText(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.12"));
        this.txtIntervalX = new IntervalTextField(10, Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.13"), true);
        this.txtIntervalX.setActionCommand("compute");
        this.txtIntervalX.addActionListener(this);
        this.txtIntervalX.setToolTipText(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.15"));
        this.buttonCalc = new JButton(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.16"));
        this.buttonCalc.setActionCommand("compute");
        this.buttonCalc.addActionListener(this);
        this.buttonCalc.setToolTipText(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.18"));
        JLabel labelFormula = new JLabel("f(" + vars[0] + "," + vars[1] + ")=");
        this.sliderMeshPoints = new JSlider();
        this.sliderMeshPoints.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                int n = slider.getValue();
                PanelSurface.this.labelmesh.setText(String.valueOf(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.22")) + String.valueOf(n) + "x" + String.valueOf(n));
            }
        });
        this.sliderMeshPoints.setMinimum(2);
        this.sliderMeshPoints.setMaximum(20);
        this.sliderMeshPoints.setValue(10);
        this.add((Component)labelFormula, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 0), 0, 0));
        this.add((Component)this.textFormula, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 0, new Insets(10, 5, 5, 0), 0, 0));
        this.add((Component)this.labelmesh, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)this.sliderMeshPoints, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 20, 5), 0, 0));
        this.add((Component)new JLabel(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.24")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.txtIntervalX, new GridBagConstraints(1, 4, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.25")), new GridBagConstraints(0, 5, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.txtIntervalY, new GridBagConstraints(1, 5, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 0, 15, 5), 0, 0));
        this.add((Component)this.buttonCalc, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 0, 0, 0), 0, 0));
    }
}

