/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.riemann3d;

import Jama.Matrix;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.riemann3d.AppletRiemann3D;
import uibk.applets.riemann3d.PanelChoose;
import uibk.mtk.draw3d.objects.surface3d.Mesh;
import uibk.mtk.draw3d.objects.surface3d.Triangle;
import uibk.mtk.draw3d.objects.surface3d.Vertex3D;
import uibk.mtk.geom.geom2d.CoordinateRect2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.geom.geom3d.CoordinateBox3D;
import uibk.mtk.lang.ComputationException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.Interval;
import uibk.mtk.math.NewtonMethod;
import uibk.mtk.math.NewtonMethod2D;
import uibk.mtk.math.integration.GaussIntegration2D;
import uibk.mtk.swing.base.TitledPanel;
import uibk.mtk.util.Grid2D;

public class PanelPartialDerivates
extends TitledPanel
implements ActionListener {
    AppletRiemann3D main;
    JRadioButton QuadraturFormel;
    JRadioButton zuf\u00e4llig1;
    JRadioButton zoom;
    JRadioButton oberunter;
    JRadioButton ober;
    JRadioButton unter;
    JSlider sliderStep;
    JLabel labelstep;
    JSlider slidergitter;
    JLabel labelgitter;
    Vertex3D[] vertices;
    double[][] value;
    double valuex;
    double valuey;
    double valueup = Double.NaN;
    double valuedown = Double.NaN;
    CoordinateRect2D rechteck = new CoordinateRect2D();
    CoordinateRect2D rechteckit = new CoordinateRect2D();
    Punkt2D[][] grid;
    Punkt2D[][] gridnewton;
    NewtonMethod ein = new NewtonMethod();
    JButton buttonCalc;

    public PanelPartialDerivates(AppletRiemann3D main) {
        super(Messages.getString("uibk.applets.riemann3d.messages", "PanelPartialDerivates.0"));
        this.main = main;
        this.initComponents();
    }

    private void getmaxmin(int i, int j) {
        double f;
        double[] a = new double[4];
        double defect = 1.0;
        Matrix min = new Matrix(1, 1);
        NewtonMethod2D zweimin = new NewtonMethod2D();
        zweimin.setFunction(this.main.function);
        int k = 0;
        while (k < this.gridnewton.length) {
            int m = 0;
            while (m < this.gridnewton[0].length) {
                zweimin.setX0(this.gridnewton[k][m].x);
                zweimin.setY0(this.gridnewton[k][m].y);
                min = zweimin.getXY();
                while (defect > 1.0E-6 && this.rechteckit.contains(min.get(0, 0), min.get(1, 0))) {
                    try {
                        min = zweimin.nextApproximation();
                        defect = zweimin.getDefect();
                    }
                    catch (ComputationException e) {
                        defect = 0.0;
                    }
                }
                if (this.rechteck.contains(min.get(0, 0), min.get(1, 0))) {
                    this.valuex = min.get(0, 0);
                    this.valuey = min.get(1, 0);
                    this.valueup = this.valueup > this.main.function.getValue(this.valuex, this.valuey) ? this.valueup : this.main.function.getValue(this.valuex, this.valuey);
                    this.valuedown = this.valuedown < this.main.function.getValue(this.valuex, this.valuey) ? this.valuedown : this.main.function.getValue(this.valuex, this.valuey);
                }
                ++m;
            }
            ++k;
        }
        this.ein.setFunction2D(this.main.function);
        int m = 0;
        while (m < this.gridnewton.length) {
            defect = 1.0;
            f = this.gridnewton[m][0].x;
            this.ein.setX0(f);
            while (defect > 1.0E-8 && this.rechteckit.contains(f, this.grid[i][j].y)) {
                try {
                    f = this.ein.nextApproximation(this.grid[i][j].y, 2);
                    defect = this.ein.getDefect();
                }
                catch (ComputationException e) {
                    defect = 0.0;
                }
            }
            if (this.rechteck.contains(f, this.grid[i][j].y)) {
                this.valueup = this.valueup > this.main.function.getValue(this.grid[i][j].x, f) ? this.valueup : this.main.function.getValue(this.grid[i][j].x, f);
                this.valuedown = this.valuedown < this.main.function.getValue(f, this.grid[i][j].y) ? this.valuedown : this.main.function.getValue(f, this.grid[i][j].y);
            }
            ++m;
        }
        m = 0;
        while (m < this.gridnewton[0].length) {
            defect = 1.0;
            f = this.gridnewton[0][m].y;
            this.ein.setX0(f);
            while (defect > 1.0E-6 && this.rechteckit.contains(this.grid[i][j].x, f)) {
                try {
                    f = this.ein.nextApproximation(this.grid[i][j].x, 1);
                    defect = this.ein.getDefect();
                }
                catch (ComputationException e) {
                    defect = 0.0;
                }
            }
            if (this.rechteck.contains(this.grid[i][j].x, f)) {
                this.valueup = this.valueup > this.main.function.getValue(this.grid[i][j].x, f) ? this.valueup : this.main.function.getValue(this.grid[i][j].x, f);
                this.valuedown = this.valuedown < this.main.function.getValue(this.grid[i][j].x, f) ? this.valuedown : this.main.function.getValue(this.grid[i][j].x, f);
            }
            ++m;
        }
        m = 0;
        while (m < this.gridnewton.length) {
            defect = 1.0;
            f = this.gridnewton[m][this.gridnewton[0].length - 1].x;
            this.ein.setX0(f);
            while (defect > 1.0E-6 && this.rechteckit.contains(f, this.grid[i + 1][j].y)) {
                try {
                    f = this.ein.nextApproximation(this.grid[i + 1][j].y, 2);
                    defect = this.ein.getDefect();
                }
                catch (ComputationException e) {
                    defect = 0.0;
                }
            }
            if (this.rechteck.contains(f, this.grid[i + 1][j].y)) {
                this.valueup = this.valueup > this.main.function.getValue(this.grid[i][j].x, f) ? this.valueup : this.main.function.getValue(this.grid[i][j].x, f);
                this.valuedown = this.valuedown < this.main.function.getValue(f, this.grid[i + 1][j].y) ? this.valuedown : this.main.function.getValue(f, this.grid[i + 1][j].y);
            }
            ++m;
        }
        m = 0;
        while (m < this.gridnewton[0].length) {
            defect = 1.0;
            f = this.gridnewton[this.gridnewton.length - 1][m].y;
            this.ein.setX0(f);
            while (defect > 1.0E-6 && this.rechteckit.contains(this.grid[i][j + 1].x, f)) {
                try {
                    f = this.ein.nextApproximation(this.grid[i][j + 1].x, 1);
                    defect = this.ein.getDefect();
                }
                catch (ComputationException e) {
                    defect = 0.0;
                }
            }
            if (this.rechteck.contains(this.grid[i][j + 1].x, f)) {
                this.valueup = this.valueup > this.main.function.getValue(this.grid[i][j].x, f) ? this.valueup : this.main.function.getValue(this.grid[i][j].x, f);
                this.valuedown = this.valuedown < this.main.function.getValue(this.grid[i][j + 1].x, f) ? this.valuedown : this.main.function.getValue(this.grid[i][j + 1].x, f);
            }
            ++m;
        }
        a[0] = this.main.function.getValue(this.grid[i][j].x, this.grid[i][j].y);
        a[1] = this.main.function.getValue(this.grid[i + 1][j].x, this.grid[i + 1][j].y);
        a[2] = this.main.function.getValue(this.grid[i][j + 1].x, this.grid[i][j + 1].y);
        a[3] = this.main.function.getValue(this.grid[i + 1][j + 1].x, this.grid[i + 1][j + 1].y);
        int index = 0;
        while (index < 4) {
            if (Double.isNaN(this.valuedown)) {
                this.valuedown = a[index];
                this.valueup = a[index];
            } else {
                this.valuedown = this.valuedown < a[index] ? this.valuedown : a[index];
                this.valueup = this.valueup > a[index] ? this.valueup : a[index];
            }
            ++index;
        }
    }

    public void setselected() {
        if (!this.main.panelpartialderivs.isEnabled()) {
            this.main.panelpartialderivs.setEnabled(true);
            this.main.panelpartialderivs.QuadraturFormel.setSelected(true);
            this.main.panelpartialderivs.ober.setEnabled(false);
            this.main.panelpartialderivs.unter.setEnabled(false);
        } else {
            if (this.main.panelpartialderivs.QuadraturFormel.isSelected()) {
                this.main.panelpartialderivs.sliderStep.setEnabled(true);
                this.main.panelpartialderivs.ober.setEnabled(false);
                this.main.panelpartialderivs.unter.setEnabled(false);
            }
            if (this.main.panelpartialderivs.zuf\u00e4llig1.isSelected()) {
                this.main.panelpartialderivs.sliderStep.setEnabled(false);
                this.main.panelpartialderivs.ober.setEnabled(false);
                this.main.panelpartialderivs.unter.setEnabled(false);
            }
            if (this.main.panelpartialderivs.oberunter.isSelected()) {
                this.main.panelpartialderivs.sliderStep.setEnabled(false);
                this.main.panelpartialderivs.ober.setEnabled(true);
                this.main.panelpartialderivs.unter.setEnabled(true);
            }
        }
    }

    private void zoom() throws Exception {
        this.main.mathpanel3d.setVisible(false);
        this.main.mathpanel2d.setVisible(false);
        if (this.zoom.isSelected()) {
            this.main.setMainPanel(this.main.mathpanel2d);
            this.main.mathpanel3d.setVisible(false);
            this.main.mathpanel2d.setVisible(true);
        } else {
            this.main.mathpanel2d.setVisible(false);
            this.main.mathpanel3d.setVisible(true);
            this.main.setMainPanel(this.main.mathpanel3d);
        }
    }

    void creategrid() throws Exception {
        Interval intervalx = this.main.panelsurface.intervalreal;
        Interval intervaly = this.main.panelsurface.intervalimag;
        this.main.riemannvisx.setInterval(intervalx);
        this.main.riemannvisy.setInterval(intervaly);
        this.main.riemannvisx.setIntervalimag(intervaly);
        this.main.riemannvisy.setIntervalimag(intervalx);
        this.main.riemannvisx.create();
        this.main.riemannvisy.create();
        this.main.mathpanel2d.getScene2d().setXInterval(intervalx);
        this.main.mathpanel2d.getScene2d().setYInterval(intervaly);
    }

    private void compute() {
        int j;
        int i;
        int lengthx;
        double sum = 0.0;
        double sumup = 0.0;
        double sumdown = 0.0;
        int s = this.main.panelpartialderivs.sliderStep.getValue();
        int lengthy = lengthx = this.main.panelpartialderivs.slidergitter.getValue();
        Interval x = this.main.panelsurface.intervalreal;
        Interval y = this.main.panelsurface.intervalimag;
        lengthx = this.main.riemannvisx.getPoints().length;
        lengthy = this.main.riemannvisy.getPoints().length;
        this.value = new double[lengthx - 1][lengthy - 1];
        int n = Math.max(lengthx, lengthy);
        this.main.gridpoints = new Punkt2D[2][n];
        this.main.gridpoints[0] = this.main.riemannvisx.getPoints();
        this.main.gridpoints[1] = this.main.riemannvisy.getPoints();
        this.grid = Grid2D.createGrid2D(this.main.gridpoints);
        this.vertices = new Vertex3D[5 * lengthx * lengthy];
        Vector<Vertex3D> vert = new Vector<Vertex3D>(lengthx * lengthy);
        Vector<Triangle> triangles = new Vector<Triangle>(8 * (lengthx - 1) * (lengthy - 1) + 2 * (lengthx - 1 + (lengthy - 1)));
        Random random = new Random();
        if (this.main.first) {
            double exactsum = GaussIntegration2D.quadrature(this.main.function, x.a, x.b, y.a, y.b, 8, 9);
            this.main.paneloutput.setExactValue(exactsum);
            this.main.first = false;
        }
        if (this.QuadraturFormel.isSelected()) {
            int m = 0;
            i = 0;
            while (i < lengthx - 1) {
                j = 0;
                while (j < lengthy - 1) {
                    this.rechteck = new CoordinateRect2D(this.grid[i][j].x, this.grid[i + 1][j + 1].x, this.grid[i][j].y, this.grid[i + 1][j + 1].y);
                    this.main.knotpoints = new double[lengthx * lengthy][2][s];
                    this.main.weigths = new double[s][s];
                    GaussIntegration2D.calcKnotsAndWeights(this.grid[i][j].x, this.grid[i + 1][j].x, this.grid[i][j].y, this.grid[i][j + 1].y, this.main.knotpoints[m], this.main.weigths, s);
                    this.value[i][j] = GaussIntegration2D.quadrature(this.main.function, this.grid[i][j].x, this.grid[i + 1][j].x, this.grid[i][j].y, this.grid[i][j + 1].y, s, 1) / (this.rechteck.getXRange() * this.rechteck.getYRange());
                    sum += this.value[i][j] * (this.rechteck.getXRange() * this.rechteck.getYRange());
                    ++m;
                    ++j;
                }
                ++i;
            }
            this.main.paneloutput.createOutput(sum, (lengthx - 1) * (lengthy - 1) * s, s);
        }
        if (this.main.panelpartialderivs.zuf\u00e4llig1.isSelected()) {
            int w = 0;
            this.main.knotpoints = new double[lengthx * lengthy][1][2];
            i = 0;
            while (i < lengthx - 1) {
                j = 0;
                while (j < lengthy - 1) {
                    this.rechteck = new CoordinateRect2D(this.grid[i][j].x, this.grid[i + 1][j + 1].x, this.grid[i][j].y, this.grid[i + 1][j + 1].y);
                    double zufallx = Math.abs(random.nextDouble()) % 1.0;
                    double valuex = (-this.grid[i][j].x + this.grid[i + 1][j].x) * zufallx + this.grid[i][j].x;
                    double zufally = Math.abs(random.nextDouble()) % 1.0;
                    double valuey = (-this.grid[i][j].y + this.grid[i][j + 1].y) * zufally + this.grid[i][j].y;
                    this.main.knotpoints[w][0][0] = zufallx;
                    this.main.knotpoints[w][0][1] = zufally;
                    this.value[i][j] = this.main.function.getValue(valuex, valuey);
                    sum += this.value[i][j] * this.rechteck.getXRange() * this.rechteck.getYRange();
                    ++j;
                }
                ++i;
            }
            this.main.paneloutput.createOutput(sum, (lengthx - 1) * (lengthy - 1), s);
        }
        if (this.main.panelpartialderivs.oberunter.isSelected()) {
            int i2 = 0;
            while (i2 < lengthx - 1) {
                int j2 = 0;
                while (j2 < lengthy - 1) {
                    this.gridnewton = Grid2D.createGrid2D(this.grid[i2][j2].x, this.grid[i2 + 1][j2 + 1].x, this.grid[i2][j2].y, this.grid[i2 + 1][j2 + 1].y, 20 / (lengthx - 1) + 1, 20 / (lengthy - 1) + 1);
                    this.rechteck = new CoordinateRect2D(this.grid[i2][j2].x, this.grid[i2 + 1][j2 + 1].x, this.grid[i2][j2].y, this.grid[i2 + 1][j2 + 1].y);
                    this.rechteckit = this.rechteck.mult(1.05);
                    this.valuedown = Double.NaN;
                    this.valueup = Double.NaN;
                    this.getmaxmin(i2, j2);
                    sumup += this.valueup * this.rechteck.getXRange() * this.rechteck.getYRange();
                    sumdown += this.valuedown * (this.rechteck.getXRange() * this.rechteck.getYRange());
                    this.value[i2][j2] = this.main.panelpartialderivs.ober.isSelected() ? this.valueup : this.valuedown;
                    ++j2;
                }
                ++i2;
            }
            this.main.paneloutput.createOutput(sumup, sumdown, (lengthx - 1) * (lengthy - 1));
        }
        int c = 0;
        i = 0;
        while (i < lengthx) {
            j = 0;
            while (j < lengthy) {
                if (i == 0 && j == 0) {
                    this.vertices[c] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                    this.vertices[c + 1] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                    this.vertices[c + 2] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                    this.vertices[c + 3] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, this.value[i][j]);
                }
                if (i == 0 && j == lengthy - 1) {
                    this.vertices[c] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                    this.vertices[c + 1] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, this.value[i][j - 1]);
                    this.vertices[c + 2] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                    this.vertices[c + 3] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                }
                if (i == lengthx - 1 && j == lengthy - 1) {
                    this.vertices[c] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, this.value[i - 1][j - 1]);
                    this.vertices[c + 1] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                    this.vertices[c + 2] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                    this.vertices[c + 3] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                }
                if (i == lengthx - 1 && j == 0) {
                    this.vertices[c] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                    this.vertices[c + 1] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                    this.vertices[c + 2] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, this.value[i - 1][j]);
                    this.vertices[c + 3] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                }
                if (i == 0 && j != 0 && j != lengthy - 1) {
                    this.vertices[c] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                    this.vertices[c + 1] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, this.value[i][j - 1]);
                    this.vertices[c + 2] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                    this.vertices[c + 3] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, this.value[i][j]);
                }
                if (i == lengthx - 1 && j != 0 && j != lengthy - 1) {
                    this.vertices[c] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, this.value[i - 1][j - 1]);
                    this.vertices[c + 1] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                    this.vertices[c + 2] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, this.value[i - 1][j]);
                    this.vertices[c + 3] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                }
                if (j == 0 && i != 0 && i != lengthx - 1) {
                    this.vertices[c] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                    this.vertices[c + 1] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                    this.vertices[c + 2] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, this.value[i - 1][j]);
                    this.vertices[c + 3] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, this.value[i][j]);
                }
                if (j == lengthy - 1 && i != 0 && i != lengthx - 1) {
                    this.vertices[c] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, this.value[i - 1][j - 1]);
                    this.vertices[c + 1] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, this.value[i][j - 1]);
                    this.vertices[c + 2] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                    this.vertices[c + 3] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                }
                if (j != 0 && j != lengthy - 1 && i != 0 && i != lengthx - 1) {
                    this.vertices[c] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, this.value[i - 1][j - 1]);
                    this.vertices[c + 1] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, this.value[i][j - 1]);
                    this.vertices[c + 2] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, this.value[i - 1][j]);
                    this.vertices[c + 3] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, this.value[i][j]);
                }
                this.vertices[c + 4] = new Vertex3D(this.grid[i][j].x, this.grid[i][j].y, 0.0);
                c += 5;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < lengthx - 1) {
            j = 0;
            while (j < lengthy - 1) {
                int p1 = 5 * lengthy * (i + 1) + 5 * j;
                int p2 = 5 * lengthy * (i + 1) + 5 * (j + 1);
                int p3 = 5 * lengthy * i + 5 * (j + 1);
                int p4 = 5 * lengthy * i + 5 * j;
                if (this.vertices[p4 + 2].mc.x3 * this.vertices[p4 + 3].mc.x3 >= 0.0) {
                    triangles.add(new Triangle(this.vertices[p3 + 1], this.vertices[p4 + 3], this.vertices[p3]));
                    triangles.add(new Triangle(this.vertices[p4 + 2], this.vertices[p3], this.vertices[p4 + 3]));
                } else {
                    triangles.add(new Triangle(this.vertices[p3 + 1], this.vertices[p4 + 3], this.vertices[p3 + 4]));
                    triangles.add(new Triangle(this.vertices[p4 + 4], this.vertices[p3 + 4], this.vertices[p4 + 3]));
                    triangles.add(new Triangle(this.vertices[p3 + 4], this.vertices[p4 + 4], this.vertices[p3]));
                    triangles.add(new Triangle(this.vertices[p4 + 2], this.vertices[p3], this.vertices[p4 + 4]));
                }
                if (this.vertices[p4 + 1].mc.x3 * this.vertices[p4 + 3].mc.x3 >= 0.0) {
                    triangles.add(new Triangle(this.vertices[p4 + 3], this.vertices[p1 + 2], this.vertices[p4 + 1]));
                    triangles.add(new Triangle(this.vertices[p1], this.vertices[p4 + 1], this.vertices[p1 + 2]));
                } else {
                    triangles.add(new Triangle(this.vertices[p4 + 3], this.vertices[p1 + 2], this.vertices[p4 + 4]));
                    triangles.add(new Triangle(this.vertices[p1 + 4], this.vertices[p4 + 4], this.vertices[p1 + 2]));
                    triangles.add(new Triangle(this.vertices[p4 + 4], this.vertices[p1 + 4], this.vertices[p4 + 1]));
                    triangles.add(new Triangle(this.vertices[p1], this.vertices[p4 + 1], this.vertices[p1 + 4]));
                }
                triangles.add(new Triangle(this.vertices[p4 + 3], this.vertices[p3 + 1], this.vertices[p1 + 2]));
                triangles.add(new Triangle(this.vertices[p2], this.vertices[p1 + 2], this.vertices[p3 + 1]));
                triangles.add(new Triangle(this.vertices[p4 + 4], this.vertices[p3 + 4], this.vertices[p1 + 4]));
                triangles.add(new Triangle(this.vertices[p2 + 4], this.vertices[p1 + 4], this.vertices[p3 + 4]));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < lengthx - 1) {
            int p2 = 5 * lengthy * (i + 2) - 5;
            int p3 = 5 * lengthy * (i + 1) - 5;
            if (this.vertices[p3 + 1].mc.x3 * this.vertices[p3 + 3].mc.x3 >= 0.0) {
                triangles.add(new Triangle(this.vertices[p3 + 3], this.vertices[p2 + 2], this.vertices[p3 + 1]));
                triangles.add(new Triangle(this.vertices[p2], this.vertices[p3 + 1], this.vertices[p2 + 2]));
            } else {
                triangles.add(new Triangle(this.vertices[p3 + 3], this.vertices[p2 + 2], this.vertices[p3 + 4]));
                triangles.add(new Triangle(this.vertices[p2 + 4], this.vertices[p3 + 4], this.vertices[p2 + 2]));
                triangles.add(new Triangle(this.vertices[p3 + 4], this.vertices[p2 + 4], this.vertices[p3 + 1]));
                triangles.add(new Triangle(this.vertices[p2], this.vertices[p3 + 1], this.vertices[p2 + 4]));
            }
            ++i;
        }
        i = 0;
        while (i < lengthy - 1) {
            int p1 = 5 * lengthy * (lengthx - 1) + 5 * i;
            int p2 = 5 * lengthy * (lengthx - 1) + 5 * (i + 1);
            if (this.vertices[p2].mc.x3 * this.vertices[p2 + 1].mc.x3 >= 0.0) {
                triangles.add(new Triangle(this.vertices[p1 + 2], this.vertices[p2], this.vertices[p1 + 3]));
                triangles.add(new Triangle(this.vertices[p2 + 1], this.vertices[p1 + 3], this.vertices[p2]));
            } else {
                triangles.add(new Triangle(this.vertices[p1 + 2], this.vertices[p2], this.vertices[p1 + 4]));
                triangles.add(new Triangle(this.vertices[p2 + 4], this.vertices[p1 + 4], this.vertices[p2]));
                triangles.add(new Triangle(this.vertices[p1 + 4], this.vertices[p2 + 4], this.vertices[p1 + 3]));
                triangles.add(new Triangle(this.vertices[p2 + 1], this.vertices[p1 + 3], this.vertices[p2 + 4]));
            }
            ++i;
        }
        i = 0;
        while (i < this.vertices.length) {
            vert.add(this.vertices[i]);
            ++i;
        }
        Mesh mesh = new Mesh(triangles, vert);
        try {
            this.main.surface3d[1].setMesh(mesh);
        }
        catch (Exception e) {
            this.main.surface3d[1].setVisible(false);
            this.main.mathpanel3d.reportError(e);
            return;
        }
        this.main.mathpanel2d.repaint();
        this.setselected();
        CoordinateBox3D box = this.main.surface3d[0].getBoundingBox();
        box.combine(this.main.surface3d[1].getBoundingBox());
        this.main.mathpanel3d.getScene3D().setBoundingBox(box);
        this.main.surface3d[1].setVisible(true);
        this.main.mathpanel3d.reportSuccess(String.valueOf(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.-1")) + Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.1"));
        this.main.mathpanel3d.repaint();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("zuf\u00e4llig1")) {
            if (this.zuf\u00e4llig1.isSelected()) {
                this.main.panelpartialderivs.sliderStep.setEnabled(false);
                this.main.panelpartialderivs.sliderStep.setValue(1);
                this.main.panelpartialderivs.ober.setEnabled(false);
                this.main.panelpartialderivs.unter.setEnabled(false);
            } else {
                this.main.panelpartialderivs.sliderStep.setEnabled(true);
            }
        }
        if (event.getActionCommand().equals("ou")) {
            if (this.oberunter.isSelected()) {
                this.main.panelpartialderivs.sliderStep.setEnabled(false);
                this.main.panelpartialderivs.sliderStep.setValue(1);
                this.main.panelpartialderivs.ober.setEnabled(true);
                this.main.panelpartialderivs.unter.setEnabled(true);
            } else {
                this.main.panelpartialderivs.sliderStep.setEnabled(true);
            }
        }
        if (event.getActionCommand().equals("qf")) {
            if (this.QuadraturFormel.isSelected()) {
                this.main.panelpartialderivs.sliderStep.setEnabled(true);
                this.main.panelpartialderivs.sliderStep.setValue(1);
                this.main.panelpartialderivs.ober.setEnabled(false);
                this.main.panelpartialderivs.unter.setEnabled(false);
            } else {
                this.main.panelpartialderivs.sliderStep.setEnabled(false);
            }
        }
        if (event.getActionCommand().equals("zoom")) {
            try {
                this.zoom();
            }
            catch (Exception e) {
                this.main.mathpanel2d.reportError(e);
            }
        }
        if (event.getActionCommand().equals("compute")) {
            try {
                this.compute();
                this.zoom.setSelected(false);
                this.zoom();
            }
            catch (Exception e) {
                this.main.mathpanel3d.reportError(e);
                return;
            }
            this.main.mathpanel2d.repaint();
            this.main.surface3d[0].setVisible(false);
            this.main.surface3d[1].setVisible(true);
            this.main.visible.setEnabled(true);
            this.main.visible.radioswitch[1].setSelected(true);
            this.main.mathpanel3d.repaint();
        }
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(1100, 600));
        this.QuadraturFormel = new JRadioButton(Messages.getString("uibk.applets.riemann3d.messages", "PanelPartialDerivates.4"));
        this.QuadraturFormel.setActionCommand("qf");
        this.QuadraturFormel.addActionListener(this);
        this.QuadraturFormel.setToolTipText(Messages.getString("uibk.applets.riemann3d.messages", "PanelPartialDerivates.6"));
        this.zoom = new JRadioButton(Messages.getString("uibk.applets.riemann3d.messages", "PanelPartialDerivates.18"));
        this.zoom.setActionCommand("zoom");
        this.zoom.addActionListener(this);
        this.zoom.setToolTipText(Messages.getString("uibk.applets.riemann3d.messages", "PanelPartialDerivates.20"));
        this.zuf\u00e4llig1 = new JRadioButton(Messages.getString("uibk.applets.riemann3d.messages", "PanelPartialDerivates.10"));
        this.zuf\u00e4llig1.setActionCommand("zuf\u00e4llig1");
        this.zuf\u00e4llig1.addActionListener(this);
        this.zuf\u00e4llig1.setToolTipText(Messages.getString("uibk.applets.riemann3d.messages", "PanelPartialDerivates.12"));
        this.oberunter = new JRadioButton(Messages.getString("uibk.applets.riemann3d.messages", "PanelPartialDerivates.22"));
        this.oberunter.setActionCommand("ou");
        this.oberunter.addActionListener(this);
        this.oberunter.setToolTipText(Messages.getString("uibk.applets.riemann3d.messages", "PanelPartialDerivates.24"));
        this.ober = new JRadioButton(Messages.getString("uibk.applets.riemann3d.messages", "PanelPartialDerivates.26"));
        this.ober.setActionCommand("o");
        this.ober.addActionListener(this);
        this.ober.setToolTipText(Messages.getString("uibk.applets.riemann3d.messages", "PanelPartialDerivates.28"));
        this.ober.setEnabled(false);
        this.ober.setSelected(true);
        this.unter = new JRadioButton(Messages.getString("uibk.applets.riemann3d.messages", "PanelPartialDerivates.30"));
        this.unter.setActionCommand("u");
        this.unter.addActionListener(this);
        this.unter.setToolTipText(Messages.getString("uibk.applets.riemann3d.messages", "PanelPartialDerivates.32"));
        this.unter.setEnabled(false);
        this.QuadraturFormel.setSelected(true);
        ButtonGroup groupObenUnten = new ButtonGroup();
        groupObenUnten.add(this.ober);
        groupObenUnten.add(this.unter);
        ButtonGroup groupDerivateOpt = new ButtonGroup();
        groupDerivateOpt.add(this.QuadraturFormel);
        groupDerivateOpt.add(this.zuf\u00e4llig1);
        groupDerivateOpt.add(this.oberunter);
        this.main.panelchoose = new PanelChoose(this.main);
        int n = 1;
        this.labelstep = new JLabel(String.valueOf(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.5")) + n);
        this.labelstep.setFont(this.labelstep.getFont().deriveFont(1));
        int m = 5;
        this.labelgitter = new JLabel(String.valueOf(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.4")) + m + "x" + m);
        this.labelgitter.setFont(this.labelgitter.getFont().deriveFont(1));
        this.sliderStep = new JSlider();
        this.sliderStep.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                int n = slider.getValue();
                PanelPartialDerivates.this.labelstep.setText(String.valueOf(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.23")) + String.valueOf(n));
            }
        });
        this.sliderStep.setMinimum(1);
        this.sliderStep.setMaximum(8);
        this.sliderStep.setValue(1);
        this.slidergitter = new JSlider();
        this.slidergitter.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                int n = slider.getValue();
                PanelPartialDerivates.this.labelgitter.setText(String.valueOf(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.22")) + String.valueOf(n) + "x" + String.valueOf(n));
                PanelPartialDerivates.this.main.riemannvisx.setNumberSubDivisions(n - 1);
                PanelPartialDerivates.this.main.riemannvisy.setNumberSubDivisions(n - 1);
                try {
                    PanelPartialDerivates.this.main.riemannvisx.create();
                    PanelPartialDerivates.this.main.riemannvisy.create();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PanelPartialDerivates.this.main.mathpanel2d.repaint();
            }
        });
        this.slidergitter.setMinimum(2);
        this.slidergitter.setMaximum(20);
        this.slidergitter.setValue(10);
        this.buttonCalc = new JButton(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.26"));
        this.buttonCalc.setActionCommand("compute");
        this.buttonCalc.addActionListener(this);
        this.buttonCalc.setToolTipText(Messages.getString("uibk.applets.riemann3d.messages", "PanelSurface.27"));
        this.add((Component)this.QuadraturFormel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.labelstep, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)this.sliderStep, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 20, 5), 0, 0));
        this.add((Component)this.oberunter, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.ober, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)this.unter, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 20, 5), 0, 0));
        this.add((Component)this.zuf\u00e4llig1, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.zoom, new GridBagConstraints(0, 4, 1, 1, 0.1, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.labelgitter, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)this.slidergitter, new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 20, 5), 0, 0));
        this.add((Component)this.buttonCalc, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.main.mathpanel2d.repaint();
    }
}

