/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.charts;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.Arc2D;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import uibk.mtk.lang.Messages;

public class PieChart
extends JComponent {
    private static final String BUNDLE_NAME = "uibk.mtk.swing.charts.messages";
    DecimalFormat format = new DecimalFormat("0.00 %", new DecimalFormatSymbols(Locale.US));
    String[] labels;
    double[] fractions;
    private Point poslegend = new Point();
    private Point pospie = new Point();
    private int radius;
    int n;
    Color edgecolor = Color.black;
    Color[] colors;

    public PieChart(double[] fractions, String[] labels, Color[] colors) {
        int edge = 20;
        this.setBorder(BorderFactory.createEmptyBorder(edge, edge, edge, edge));
        if (labels != null && fractions != null) {
            this.setFractions(fractions, labels, colors);
        }
    }

    public PieChart() {
        this(null, null, null);
    }

    public void setFractions(double[] fractions, String[] labels, Color[] colors) {
        if (fractions == null || labels == null || fractions.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fractions.length != labels.length) {
            throw new IllegalArgumentException(Messages.getString(BUNDLE_NAME, "PieChart.1"));
        }
        if (colors != null && colors.length != fractions.length) {
            throw new IllegalArgumentException(Messages.getString(BUNDLE_NAME, "PieChart.2"));
        }
        this.n = fractions.length;
        this.fractions = fractions;
        this.labels = labels;
        if (colors == null) {
            this.calccolors();
        } else {
            this.colors = colors;
        }
    }

    public void paint(Graphics g) {
        if (this.fractions == null || this.colors == null || this.labels == null) {
            return;
        }
        this.computepositions();
        Graphics2D g2 = (Graphics2D)g;
        this.drawpie(g2);
        this.drawlegend(g2);
    }

    private void computepositions() {
        Insets insets = this.getInsets();
        int left = insets.left;
        int right = insets.right;
        int top = insets.top;
        int bottom = insets.bottom;
        int piewidth = (this.getWidth() - (left + right + Math.max(left, right))) / 2;
        int height = this.getHeight() - (top + bottom);
        this.radius = Math.min(piewidth, height) / 2;
        this.poslegend.x = left + Math.max(left, right) * 2 + this.radius * 2;
        this.poslegend.y = this.getInsets().left;
        this.pospie.x = insets.left;
        this.pospie.y = insets.top;
    }

    public void drawpie(Graphics2D g2) {
        double phistart = 0.0;
        int i = 0;
        while (i < this.n) {
            double phi = this.fractions[i] * 360.0;
            if (!(phi < 1.0)) {
                this.fillArc(g2, this.pospie.x, this.pospie.y, this.radius * 2, this.radius * 2, phistart, phi, this.colors[i]);
                this.drawEdgeArc(g2, this.pospie.x, this.pospie.y, this.radius * 2, this.radius * 2, phistart, phi, this.edgecolor);
                phistart += phi;
            }
            ++i;
        }
    }

    void calccolors() {
        this.colors = new Color[this.n];
        int i = 0;
        while (i < this.n) {
            int r = (int)(Math.random() * 255.0);
            int g = (int)(Math.random() * 255.0);
            int b = (int)(Math.random() * 255.0);
            this.colors[i] = new Color(r, g, b);
            ++i;
        }
    }

    private void fillArc(Graphics2D g2, double x, double y, double w, double h, double start, double extent, Color color) {
        g2.setColor(color);
        g2.fill(new Arc2D.Double(x, y, w, h, start, extent, 2));
    }

    private void drawEdgeArc(Graphics2D g2, double x, double y, double w, double h, double start, double extent, Color color) {
        g2.setColor(color);
        g2.draw(new Arc2D.Double(x, y, w, h, start, extent, 2));
    }

    private void drawlegend(Graphics2D g2) {
        FontMetrics metrics = g2.getFontMetrics();
        int fontheight = metrics.getHeight();
        int fontdesc = metrics.getDescent();
        int vspace = 5;
        int hspace = 30;
        int i = 0;
        while (i < this.fractions.length) {
            if (this.poslegend.y + fontheight > this.getHeight()) break;
            this.drawSquare(g2, this.colors[i], new Point(this.poslegend.x, this.poslegend.y), fontheight);
            String percent = this.format.format(this.fractions[i]);
            int stringposy = this.poslegend.y + fontheight - fontdesc;
            g2.drawString(String.valueOf(this.labels[i]) + ": " + percent, this.poslegend.x + hspace, stringposy);
            this.poslegend.y += fontheight;
            this.poslegend.y += vspace;
            ++i;
        }
    }

    void drawSquare(Graphics2D g2, Color color, Point pos, int w) {
        g2.setColor(color);
        g2.fillRect(pos.x, pos.y, w, w);
        g2.setColor(Color.black);
        g2.drawRect(pos.x, pos.y, w, w);
    }
}

