/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.objects.DragablePoint2D;
import uibk.mtk.draw2d.objects.MathLine2D;
import uibk.mtk.lang.Dragable;
import uibk.mtk.math.functions.Function1D;

public class FunctionValue2D
extends Drawable2D
implements Dragable {
    protected boolean dragenabled = false;
    protected DragablePoint2D pointAxis = new DragablePoint2D();
    protected DragablePoint2D pointGraph = new DragablePoint2D();
    protected MathLine2D line = new MathLine2D();
    protected Function1D function;

    public void setMathPanel2D(MathPanel2D panel) {
        super.setMathPanel2D(panel);
        this.pointAxis.setMathPanel2D(panel);
        this.pointGraph.setMathPanel2D(panel);
        this.line.setMathPanel2D(panel);
    }

    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        this.pointAxis.draw(framebuffer, g2);
        this.pointGraph.draw(framebuffer, g2);
        this.line.draw(framebuffer, g2);
    }

    public void setPos(double x) {
        this.pointAxis.x = x;
        this.pointGraph.x = x;
        this.pointGraph.setY(this.function.getValue(x));
        this.line.setPoints(this.pointAxis, this.pointGraph);
    }

    public void setFunction(Function1D function) {
        this.function = function;
    }

    public double getPos() {
        return this.pointAxis.x;
    }

    public void setColor(Color color) {
        this.pointAxis.setColor(color);
        this.pointGraph.setColor(color);
        this.line.setColor(color);
    }

    public FunctionValue2D() {
        this.pointAxis.setRadius(2);
        this.pointGraph.setRadius(2);
        this.pointAxis.setContainingRadius(15);
        this.pointGraph.setContainingRadius(15);
    }

    public void setStroke(Stroke stroke) {
        this.line.setStroke(stroke);
    }

    public boolean dragcontains(int x, int y) {
        return this.pointAxis.dragcontains(x, y) || this.pointGraph.dragcontains(x, y);
    }

    public void enabledrag(boolean enable) {
        this.dragenabled = enable;
    }

    public boolean isDragEnabled() {
        return this.dragenabled;
    }

    public void drag(MouseEvent ev) {
        if (!this.dragenabled) {
            return;
        }
        double x = this.scene2d.pixelToX(ev.getX());
        if (x > this.scene2d.getXmax() || x < this.scene2d.getXmin()) {
            return;
        }
        this.pointAxis.x = x;
        this.pointAxis.y = 0.0;
        this.pointGraph.x = this.pointAxis.x;
        this.pointGraph.setY(this.function.getValue(this.pointAxis.x));
        this.line.setPoints(this.pointAxis, this.pointGraph);
    }
}

