/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.regression;

import java.awt.Color;
import java.awt.Component;
import uibk.applets.regression.AppletRegression;
import uibk.applets.regression.PanelRegression;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.parsing.Misc;
import uibk.mtk.math.regression.ErklaerungsAnteil;
import uibk.mtk.math.regression.RegressionCreator;
import uibk.mtk.text.Formatter;

public class Control {
    AppletRegression main;
    PanelRegression panelregression;
    int dependentvarindex;
    int[] independentvarsindex;
    String dependentvar;
    String[] independentvars;
    String[] formfunctions;
    private static Color[] colors = new Color[]{new Color(152, 198, 243), new Color(243, 244, 185), new Color(151, 232, 180), new Color(200, 200, 200), new Color(228, 184, 154), Color.yellow, new Color(196, 194, 117)};

    public Control(AppletRegression main, PanelRegression panelregression) {
        this.main = main;
        this.panelregression = panelregression;
    }

    private boolean getDependentVariable() {
        int k = this.main.table.getColumnCount() - 1;
        String temp = this.panelregression.textDependentVar.getText().trim();
        boolean match = false;
        int i = 1;
        while (i <= k) {
            if (temp.equals("x" + i)) {
                match = true;
                break;
            }
            ++i;
        }
        if (match) {
            this.dependentvar = temp;
            this.dependentvarindex = i;
            return true;
        }
        this.main.mathpanel2d.reportError(String.valueOf(Messages.getString("uibk.applets.regression.messages", "Control.0")) + "x" + "1,..," + "x" + k + Messages.getString("uibk.applets.regression.messages", "Control.2"), (Component)this.main);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getIndependentVariables() {
        String str = this.panelregression.textFormFunctions.getText().trim();
        if (str == null || str.equals("")) {
            this.main.mathpanel2d.reportError(Messages.getString("uibk.applets.regression.messages", "Control.4"), (Component)this.main);
            return false;
        }
        int[] indices = null;
        try {
            indices = Misc.parseVarsIndices(",", "x", str);
            if (indices == null || indices.length == 0) {
                this.main.mathpanel2d.reportError(Messages.getString("uibk.applets.regression.messages", "Control.6"), (Component)this.main);
                return false;
            }
            this.independentvarsindex = indices;
            int j = 0;
            while (j < this.independentvarsindex.length) {
                if (this.independentvarsindex[j] > this.main.table.getColumnCount() - 1 || this.independentvarsindex[j] == 0) {
                    this.main.mathpanel2d.reportError(String.valueOf(Messages.getString("uibk.applets.regression.messages", "Control.7")) + this.independentvarsindex[j], (Component)this.main);
                    return false;
                }
                ++j;
            }
            this.independentvars = new String[indices.length];
            j = 0;
            while (j < indices.length) {
                this.independentvars[j] = "x" + indices[j];
                ++j;
            }
            return true;
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(e, (Component)this.main);
            return false;
        }
    }

    private boolean getFormFunctions() {
        String strfunc = this.panelregression.textFormFunctions.getText();
        if (strfunc == null || strfunc.equals("")) {
            this.main.mathpanel2d.reportError(Messages.getString("uibk.applets.regression.messages", "Control.9"), (Component)this.main);
            return false;
        }
        this.formfunctions = Misc.split(strfunc, ",");
        return true;
    }

    public double[] getDataY() {
        return this.main.table.getDataCol(this.dependentvarindex);
    }

    public double[][] getDataX() {
        return this.main.table.getDataCols(this.independentvarsindex);
    }

    private boolean createRegression() {
        if (!(this.getDependentVariable() && this.getIndependentVariables() && this.getFormFunctions())) {
            return false;
        }
        int i = 0;
        while (i < this.independentvarsindex.length) {
            if (this.independentvarsindex[i] == this.dependentvarindex) {
                this.main.mathpanel2d.reportError(String.valueOf(Messages.getString("uibk.applets.regression.messages", "Control.11")) + this.dependentvar + Messages.getString("uibk.applets.regression.messages", "Control.12"), (Component)this.main);
                return false;
            }
            ++i;
        }
        try {
            this.main.regression = RegressionCreator.create(this.formfunctions, this.independentvars);
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(e, (Component)this.main);
            return false;
        }
        return true;
    }

    private Color[] getPieChartColors(int n) {
        Color[] col = new Color[n + 1];
        col[n] = Color.red;
        int i = 0;
        while (i < n) {
            col[i] = colors[i];
            ++i;
        }
        return col;
    }

    public void compute(boolean withNewPlot, boolean withPopUP) {
        if (this.main.table.isEmpty()) {
            this.main.mathpanel2d.reportError(Messages.getString("uibk.applets.regression.messages", "Control.13"), (Component)this.main);
            return;
        }
        if (this.main.table.getRowCount() < this.main.table.getColumnCount() - 1) {
            this.main.mathpanel2d.reportError(Messages.getString("uibk.applets.regression.messages", "Control.14"), (Component)this.main);
            return;
        }
        if (!this.main.table.isComplete()) {
            this.main.mathpanel2d.reportError(Messages.getString("uibk.applets.regression.messages", "Control.15"), (Component)this.main);
            return;
        }
        if (!this.createRegression()) {
            return;
        }
        try {
            this.main.regression.setDataMatrix(this.getDataX());
            this.main.regression.regress(this.getDataY());
            double[] expl = null;
            if (this.main.regression.getNumberVars() <= 7) {
                this.main.erkl = new ErklaerungsAnteil(this.main.regression);
                this.main.erkl.explain();
                expl = this.main.erkl.getFullExplanation();
            }
            String[] names = this.formfunctions;
            String[] legend = this.append(names, Messages.getString("uibk.applets.regression.messages", "Control.16"));
            Color[] chartcolors = null;
            if (this.main.regression.getNumberVars() <= 7) {
                int n = this.main.regression.getNumberVars();
                chartcolors = this.getPieChartColors(n);
            }
            this.main.paneloutput.createOutput(this.main.regression, expl, legend, chartcolors);
            this.main.paneloutput2.createOutput(this.main.regression, this.formfunctions);
            if (withNewPlot) {
                this.main.command.setPlot(this, this.dependentvarindex, this.independentvarsindex, this.formfunctions);
            }
            Formatter f = new Formatter();
            AppletRegression mainFraim = null;
            if (withPopUP) {
                mainFraim = this.main;
            }
            if (this.main.regression.getNumberVars() <= 7) {
                this.main.mathpanel2d.reportSuccess(String.valueOf(Messages.getString("uibk.applets.regression.messages", "Control.17")) + f.formatplaces(this.main.regression.getrsquare(), 4), mainFraim);
            } else {
                this.main.mathpanel2d.reportSuccess(String.valueOf(Messages.getString("uibk.applets.regression.messages", "Control.18")) + f.formatplaces(this.main.regression.getrsquare(), 4) + Messages.getString("uibk.applets.regression.messages", "Control.19") + 7 + Messages.getString("uibk.applets.regression.messages", "Control.20"), mainFraim);
            }
            this.main.paneloutput.repaint();
            this.main.mathpanel2d.repaint();
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(e, (Component)this.main);
            this.main.paneloutput.clear();
            this.main.paneloutput2.clear();
        }
    }

    private String[] append(String[] a, String item) {
        int n = a.length;
        String[] temp = new String[n + 1];
        System.arraycopy(a, 0, temp, 0, n);
        temp[n] = item;
        return temp;
    }
}

