/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.numberPanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.exception.ExtendedException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.NotANumberException;
import uibk.mtk.math.Rounder;
import uibk.mtk.math.numberPanel.MyNumber;
import uibk.mtk.math.polynom.Polynom;
import uibk.mtk.math.polynom.PolynomException;

public class RationalNumber
extends MyNumber {
    public static final RationalNumber ONE = new RationalNumber(0, null);
    private BigInteger z = null;
    private Polynom zSymbol = null;
    private BigInteger n = null;
    private Polynom nSymbol = null;
    private JLabel labelZ = new JLabel();
    private JLabel labelN = new JLabel();
    private Seperator line;
    private Component parentComponent;
    private int view = 1;

    public RationalNumber(BigInteger z, BigInteger n, int view, Component parentComponent) throws NotANumberException {
        super(3);
        this.parentComponent = parentComponent;
        this.line = new Seperator(parentComponent, this);
        this.setView(view);
        this.setNumerator(z);
        this.setDenominator(n);
    }

    public RationalNumber(long z, long n, int view, Component parentComponent) throws NotANumberException {
        super(3);
        this.parentComponent = parentComponent;
        this.line = new Seperator(parentComponent, this);
        this.setView(view);
        this.setNumerator(z);
        this.setDenominator(n);
    }

    public RationalNumber(Polynom z, Polynom n, int view, Component parentComponent) {
        super(3);
        this.parentComponent = parentComponent;
        this.line = new Seperator(parentComponent, this);
        this.setView(view);
        this.setNumerator(z);
        this.setDenominator(n);
        this.n = null;
        this.z = null;
    }

    public RationalNumber(int view, Component parentComponent) {
        super(3);
        this.parentComponent = parentComponent;
        this.line = new Seperator(parentComponent, this);
        this.setView(view);
        try {
            this.setNumerator(BigInteger.ONE);
            this.setDenominator(BigInteger.ONE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BigInteger getDenominator() {
        return this.n;
    }

    public void setView(int view) {
        if (view != 0 && this.parentComponent == null) {
            throw new IllegalArgumentException("Nur OFF_VIEW zul\u00e4ssig wenn parentComponent=null");
        }
        if (this.view != view) {
            this.view = view;
            this.setLabels();
        }
    }

    public int getView() {
        return this.view;
    }

    public void setDenominator(BigInteger n) throws NotANumberException {
        if (n != null && n.equals(BigInteger.valueOf(0L))) {
            throw new NotANumberException(Messages.getString("uibk.mtk.math.numberPanel.messages", "RatinalNumber.0"), ExceptionLevel.ERROR);
        }
        this.n = n;
        this.nSymbol = null;
        this.cancleDown();
        this.setLabels();
    }

    public void setDenominator(long n) throws NotANumberException {
        this.setDenominator(BigInteger.valueOf(n));
    }

    public void setDenominator(Polynom n) {
        this.nSymbol = n;
        this.n = null;
        this.cancleDown();
        this.setLabels();
    }

    public BigInteger getNumerator() {
        return this.z;
    }

    public void setNumerator(BigInteger z) throws NotANumberException {
        this.z = z;
        this.zSymbol = null;
        this.cancleDown();
        this.setLabels();
    }

    public void setNumerator(long z) throws NotANumberException {
        this.setNumerator(BigInteger.valueOf(z));
    }

    public void setNumerator(Polynom z) {
        this.zSymbol = z;
        this.z = null;
        this.cancleDown();
        this.setLabels();
    }

    protected void setLabels() {
        switch (this.view) {
            case 1: 
            case 4: {
                if (this.zSymbol != null && this.nSymbol != null) {
                    this.labelZ.setText(this.zSymbol.toString());
                    this.labelN.setText(this.nSymbol.toString());
                } else if (this.z != null && this.n != null) {
                    this.labelZ.setText(this.z.toString());
                    this.labelN.setText(this.n.toString());
                } else {
                    this.labelZ.setText("0");
                    this.labelN.setText("1");
                }
                if (this.view == 1 && this.z != null && this.n != null) {
                    this.labelZ.setText(this.z.toString());
                    this.labelN.setText(this.n.toString());
                }
                this.line.setLength();
                break;
            }
            case 2: 
            case 3: {
                if (this.zSymbol != null) {
                    this.labelZ.setText(this.toString());
                    this.labelN.setText("1");
                } else if (this.z != null && this.n != null) {
                    this.labelZ.setText(this.z.toString());
                    this.labelN.setText(this.n.toString());
                } else {
                    this.labelZ.setText("0");
                    this.labelN.setText("1");
                }
                if (this.view == 2 && this.z != null && this.n != null) {
                    Double d = Rounder.roundNumPlacesNext(this.getDoubleValue(), this.commaPlaces);
                    this.labelZ.setText(d.toString());
                    this.labelN.setText("1");
                }
                this.line.setLength();
                break;
            }
            case 0: {
                break;
            }
        }
    }

    public MyNumber add(MyNumber _r) throws NotANumberException, PolynomException {
        if (!(_r instanceof RationalNumber)) {
            throw new NotANumberException("Ung\u00fcltiger Typ", ExceptionLevel.ERROR);
        }
        RationalNumber r = (RationalNumber)_r;
        this.isNumberValid(this);
        this.isNumberValid(r);
        if (r.z != null && r.z.compareTo(BigInteger.ZERO) == 0) {
            return this;
        }
        if (this.z != null && this.z.compareTo(BigInteger.ZERO) == 0) {
            return r;
        }
        if (this.isNumberASymbol(r)) {
            Polynom zS = null;
            Polynom nS = null;
            if (this.isNumberASymbol(this)) {
                zS = r.zSymbol.multiply(this.nSymbol).add(r.nSymbol.multiply(this.zSymbol));
                nS = r.nSymbol.multiply(this.nSymbol);
            } else {
                zS = r.zSymbol.multiply(this.n).add(r.nSymbol.multiply(this.z));
                nS = r.nSymbol.multiply(this.n);
            }
            return new RationalNumber(zS, nS, this.view, this.parentComponent);
        }
        if (this.isNumberASymbol(this)) {
            Polynom zS = this.zSymbol.multiply(r.n).add(this.nSymbol.multiply(r.z));
            Polynom nS = this.nSymbol.multiply(r.n);
            return new RationalNumber(zS, nS, this.view, this.parentComponent);
        }
        BigInteger zZ = this.z.multiply(r.n).add(r.z.multiply(this.n));
        BigInteger nZ = this.n.multiply(r.n);
        return new RationalNumber(zZ, nZ, this.view, this.parentComponent);
    }

    private void isNumberValid(RationalNumber r) throws NotANumberException {
        if (r == null || r.n == null && r.nSymbol == null || r.z == null && r.zSymbol == null) {
            throw new NotANumberException(Messages.getString("uibk.mtk.math.numberPanel.messages", "RatinalNumber.2"), ExceptionLevel.ERROR);
        }
    }

    private boolean isNumberASymbol(RationalNumber r) throws NotANumberException {
        if (r.zSymbol != null) {
            if (r.nSymbol == null) {
                throw new NotANumberException(Messages.getString("uibk.mtk.math.numberPanel.messages", "RatinalNumber.1"), ExceptionLevel.ERROR);
            }
            return true;
        }
        if (r.z == null || r.n == null) {
            throw new NotANumberException(Messages.getString("uibk.mtk.math.numberPanel.messages", "RatinalNumber.1"), ExceptionLevel.ERROR);
        }
        return false;
    }

    public MyNumber sub(MyNumber _r) throws ExtendedException {
        if (!(_r instanceof RationalNumber)) {
            throw new NotANumberException("Ung\u00fcltiger Typ", ExceptionLevel.ERROR);
        }
        RationalNumber r = (RationalNumber)_r;
        RationalNumber rIn = this.isNumberASymbol(r) ? new RationalNumber(r.zSymbol.multiply(new BigInteger("-1")), r.nSymbol, this.view, this.parentComponent) : new RationalNumber(r.z.multiply(BigInteger.valueOf(-1L)), r.n, this.view, this.parentComponent);
        return this.add(rIn);
    }

    public MyNumber mul(MyNumber _r) throws NotANumberException, PolynomException {
        if (!(_r instanceof RationalNumber)) {
            throw new NotANumberException("Ung\u00fcltiger Typ", ExceptionLevel.ERROR);
        }
        RationalNumber r = (RationalNumber)_r;
        this.isNumberValid(this);
        this.isNumberValid(r);
        if (r.z != null && r.z.compareTo(BigInteger.ZERO) == 0 || this.z != null && this.z.compareTo(BigInteger.ZERO) == 0) {
            return new RationalNumber(0L, 1L, this.view, this.parentComponent);
        }
        if (this.isNumberASymbol(r)) {
            if (this.isNumberASymbol(this)) {
                return new RationalNumber(this.zSymbol.multiply(r.zSymbol), this.nSymbol.multiply(r.nSymbol), this.view, this.parentComponent);
            }
            return new RationalNumber(r.zSymbol.multiply(this.z), r.nSymbol.multiply(this.n), this.view, this.parentComponent);
        }
        if (this.isNumberASymbol(this)) {
            RationalNumber ret = new RationalNumber(this.zSymbol.multiply(r.z), this.nSymbol.multiply(r.n), this.view, this.parentComponent);
            return ret;
        }
        return new RationalNumber(this.z.multiply(r.z), this.n.multiply(r.n), this.view, this.parentComponent);
    }

    public MyNumber div(MyNumber _r) throws NotANumberException, PolynomException {
        if (!(_r instanceof RationalNumber)) {
            throw new NotANumberException("Ung\u00fcltiger Typ", ExceptionLevel.ERROR);
        }
        RationalNumber r = (RationalNumber)_r;
        RationalNumber rIn = this.isNumberASymbol(r) ? new RationalNumber(r.nSymbol, r.zSymbol, this.view, this.parentComponent) : new RationalNumber(r.n, r.z, this.view, this.parentComponent);
        return this.mul(rIn);
    }

    public double getDoubleValue() {
        if (this.z != null && this.n != null) {
            Double ret = this.z.doubleValue() / this.n.doubleValue();
            if (ret.equals(Double.NaN)) {
                BigDecimal zD = new BigDecimal(this.z.toString(), MathContext.UNLIMITED);
                BigDecimal nZ = new BigDecimal(this.n.toString(), MathContext.UNLIMITED);
                return zD.divide(nZ, MathContext.DECIMAL128).doubleValue();
            }
            return ret;
        }
        return -1.0;
    }

    public int compareTo(MyNumber r) throws ExtendedException {
        MyNumber _r = this.sub(r);
        if (!(_r instanceof RationalNumber)) {
            throw new NotANumberException("Ung\u00fcltiger Typ", ExceptionLevel.ERROR);
        }
        RationalNumber r2 = (RationalNumber)_r;
        return r2.z.compareTo(BigInteger.ZERO);
    }

    public String toString() {
        String ret = "";
        if (this.z != null && this.n != null) {
            ret = String.valueOf(ret) + this.z.toString();
            if (!this.n.toString().equals("1")) {
                ret = String.valueOf(ret) + "/" + this.n.toString();
            }
        } else if (this.zSymbol != null && this.nSymbol != null) {
            ret = this.nSymbol.toString().equals("1") ? String.valueOf(ret) + this.zSymbol : String.valueOf(ret) + "(" + this.zSymbol + ")/(" + this.nSymbol + ")";
        }
        return ret;
    }

    private void initPanel() {
        if (this.parentComponent != null && this.view != 0) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.labelZ.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
            this.labelZ.setHorizontalAlignment(0);
            this.labelN.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
            this.labelN.setHorizontalAlignment(0);
            this.add((Component)this.labelZ, "North");
            this.add((Component)this.line, "Center");
            this.add((Component)this.labelN, "South");
        }
    }

    private void cancleDown() {
        BigInteger gcd;
        if (this.z != null && this.n != null) {
            gcd = this.z.gcd(this.n);
            this.z = this.z.divide(gcd);
            this.n = this.n.divide(gcd);
            if (this.n.compareTo(BigInteger.ZERO) == -1) {
                this.n = this.n.negate();
                this.z = this.z.negate();
            }
        }
        if (this.zSymbol != null && this.nSymbol != null) {
            gcd = this.zSymbol.getGcd().gcd(this.nSymbol.getGcd());
            this.zSymbol = this.zSymbol.divide(gcd);
            this.nSymbol = this.nSymbol.divide(gcd);
        }
    }

    public MyNumber abs() throws NotANumberException {
        if (this.z != null && this.n != null) {
            if (this.z.compareTo(BigInteger.ZERO) == -1) {
                return new RationalNumber(this.z.negate(), this.n, this.view, this.parentComponent);
            }
            return new RationalNumber(this.z, this.n, this.view, this.parentComponent);
        }
        return new RationalNumber(this.view, this.parentComponent);
    }

    public void setFont(Font f) {
        if (f != null && this.labelN != null && this.labelZ != null) {
            this.labelN.setFont(f);
            this.labelZ.setFont(f);
        }
        this.setLabels();
    }

    public void setBackground(Color c) {
        if (c != null && this.labelN != null && this.labelZ != null) {
            super.setBackground(c);
            this.labelN.setBackground(c);
            this.labelZ.setBackground(c);
        }
        this.setLabels();
    }

    public Component getParentComponent() {
        return this.parentComponent;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
        this.line = new Seperator(parentComponent, this);
    }

    public Polynom getNSymbol() {
        return this.nSymbol;
    }

    public void setNSymbol(Polynom symbol) {
        this.nSymbol = symbol;
    }

    public Polynom getZSymbol() {
        return this.zSymbol;
    }

    public void setZSymbol(Polynom symbol) {
        this.zSymbol = symbol;
    }

    public MyNumber clone() {
        BigInteger zc = null;
        BigInteger nc = null;
        if (this.z != null) {
            zc = new BigInteger(this.z.toByteArray());
        }
        if (this.n != null) {
            nc = new BigInteger(this.n.toByteArray());
        }
        try {
            RationalNumber r = new RationalNumber(zc, nc, this.view, this.parentComponent);
            if (this.zSymbol != null) {
                r.zSymbol = this.zSymbol.clone();
            }
            if (this.nSymbol != null) {
                r.nSymbol = this.nSymbol.clone();
            }
            return r;
        }
        catch (NotANumberException e) {
            return null;
        }
    }

    public boolean isZero() {
        return this.z != null && this.z.compareTo(BigInteger.ZERO) == 0;
    }

    private class Seperator
    extends JPanel {
        private int length = 0;
        private final Component parentComponent;
        private final RationalNumber rationalNumber;

        public Seperator(Component parentComponent, RationalNumber rationalNumber2) {
            this.parentComponent = parentComponent;
            this.rationalNumber = rationalNumber2;
            this.setPreferredSize(new Dimension(0, 4));
        }

        public void paint(Graphics g) {
            if (RationalNumber.this.view == 1) {
                double width = RationalNumber.this.labelZ.getSize().getWidth();
                double len = this.length;
                int x1 = (int)(width / 2.0 - len / 2.0);
                int x2 = (int)(width / 2.0 + len / 2.0);
                if (x1 < 0) {
                    x1 = 0;
                    x2 = this.length;
                }
                g.drawLine(x1, 1, x2, 1);
            }
        }

        public void setLength() {
            if (this.parentComponent == null) {
                return;
            }
            Graphics g = this.parentComponent.getGraphics();
            if (g == null) {
                return;
            }
            FontMetrics metrics = g.getFontMetrics(RationalNumber.this.labelN.getFont());
            int l = 0;
            if (RationalNumber.this.labelZ != null) {
                l = metrics.stringWidth(RationalNumber.this.labelZ.getText());
            }
            if (RationalNumber.this.labelN != null) {
                int l2 = metrics.stringWidth(RationalNumber.this.labelN.getText());
                l = l > l2 ? l : l2;
            }
            this.length = l + 5;
            this.paint(g);
            int height = metrics.getHeight() + 6;
            if (RationalNumber.this.view == 1 || RationalNumber.this.view == 4) {
                height = metrics.getHeight() * 2 + 12;
            }
            this.rationalNumber.setMaximumSize(new Dimension(this.length + 10, height));
            this.rationalNumber.setMinimumSize(new Dimension(this.length + 10, height));
            this.rationalNumber.setPreferredSize(new Dimension(this.length + 10, height));
            if (RationalNumber.this.labelN != null && RationalNumber.this.labelN.getText().equals("1")) {
                this.rationalNumber.removeAll();
                this.rationalNumber.add((Component)RationalNumber.this.labelZ, "Center");
            } else {
                this.rationalNumber.initPanel();
            }
        }
    }
}

