/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.numberPanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.exception.ExtendedException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.NotANumberException;
import uibk.mtk.math.numberPanel.MatrixEvent;
import uibk.mtk.math.numberPanel.MatrixException;
import uibk.mtk.math.numberPanel.MatrixUtil;
import uibk.mtk.math.numberPanel.MyNumber;
import uibk.mtk.math.numberPanel.RationalMatrixListener;
import uibk.mtk.swing.base.MPanel;

public class MatrixPanel
extends MPanel {
    static final String BUNDLE_NAME = "uibk.mtk.math.numberPanel.messages";
    protected MyNumber[][] data;
    private MPanel[][] panels;
    private MPanel[] columns;
    protected int rowDim = 0;
    protected int columnDim = 0;
    protected int view = -1;
    protected int precision = 3;
    int indexPivot = 0;
    protected MatrixPanel x = null;
    protected MatrixPanel b = null;
    int nullRows = -1;
    protected boolean isSolved = false;
    private Vector<RationalMatrixListener> listener = new Vector();

    public MatrixPanel(MyNumber[][] data) throws ExtendedException {
        if (data == null || data[0] == null || data[0][0] == null) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.0"), ExceptionLevel.ERROR);
        }
        this.data = data;
        this.rowDim = data.length;
        this.columnDim = data[0].length;
        this.view = data[0][0].getView();
        this.initPanels();
        this.intAlgorithm();
    }

    public MatrixPanel(int rowDimension, int columnDimension) throws ExtendedException {
        if (rowDimension < 1 || columnDimension < 1) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.1"), ExceptionLevel.ERROR);
        }
        this.data = new MyNumber[rowDimension][columnDimension];
        this.rowDim = rowDimension;
        this.columnDim = columnDimension;
        this.view = -1;
        this.initPanels();
        this.intAlgorithm();
    }

    protected void intAlgorithm() throws ExtendedException {
        this.indexPivot = 0;
        this.isSolved = false;
        this.nullRows = -1;
        this.x = null;
        this.b = null;
    }

    private void initPanels() {
        this.setLayout(new BoxLayout(this, 0));
        this.panels = new MPanel[this.rowDim][this.columnDim];
        this.columns = new MPanel[this.columnDim];
        int j = 0;
        while (j < this.columnDim) {
            this.columns[j] = new MPanel();
            this.columns[j].setLayout(new BoxLayout(this.columns[j], 1));
            this.add(this.columns[j]);
            int i = 0;
            while (i < this.rowDim) {
                this.panels[i][j] = new MPanel();
                this.panels[i][j].setLayout(new BorderLayout());
                this.panels[i][j].setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                if (this.data[i][j] != null) {
                    this.panels[i][j].add((Component)this.data[i][j], "Center");
                }
                this.columns[j].add(this.panels[i][j]);
                ++i;
            }
            ++j;
        }
    }

    public void setValueAt(int row, int column, MyNumber r) throws ExtendedException {
        this.setValueAtIntern(row, column, r);
        this.intAlgorithm();
        for (RationalMatrixListener rml : this.listener) {
            rml.valueSet(new MatrixEvent(this, this, row, column));
        }
    }

    public void setValueAtIntern(int row, int column, MyNumber r) throws ExtendedException {
        if (r == null || row >= this.rowDim || column >= this.columnDim) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.2"), ExceptionLevel.ERROR);
        }
        r.setFont(this.getFont());
        r.setBackground(this.getBackground());
        this.data[row][column] = r;
        this.panels[row][column].removeAll();
        this.panels[row][column].add((Component)this.data[row][column], "Center");
        if (this.view == -1) {
            this.view = r.getView();
        } else if (this.view != r.getView()) {
            r.setView(this.view);
        }
        r.setPrecision(this.precision);
    }

    public void setValueAtInternKeepView(int row, int column, MyNumber r) throws ExtendedException {
        if (r == null || row >= this.rowDim || column >= this.columnDim) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.2"), ExceptionLevel.ERROR);
        }
        r.setFont(this.getFont());
        r.setBackground(this.getBackground());
        this.data[row][column] = r;
        this.panels[row][column].removeAll();
        this.panels[row][column].add((Component)this.data[row][column], "Center");
        if (this.view == -1) {
            this.view = r.getView();
        }
        r.setPrecision(this.precision);
    }

    public MyNumber getVauleAt(int row, int column) throws MatrixException {
        if (row >= this.rowDim || column >= this.columnDim || this.data[row][column] == null) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.2"), ExceptionLevel.ERROR);
        }
        return this.data[row][column];
    }

    public void changeRows(int row1, int row2) throws ExtendedException {
        this.changeRowsIntern(row1, row2);
        this.intAlgorithm();
    }

    protected void changeRowsIntern(int row1, int row2) throws ExtendedException {
        if (row1 == row2 || row1 < 0 || row2 < 0) {
            return;
        }
        if (row1 >= this.rowDim || row2 >= this.rowDim) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.2"), ExceptionLevel.ERROR);
        }
        int i = 0;
        while (i < this.columnDim) {
            MyNumber tmp = this.data[row1][i];
            this.setValueAtIntern(row1, i, this.data[row2][i]);
            this.setValueAtIntern(row2, i, tmp);
            ++i;
        }
    }

    public void changeColumns(int col1, int col2) throws ExtendedException {
        this.changeColumnsIntern(col1, col2);
        this.intAlgorithm();
    }

    protected void changeColumnsIntern(int col1, int col2) throws ExtendedException {
        if (col1 == col2 || col1 < 0 || col2 < 0) {
            return;
        }
        if (col1 >= this.rowDim || col1 >= this.rowDim) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.2"), ExceptionLevel.ERROR);
        }
        int i = 0;
        while (i < this.rowDim) {
            MyNumber tmp = this.data[i][col1];
            this.setValueAtIntern(i, col1, this.data[i][col2]);
            this.setValueAtIntern(i, col2, tmp);
            ++i;
        }
    }

    public MatrixPanel subIntern(int row1, int row2, MyNumber t) throws ExtendedException {
        if (row1 >= this.rowDim || row2 >= this.rowDim) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.2"), ExceptionLevel.ERROR);
        }
        int i = 0;
        while (i < this.columnDim) {
            this.setValueAtIntern(row2, i, this.data[row2][i].sub(t.mul(this.data[row1][i])));
            ++i;
        }
        this.isSolved = false;
        return this;
    }

    public synchronized void setView(int view) throws ExtendedException {
        if (this.view != view) {
            int i = 0;
            while (i < this.rowDim) {
                int j = 0;
                while (j < this.columnDim) {
                    if (this.data[i][j] != null) {
                        this.data[i][j].setView(view);
                    }
                    ++j;
                }
                ++i;
            }
            this.view = view;
        }
    }

    public int getView() {
        return this.view;
    }

    public int[] setBorder(int xCoordinate, int yCoordinate, Color c) {
        int[] ret = new int[]{-1, -1};
        if (c == null) {
            c = Color.black;
        }
        if (this.columns == null || this.panels == null || this.panels[0] == null || this.panels[0][0] == null) {
            return ret;
        }
        int i = 0;
        while (i < this.rowDim) {
            int j = 0;
            while (j < this.columnDim) {
                int width = this.panels[i][j].getWidth();
                int height = this.panels[i][j].getHeight();
                Point p = this.panels[i][j].getLocation();
                p.x = this.columns[j].getLocation().x;
                if (xCoordinate > p.x && xCoordinate < p.x + width && yCoordinate > p.y && yCoordinate < p.y + height) {
                    this.panels[i][j].setBorder(BorderFactory.createLineBorder(c));
                    ret[0] = i;
                    ret[1] = j;
                } else {
                    this.panels[i][j].setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public int[] setBorderByIndex(int rowIndex, int columnIndex, int width, Color c) {
        int[] ret = new int[]{-1, -1};
        if (c == null) {
            c = Color.black;
        }
        int i = 0;
        while (i < this.rowDim) {
            int j = 0;
            while (j < this.columnDim) {
                if (rowIndex == i && columnIndex == j) {
                    this.panels[i][j].setBorder(BorderFactory.createLineBorder(c));
                    ret[0] = i;
                    ret[1] = j;
                } else {
                    this.panels[i][j].setBorder(BorderFactory.createEmptyBorder(width, width, width, width));
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public int[] setBorderByIndex(int rowIndex, int columnIndex, Color c) {
        return this.setBorderByIndex(rowIndex, columnIndex, 1, c);
    }

    public void setColumnBorder(int columnIndex, int startRowIndex, int endRowIndex, Color c) {
        if (c == null) {
            c = Color.black;
        }
        int i = 0;
        while (i < this.rowDim) {
            int j = 0;
            while (j < this.columnDim) {
                if (startRowIndex < i && endRowIndex - 1 > i && columnIndex == j) {
                    this.panels[i][j].setBorder(BorderFactory.createMatteBorder(0, 1, 0, 1, c));
                } else if (startRowIndex <= i && endRowIndex - 1 > i && columnIndex == j) {
                    this.panels[i][j].setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, c));
                } else if (startRowIndex < i && endRowIndex - 1 >= i && columnIndex == j) {
                    this.panels[i][j].setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, c));
                } else if (startRowIndex <= i && endRowIndex - 1 >= i && columnIndex == j) {
                    this.panels[i][j].setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, c));
                }
                ++j;
            }
            ++i;
        }
    }

    public void setRowBorder(int rowIndex, int startColumnIndex, int endColumnIndex, Color c) {
        if (c == null) {
            c = Color.black;
        }
        int i = 0;
        while (i < this.rowDim) {
            int j = 0;
            while (j < this.columnDim) {
                if (startColumnIndex < j && endColumnIndex - 1 > j && rowIndex == i) {
                    this.panels[i][j].setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, c));
                } else if (startColumnIndex <= j && endColumnIndex - 1 > j && rowIndex == i) {
                    this.panels[i][j].setBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, c));
                } else if (startColumnIndex < j && endColumnIndex - 1 >= j && rowIndex == i) {
                    this.panels[i][j].setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, c));
                } else if (startColumnIndex <= j && endColumnIndex - 1 >= j && rowIndex == i) {
                    this.panels[i][j].setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, c));
                }
                ++j;
            }
            ++i;
        }
    }

    public void setBorder(int startRowIndex, int endRowIndex, int startColumnIndex, int endColumnIndex, Color c) {
        if (c == null) {
            c = Color.black;
        }
        if (startRowIndex > endRowIndex - 1 || startColumnIndex > endColumnIndex - 1) {
            return;
        }
        if (startRowIndex == endRowIndex - 1) {
            this.setRowBorder(startRowIndex, startColumnIndex, endColumnIndex, c);
            return;
        }
        if (startColumnIndex == endColumnIndex - 1) {
            this.setColumnBorder(startColumnIndex, startRowIndex, endRowIndex, c);
            return;
        }
        int i = 0;
        while (i < this.rowDim) {
            int j = 0;
            while (j < this.columnDim) {
                int top = 0;
                int left = 0;
                int bottom = 0;
                int right = 0;
                if (startRowIndex == i && startColumnIndex <= j && endColumnIndex - 1 >= j) {
                    top = 1;
                } else if (endRowIndex - 1 == i && startColumnIndex <= j && endColumnIndex - 1 >= j) {
                    bottom = 1;
                }
                if (startColumnIndex == j && startRowIndex <= i && endRowIndex - 1 >= i) {
                    left = 1;
                } else if (endColumnIndex - 1 == j && startRowIndex <= i && endRowIndex - 1 >= i) {
                    right = 1;
                }
                if (top + bottom + left + right != 0) {
                    this.panels[i][j].setBorder(BorderFactory.createMatteBorder(top, left, bottom, right, c));
                }
                ++j;
            }
            ++i;
        }
    }

    public int[] indexMaxValueAbs() throws ExtendedException {
        return this.indexMaxValueAbs(0, 0, false);
    }

    public int[] indexMaxValueAbs(int initRowIndex, int initColumnIndex, boolean searchOneColumn) throws ExtendedException {
        int[] ret = new int[]{-1, -1};
        if (this.data == null || this.data[0] == null || this.data[0][0] == null) {
            return ret;
        }
        if (initRowIndex >= this.rowDim || initColumnIndex >= this.columnDim) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.2"), ExceptionLevel.ERROR);
        }
        int cD = this.columnDim;
        if (searchOneColumn) {
            cD = initColumnIndex + 1;
        }
        MyNumber max = null;
        int i = initRowIndex;
        while (i < this.rowDim) {
            int j = initColumnIndex;
            while (j < cD) {
                if (this.data[i][j] != null) {
                    if (max == null) {
                        max = this.data[i][j].abs();
                        ret[0] = i;
                        ret[1] = j;
                    } else if (this.data[i][j].abs().compareTo(max) == 1) {
                        max = this.data[i][j].abs();
                        ret[0] = i;
                        ret[1] = j;
                    }
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public int getColumnDim() {
        return this.columnDim;
    }

    public int getRowDim() {
        return this.rowDim;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        if (c != null && this.data != null) {
            int i = 0;
            while (i < this.rowDim) {
                int j = 0;
                while (j < this.columnDim) {
                    if (this.data[i][j] != null) {
                        this.data[i][j].setBackground(c);
                    }
                    this.panels[i][j].setBackground(c);
                    ++j;
                }
                ++i;
            }
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
        if (f != null && this.data != null) {
            MyNumber[][] myNumberArray = this.data;
            int n = this.data.length;
            int n2 = 0;
            while (n2 < n) {
                MyNumber[] row = myNumberArray[n2];
                if (row != null) {
                    MyNumber[] myNumberArray2 = row;
                    int n3 = row.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        MyNumber r = myNumberArray2[n4];
                        if (r != null) {
                            r.setFont(f);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public String toString() {
        String s = "";
        MyNumber[][] myNumberArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            MyNumber[] row;
            MyNumber[] myNumberArray2 = row = myNumberArray[n2];
            int n3 = row.length;
            int n4 = 0;
            while (n4 < n3) {
                MyNumber r = myNumberArray2[n4];
                if (r != null) {
                    s = String.valueOf(s) + r.toString() + "  ";
                }
                ++n4;
            }
            s = String.valueOf(s) + "\n";
            ++n2;
        }
        return s;
    }

    public boolean isSolved() {
        return this.isSolved;
    }

    public void setSolved(boolean b) {
        this.isSolved = b;
    }

    protected MatrixPanel setMatrixToIdentity(MatrixPanel m) throws ExtendedException {
        if (m == null) {
            return null;
        }
        Class<?> cl = this.getVauleAt(0, 0).getClass();
        int i = 0;
        while (i < m.rowDim) {
            int j = 0;
            while (j < m.columnDim) {
                try {
                    MyNumber r = i == j ? MyNumber.getNumber(cl, 1.0, 1, m.getView(), this, m.getPrecision()) : MyNumber.getNumber(cl, 0.0, 1, m.getView(), this, m.getPrecision());
                    m.setValueAtIntern(i, j, r);
                }
                catch (NotANumberException e) {
                    e.printStackTrace();
                }
                catch (MatrixException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        return m;
    }

    public MatrixPanel initXMatrix(MatrixPanel b) throws ExtendedException {
        if (b == null) {
            return null;
        }
        MatrixPanel x = new MatrixPanel(this.columnDim, b.columnDim);
        return x;
    }

    public void setIndexPivot(int indexPivot) {
        this.indexPivot = indexPivot;
    }

    public int getIndexPivot() {
        return this.indexPivot;
    }

    public MatrixPanel clone() {
        try {
            int j;
            MyNumber[][] data = new MyNumber[this.rowDim][this.columnDim];
            int i = 0;
            while (i < this.rowDim) {
                int j2 = 0;
                while (j2 < this.columnDim) {
                    data[i][j2] = this.getVauleAt(i, j2).clone();
                    ++j2;
                }
                ++i;
            }
            MatrixPanel r = new MatrixPanel(data);
            r.indexPivot = this.indexPivot;
            if (this.b != null) {
                MatrixPanel bneu;
                data = new MyNumber[this.b.rowDim][this.b.columnDim];
                int i2 = 0;
                while (i2 < this.b.rowDim) {
                    j = 0;
                    while (j < this.b.columnDim) {
                        data[i2][j] = this.b.getVauleAt(i2, j).clone();
                        ++j;
                    }
                    ++i2;
                }
                r.b = bneu = new MatrixPanel(data);
            }
            if (this.x != null) {
                MatrixPanel xNeu;
                data = new MyNumber[this.x.rowDim][this.x.columnDim];
                int i3 = 0;
                while (i3 < this.x.rowDim) {
                    j = 0;
                    while (j < this.x.columnDim) {
                        data[i3][j] = this.x.getVauleAt(i3, j).clone();
                        ++j;
                    }
                    ++i3;
                }
                r.x = xNeu = new MatrixPanel(data);
            }
            r.nullRows = this.nullRows;
            r.isSolved = this.isSolved;
            r.setPrecision(this.precision);
            return r;
        }
        catch (ExtendedException e) {
            return null;
        }
    }

    public void addRationalMatrixListener(RationalMatrixListener rml) {
        this.listener.add(rml);
    }

    public void removeRationalMatrixListener(RationalMatrixListener rml) {
        this.listener.remove(rml);
    }

    public void add(MyNumber t, MatrixPanel m2) throws ExtendedException {
        if (this.columnDim != m2.columnDim || this.rowDim != m2.rowDim) {
            throw new MatrixException("Ung\u00fcltige Dimensionen", ExceptionLevel.ERROR);
        }
        int i = 0;
        while (i < this.rowDim) {
            int j = 0;
            while (j < this.columnDim) {
                this.data[i][j].add(m2.data[i][j].mul(t));
                ++j;
            }
            ++i;
        }
    }

    public double norm2() throws ExtendedException {
        if (this.columnDim != 1 || this.rowDim != 1) {
            throw new MatrixException("Nur implementiert f\u00fcr Vektoren", ExceptionLevel.ERROR);
        }
        double norm2 = 0.0;
        int i = 0;
        while (i < this.rowDim) {
            int j = 0;
            while (j < this.columnDim) {
                norm2 += this.data[i][j].getDoubleValue() * this.data[i][j].getDoubleValue();
                ++j;
            }
            ++i;
        }
        return Math.sqrt(norm2);
    }

    public void mulLeft(MatrixPanel m2) throws ExtendedException {
        if (this.rowDim != m2.rowDim) {
            throw new MatrixException("Ung\u00fcltige Dimensionen", ExceptionLevel.ERROR);
        }
        MatrixPanel m = MatrixUtil.mul(m2, this);
        int i = 0;
        while (i < this.rowDim) {
            int j = 0;
            while (j < this.columnDim) {
                this.setValueAtIntern(i, j, m.getVauleAt(i, j));
                ++j;
            }
            ++i;
        }
    }

    public MatrixPanel mul(MatrixPanel m2) throws ExtendedException {
        if (this.columnDim != m2.columnDim) {
            throw new MatrixException("Ung\u00fcltige Dimensionen", ExceptionLevel.ERROR);
        }
        MatrixPanel m = MatrixUtil.mul(this, m2);
        int i = 0;
        while (i < this.rowDim) {
            int j = 0;
            while (j < this.columnDim) {
                this.setValueAtIntern(i, j, m.getVauleAt(i, j));
                ++j;
            }
            ++i;
        }
        return this;
    }

    public synchronized void setPrecision(int i) {
        this.precision = i;
        MyNumber[][] myNumberArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            MyNumber[] nn;
            MyNumber[] myNumberArray2 = nn = myNumberArray[n2];
            int n3 = nn.length;
            int n4 = 0;
            while (n4 < n3) {
                MyNumber n5 = myNumberArray2[n4];
                if (n5 != null) {
                    n5.setPrecision(i);
                }
                ++n4;
            }
            ++n2;
        }
        if (this.x != null) {
            this.x.setPrecision(i);
        }
        if (this.b != null) {
            this.b.setPrecision(i);
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    public MatrixPanel getSubMatrix(int row1, int row2, int column1, int column2) throws ExtendedException {
        if (row2 < row1 || column2 < column1) {
            throw new MatrixException("Ung\u00fcltige Dimension", ExceptionLevel.ERROR);
        }
        if (row1 < 0 || row2 > this.rowDim) {
            throw new MatrixException("Ung\u00fcltige Dimension", ExceptionLevel.ERROR);
        }
        if (column1 < 0 || column2 > this.columnDim) {
            throw new MatrixException("Ung\u00fcltige Dimension", ExceptionLevel.ERROR);
        }
        MatrixPanel ret = new MatrixPanel(row2 - row1, column2 - column1);
        int i = row1;
        while (i < row2) {
            int j = column1;
            while (j < column2) {
                ret.setValueAt(i - row1, j - column1, this.getVauleAt(i, j).clone());
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public MatrixPanel addMatrix(MatrixPanel m) throws ExtendedException {
        if (m.getRowDim() != this.rowDim || m.getColumnDim() != this.columnDim) {
            throw new MatrixException("Ung\u00fcltige Dimension von m", ExceptionLevel.ERROR);
        }
        int i = 0;
        while (i < this.rowDim) {
            int j = 0;
            while (j < this.columnDim) {
                this.setValueAt(i, j, this.getVauleAt(i, j).add(m.getVauleAt(i, j)));
                ++j;
            }
            ++i;
        }
        return this;
    }

    public MatrixPanel subMatrix(MatrixPanel m) throws ExtendedException {
        if (m.getRowDim() != this.rowDim || m.getColumnDim() != this.columnDim) {
            throw new MatrixException("Ung\u00fcltige Dimension von m", ExceptionLevel.ERROR);
        }
        int i = 0;
        while (i < this.rowDim) {
            int j = 0;
            while (j < this.columnDim) {
                this.setValueAt(i, j, this.getVauleAt(i, j).sub(m.getVauleAt(i, j)));
                ++j;
            }
            ++i;
        }
        return this;
    }

    public void mulSubLeft(MatrixPanel m2, int row) throws ExtendedException {
        if (this.columnDim != m2.columnDim || this.rowDim != m2.rowDim) {
            throw new MatrixException("Ung\u00fcltige Dimensionen", ExceptionLevel.ERROR);
        }
        MatrixPanel m = MatrixUtil.partMul(m2, this, row);
        int i = row;
        while (i < this.rowDim) {
            int j = row;
            while (j < this.columnDim) {
                this.setValueAt(i, j, m.getVauleAt(i, j));
                ++j;
            }
            ++i;
        }
    }
}

