/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.QRAlgorithmus;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import uibk.applets.QRAlgorithmus.AppletQRAlgorithmus;
import uibk.mtk.exception.ExtendedException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.numberPanel.MatrixEvent;
import uibk.mtk.math.numberPanel.MatrixPanelQR;
import uibk.mtk.math.numberPanel.RationalMatrixListener;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TitledPanel;

public class PanelMatrixParameter
extends MPanel
implements RationalMatrixListener {
    private final AppletQRAlgorithmus main;
    private TitledPanel panelDim;
    private TitledPanel panelRank;

    public PanelMatrixParameter(AppletQRAlgorithmus main) {
        this.main = main;
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.dimensionPanel());
        this.add(this.rankPanel());
        this.add(Box.createHorizontalGlue());
    }

    private TitledPanel dimensionPanel() {
        this.panelDim = new TitledPanel(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelKenngroessen.0"));
        this.panelDim.setLayout(new BorderLayout());
        this.panelDim.setMaximumSize(new Dimension(10000, 50));
        return this.panelDim;
    }

    private TitledPanel rankPanel() {
        this.panelRank = new TitledPanel(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelKenngroessen.2"));
        this.panelRank.setLayout(new BorderLayout());
        this.panelRank.setMaximumSize(new Dimension(10000, 50));
        return this.panelRank;
    }

    public void setMatrixParameter(MatrixPanelQR A) {
        this.panelDim.removeAll();
        this.panelRank.removeAll();
        if (A == null) {
            return;
        }
        this.panelDim.add(new JLabel(String.valueOf(A.getRowDim()) + "x" + A.getColumnDim()));
        try {
            this.panelRank.add(new JLabel(String.valueOf(A.getRank())));
        }
        catch (ExtendedException e) {
            this.panelRank.add(new JLabel(e.getMessage()));
        }
    }

    public void valueSet(MatrixEvent ev) {
        try {
            this.setMatrixParameter((MatrixPanelQR)ev.getM());
        }
        catch (Exception e) {
            this.main.report.reportException(null, e, this.main);
        }
    }
}

