/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.QRAlgorithmus;

import java.awt.Component;
import java.net.URL;
import javax.swing.JLabel;
import uibk.applets.QRAlgorithmus.AppletQRAlgorithmus;
import uibk.applets.QRAlgorithmus.PanelControl;
import uibk.applets.QRAlgorithmus.PanelMain;
import uibk.applets.QRAlgorithmus.PanelMatrixParameter;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.exception.ExtendedException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.numberPanel.IrrationalNumber;
import uibk.mtk.math.numberPanel.MatrixException;
import uibk.mtk.math.numberPanel.MatrixPanel;
import uibk.mtk.math.numberPanel.MatrixUtil;
import uibk.mtk.math.numberPanel.MyNumber;
import uibk.mtk.swing.base.MPanel;

public class PanelMainGLS
extends PanelMain {
    public PanelMainGLS(AppletQRAlgorithmus main, PanelControl panelControl, PanelMatrixParameter panelParameter) {
        super(main, panelControl, panelParameter);
    }

    public synchronized void initGLS(int step) throws ExtendedException {
        this.initPanels();
        this.A.removeMouseMotionListener(this.mouseEvents);
        this.A.removeMouseListener(this.mouseEvents);
        if (this.b != null) {
            this.b.removeMouseMotionListener(this.mouseEvents);
            this.b.removeMouseListener(this.mouseEvents);
        }
        this.step = step;
        MPanel[] mPanelArray = this.panels;
        int n = this.panels.length;
        int n2 = 0;
        while (n2 < n) {
            MPanel p = mPanelArray[n2];
            p.removeAll();
            ++n2;
        }
        this.A.setFont(AppletQRAlgorithmus.FONT);
        this.A.setBackground(AppletQRAlgorithmus.COLOR_NO_EDIT);
        this.A.setBorderByIndex(-1, -1, 0, null);
        if (this.x != null) {
            this.x.setFont(AppletQRAlgorithmus.FONT);
            this.x.setBackground(AppletQRAlgorithmus.COLOR_NO_EDIT);
        }
        if (this.b != null) {
            this.b.setFont(AppletQRAlgorithmus.FONT);
            this.b.setBackground(AppletQRAlgorithmus.COLOR_NO_EDIT);
            if (this.history.size() == 1) {
                this.b.setBackground(AppletQRAlgorithmus.COLOR_EDIT);
                this.b.addMouseListener(this.mouseEvents);
                this.b.addMouseMotionListener(this.mouseEvents);
            }
        }
        this.A.getQ().setFont(AppletQRAlgorithmus.FONT);
        this.A.getQ().setBackground(AppletQRAlgorithmus.COLOR_NO_EDIT);
        if (this.A.getP() != null) {
            this.A.getP().setFont(AppletQRAlgorithmus.FONT);
            this.A.getP().setBackground(AppletQRAlgorithmus.COLOR_NO_EDIT);
        }
        if (this.Qt != null) {
            this.Qt.setFont(AppletQRAlgorithmus.FONT);
            this.Qt.setBackground(AppletQRAlgorithmus.COLOR_NO_EDIT);
        }
        switch (step) {
            case 0: {
                this.A.addMouseListener(this.mouseEvents);
                this.A.addMouseMotionListener(this.mouseEvents);
                this.A.setBackground(AppletQRAlgorithmus.COLOR_EDIT);
                this.A.setBorderByIndex(-1, -1, 1, null);
                this.panels[4].add(this.A);
                if (this.x == null || this.b == null) break;
                this.panels[5].add(new JLabel("*"));
                this.panels[6].add(this.x);
                this.panels[7].add(new JLabel("="));
                this.panels[8].add(this.b);
                break;
            }
            case 1: {
                this.panels[0].add(this.A.getQ());
                this.panels[1].add(new JLabel("*"));
                this.panels[2].add(this.A);
                this.panels[3].add(new JLabel("*"));
                this.panels[4].add(this.A.getP());
                this.A.setBorder(0, this.A.getRank(), 0, this.A.getRank(), AppletQRAlgorithmus.COLOR_R1);
                this.A.setBorder(0, this.A.getRank(), this.A.getRank(), this.A.getColumnDim(), AppletQRAlgorithmus.COLOR_R2);
                if (this.x == null || this.b == null) break;
                this.panels[5].add(new JLabel("*"));
                this.panels[6].add(this.x);
                this.panels[7].add(new JLabel("="));
                this.panels[8].add(this.b);
                break;
            }
            case 2: {
                if (this.b != null && this.x != null) {
                    this.Qt = MatrixUtil.transpose(this.A.getQ());
                    this.Qt.setFont(AppletQRAlgorithmus.FONT);
                    this.Qt.setBackground(AppletQRAlgorithmus.COLOR_NO_EDIT);
                    this.A.setBorder(0, this.A.getRank(), 0, this.A.getRank(), AppletQRAlgorithmus.COLOR_R1);
                    this.A.setBorder(0, this.A.getRank(), this.A.getRank(), this.A.getColumnDim(), AppletQRAlgorithmus.COLOR_R2);
                    this.panels[0].add(this.A);
                    this.panels[1].add(new JLabel("*"));
                    this.panels[2].add(this.A.getP());
                    this.panels[3].add(new JLabel("*"));
                    this.panels[4].add(this.x);
                    this.panels[5].add(new JLabel("="));
                    this.panels[6].add(this.Qt);
                    this.panels[7].add(new JLabel("*"));
                    this.panels[8].add(this.b);
                    break;
                }
            }
            case 3: {
                if (this.b != null && this.x != null) {
                    this.A.setBorder(0, this.A.getRank(), 0, this.A.getRank(), AppletQRAlgorithmus.COLOR_R1);
                    this.A.setBorder(0, this.A.getRank(), this.A.getRank(), this.A.getColumnDim(), AppletQRAlgorithmus.COLOR_R2);
                    this.panels[0].add(this.A);
                    this.panels[1].add(new JLabel("*"));
                    this.panels[2].add(this.A.getP());
                    this.panels[3].add(new JLabel("*"));
                    this.panels[4].add(this.x);
                    this.panels[5].add(new JLabel("="));
                    this.panels[6].add(this.b);
                    break;
                }
            }
            case 4: {
                if (this.b != null && this.x != null) {
                    this.panels[0].add(this.A.getP());
                    this.panels[1].add(new JLabel("*"));
                    this.panels[2].add(this.x);
                    this.panels[3].add(new JLabel("="));
                    this.panels[4].add(this.b);
                    break;
                }
            }
            case 5: {
                this.A.setBackground(AppletQRAlgorithmus.COLOR_NO_EDIT);
                this.A.removeMouseListener(this.mouseEvents);
                this.A.removeMouseMotionListener(this.mouseEvents);
                if (this.b == null || this.x == null) break;
                this.panels[2].add(this.x);
                this.panels[3].add(new JLabel("="));
                this.panels[4].add(this.b);
                break;
            }
        }
        this.main.setMainPanel();
    }

    protected void qrStepImpl(int[] ij) throws ExtendedException {
        this.A.qrAlgorithmus();
        this.initGLS(this.step);
    }

    protected void addSteppToHistory(int step) throws ExtendedException {
        this.R.getP().setBackground(AppletQRAlgorithmus.COLOR_HISTORY);
        this.R.getP().setFont(AppletQRAlgorithmus.FONT_HISTORY);
        super.addSteppToHistory(step);
    }

    protected void removeStepFromHistoryImpl() {
    }

    protected void newGLSImpl() {
        this.A.addRationalMatrixListener(this.panelParameter);
    }

    protected void solveStep() throws ExtendedException {
        if (this.A == null) {
            return;
        }
        if (this.b == null) {
            throw new MatrixException(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelMain.20"), ExceptionLevel.INFO);
        }
        if (this.A.getRank() == 0) {
            throw new MatrixException(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelMain.22"), ExceptionLevel.INFO);
        }
        if (this.A.isQR() && this.step < 1) {
            this.step = 1;
        }
        try {
            try {
                ++this.step;
                switch (this.step) {
                    case 2: {
                        this.addSteppToHistory(this.step);
                        break;
                    }
                    case 3: {
                        this.addSteppToHistory(this.step);
                        ((PanelMain.History)this.history.lastElement()).b = this.b = MatrixUtil.mul(MatrixUtil.transpose(this.A.getQ()), this.b);
                        break;
                    }
                    case 4: {
                        int rank = this.A.getRank();
                        if (rank == this.A.getColumnDim()) {
                            this.addSteppToHistory(this.step);
                            ((PanelMain.History)this.history.lastElement()).b = this.b = MatrixUtil.backwardInsert(this.A, this.b);
                        } else {
                            this.addSteppToHistory(this.step);
                            MatrixPanel R1 = this.A.getSubMatrix(0, rank, 0, rank);
                            MatrixPanel R2 = this.A.getSubMatrix(0, rank, rank, this.A.getColumnDim());
                            MatrixPanel V = MatrixUtil.backwardInsert(R1, R2);
                            MatrixPanel VV = MatrixUtil.mul(MatrixUtil.transpose(V), V);
                            VV.addMatrix(MatrixUtil.getIdentityMatrix(VV.getRowDim(), VV.getColumnDim(), VV.getView(), this.main, IrrationalNumber.class));
                            VV = this.choleskyDecom(VV);
                            MatrixPanel w = MatrixUtil.backwardInsert(R1, this.b.getSubMatrix(0, rank, 0, this.b.getColumnDim()));
                            MatrixPanel Vt_w = MatrixUtil.mul(MatrixUtil.transpose(V), w);
                            MatrixPanel x2 = MatrixUtil.forwordInsert(VV, Vt_w);
                            x2 = MatrixUtil.backwardInsert(MatrixUtil.transpose(VV), x2);
                            MatrixPanel x1 = w.subMatrix(MatrixUtil.mul(V, x2));
                            this.b = new MatrixPanel(x1.getRowDim() + x2.getRowDim(), this.b.getColumnDim());
                            int i = 0;
                            i = 0;
                            while (i < x1.getRowDim()) {
                                int j = 0;
                                while (j < this.b.getColumnDim()) {
                                    this.b.setValueAt(i, j, x1.getVauleAt(i, j));
                                    ++j;
                                }
                                ++i;
                            }
                            int k = 0;
                            while (k < x2.getRowDim()) {
                                int j = 0;
                                while (j < this.b.getColumnDim()) {
                                    this.b.setValueAt(i, j, x2.getVauleAt(k, j));
                                    ++j;
                                }
                                ++k;
                                ++i;
                            }
                            ((PanelMain.History)this.history.lastElement()).b = this.b;
                        }
                        break;
                    }
                    case 5: {
                        this.addSteppToHistory(this.step);
                        ((PanelMain.History)this.history.lastElement()).b = this.b = MatrixUtil.mul(MatrixUtil.transpose(this.A.getP()), this.b);
                        break;
                    }
                    default: {
                        this.addSteppToHistory(this.step);
                        throw new MatrixException(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelMain.0"), ExceptionLevel.INFO);
                    }
                }
            }
            catch (ExtendedException e) {
                this.removeStepFromHistory();
                throw e;
            }
        }
        finally {
            this.initGLS(this.step);
        }
    }

    private MatrixPanel choleskyDecom(MatrixPanel A) throws ExtendedException {
        int n = A.getRowDim();
        int i = 0;
        while (i < n) {
            int j = i + 1;
            while (j < n) {
                A.setValueAt(i, j, new IrrationalNumber(0.0, 2, (Component)this.main, this.panelControl.getPrecision()));
                ++j;
            }
            ++i;
        }
        MyNumber sum = null;
        int i2 = 0;
        while (i2 < n) {
            int j = 0;
            while (j < i2 - 1) {
                sum = A.getVauleAt(i2, j);
                int k = 0;
                while (k < j - 1) {
                    sum.sub(A.getVauleAt(i2, k).mul(A.getVauleAt(j, k)));
                    ++k;
                }
                A.setValueAt(i2, j, sum);
                ++i2;
            }
            sum = A.getVauleAt(i2, i2);
            int k = 0;
            while (k < i2 - 1) {
                sum.sub(A.getVauleAt(i2, k).mul(A.getVauleAt(i2, k)));
                ++k;
            }
            if (sum.getDoubleValue() <= 0.0) {
                throw new MatrixException("A nicht positiv definit", ExceptionLevel.ERROR);
            }
            A.setValueAt(i2, i2, sum.sqrt());
            ++i2;
        }
        return A;
    }

    protected void addSteppToHistoryImpl(int step) throws ExtendedException {
        if (step > 1) {
            this.A.setBorderByIndex(-1, -1, 0, null);
            this.A.setBorder(0, this.A.getRank(), 0, this.A.getRank(), AppletQRAlgorithmus.COLOR_R1);
            this.A.setBorder(0, this.A.getRank(), this.A.getRank(), this.A.getColumnDim(), AppletQRAlgorithmus.COLOR_R2);
        }
    }

    protected void setLabelAlgo() {
        URL url = this.getClass().getResource("/uibk/applets/QRAlgorithmus/GLS.html");
        this.panelControl.setLabelAlgo(url);
    }
}

